/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.FloatDataPoint;
import org.eclipse.om2m.sdt.datapoints.StringDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class Temperature
extends Module {
    private FloatDataPoint currentTemperature;
    private FloatDataPoint targetTemperature;
    private FloatDataPoint minValue;
    private FloatDataPoint maxValue;
    private FloatDataPoint stepValue;
    private StringDataPoint unit;

    public Temperature(String name, Domain domain, FloatDataPoint currentTemperature) {
        super(name, domain, (Identifiers)ModuleType.temperature);
        if (currentTemperature == null || !currentTemperature.getShortDefinitionType().equals(DatapointType.currentTemperature.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong currentTemperature datapoint: " + currentTemperature);
        }
        this.currentTemperature = currentTemperature;
        this.currentTemperature.setWritable(false);
        this.currentTemperature.setDoc("The current currentTemperature");
        this.addDataPoint((DataPoint)this.currentTemperature);
    }

    public Temperature(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (FloatDataPoint)dps.get(DatapointType.currentTemperature.getShortName()));
        StringDataPoint unit;
        FloatDataPoint stepValue;
        FloatDataPoint maxValue;
        FloatDataPoint minValue;
        FloatDataPoint targetTemperature = (FloatDataPoint)dps.get(DatapointType.targetTemperature.getShortName());
        if (targetTemperature != null) {
            this.setTargetTemperature(targetTemperature);
        }
        if ((minValue = (FloatDataPoint)dps.get(DatapointType.minValue.getShortName())) != null) {
            this.setMinValue(minValue);
        }
        if ((maxValue = (FloatDataPoint)dps.get(DatapointType.maxValue.getShortName())) != null) {
            this.setMaxValue(maxValue);
        }
        if ((stepValue = (FloatDataPoint)dps.get(DatapointType.stepValue.getShortName())) != null) {
            this.setStepValue(stepValue);
        }
        if ((unit = (StringDataPoint)dps.get(DatapointType.unit.getShortName())) != null) {
            this.setUnit(unit);
        }
    }

    public float getCurrentTemperature() throws DataPointException, AccessException {
        return ((Float)this.currentTemperature.getValue()).floatValue();
    }

    public void setTargetTemperature(FloatDataPoint dp) {
        this.targetTemperature = dp;
        this.targetTemperature.setWritable(true);
        this.targetTemperature.setOptional(true);
        this.targetTemperature.setDoc("The desired temperature to reach.");
        this.addDataPoint((DataPoint)this.targetTemperature);
    }

    public float getTargetTemperature() throws DataPointException, AccessException {
        if (this.targetTemperature == null) {
            throw new DataPointException("Not implemented");
        }
        return ((Float)this.targetTemperature.getValue()).floatValue();
    }

    public void setTargetTemperature(float b) throws DataPointException, AccessException {
        if (this.targetTemperature == null) {
            throw new DataPointException("Not implemented");
        }
        this.targetTemperature.setValue((Object)Float.valueOf(b));
    }

    public void setMinValue(FloatDataPoint dp) {
        this.minValue = dp;
        this.minValue.setOptional(true);
        this.minValue.setWritable(false);
        this.minValue.setDoc("Minimum value of targetTemperature.");
        this.addDataPoint((DataPoint)this.minValue);
    }

    public float getMinValue() throws DataPointException, AccessException {
        if (this.minValue == null) {
            throw new DataPointException("Not implemented");
        }
        return ((Float)this.minValue.getValue()).floatValue();
    }

    public void setMaxValue(FloatDataPoint dp) {
        this.maxValue = dp;
        this.maxValue.setOptional(true);
        this.maxValue.setWritable(false);
        this.maxValue.setDoc("Maximum value of targetTemperature.");
        this.addDataPoint((DataPoint)this.maxValue);
    }

    public float getMaxValue() throws DataPointException, AccessException {
        if (this.maxValue == null) {
            throw new DataPointException("Not implemented");
        }
        return ((Float)this.maxValue.getValue()).floatValue();
    }

    public void setStepValue(FloatDataPoint dp) {
        this.stepValue = dp;
        this.stepValue.setOptional(true);
        this.stepValue.setWritable(false);
        this.stepValue.setDoc("Step value allowed for targetTemperature.");
        this.addDataPoint((DataPoint)this.stepValue);
    }

    public float getStepValue() throws DataPointException, AccessException {
        if (this.stepValue == null) {
            throw new DataPointException("Not implemented");
        }
        return ((Float)this.stepValue.getValue()).floatValue();
    }

    public void setUnit(StringDataPoint dp) {
        this.unit = dp;
        this.unit.setOptional(true);
        this.unit.setWritable(false);
        this.unit.setDoc("The list of units for the temperature values. The default is Celsius only [C].");
        this.addDataPoint((DataPoint)this.unit);
    }

    public String getUnit() throws DataPointException, AccessException {
        if (this.unit == null) {
            throw new DataPointException("Not implemented");
        }
        return (String)this.unit.getValue();
    }
}

