/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.testsuite.flexcontainer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.exceptions.Om2mException;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.BinarySwitchFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.flexcontainer.service.FlexContainerService;
import org.eclipse.om2m.testsuite.flexcontainer.FlexContainerTestSuite;
import org.eclipse.om2m.testsuite.flexcontainer.TestReport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class CallbackTest
extends FlexContainerTestSuite {
    private String parentLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
    private String flexContainerName = "BinarySwitch_" + System.currentTimeMillis();
    private String flexContainerLocation = String.valueOf(this.parentLocation) + "/" + this.flexContainerName;
    private BinarySwitchFlexContainer flexContainer;
    private BundleContext bundleContext;
    private ServiceRegistration flexContainerServiceRegistration;
    private int numberOfGetAttributeValue = 0;

    public CallbackTest(CseService pCseService, BundleContext pBundleContext) {
        super(pCseService);
        this.bundleContext = pBundleContext;
        this.flexContainer = new BinarySwitchFlexContainer();
        this.flexContainer.setName(this.flexContainerName);
        CustomAttribute powerState = new CustomAttribute();
        powerState.setCustomAttributeValue("false");
        powerState.setCustomAttributeName("powSe");
        this.flexContainer.getCustomAttributes().add(powerState);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)this.flexContainer, this.parentLocation, Constants.ADMIN_REQUESTING_ENTITY);
        this.flexContainer = (BinarySwitchFlexContainer)response.getContent();
    }

    @Override
    protected String getTestSuiteName() {
        return "CallbackTest";
    }

    public void testCallback_Retrieve() {
        BinarySwitchFlexContainer retrievedFlexContainer;
        this.numberOfGetAttributeValue = 0;
        FlexContainerService fcs = new FlexContainerService(){

            public void setCustomAttributeValues(List<CustomAttribute> customAttributes, RequestPrimitive requestPrimitive) throws Om2mException {
                throw new Om2mException("not allowed", ResponseStatusCode.NOT_IMPLEMENTED);
            }

            public String getFlexContainerLocation() {
                return CallbackTest.this.flexContainer.getResourceID();
            }

            public String getCustomAttributeValue(String customAttributeName) throws Om2mException {
                if (!customAttributeName.equals("powSe")) {
                    throw new Om2mException("unexpected getCustomAttributeValue for attributeName=" + customAttributeName, ResponseStatusCode.NOT_IMPLEMENTED);
                }
                CallbackTest callbackTest = CallbackTest.this;
                callbackTest.numberOfGetAttributeValue = callbackTest.numberOfGetAttributeValue + 1;
                return Boolean.TRUE.toString();
            }

            public Map<String, String> getCustomAttributeValues(List<String> customAttributeNames) throws Om2mException {
                if (customAttributeNames.size() != 1 || customAttributeNames.get(0).equals("powSe")) {
                    throw new Om2mException("unexpected getCustomAttributeValue for attributeName=" + customAttributeNames, ResponseStatusCode.NOT_IMPLEMENTED);
                }
                CallbackTest callbackTest = CallbackTest.this;
                callbackTest.numberOfGetAttributeValue = callbackTest.numberOfGetAttributeValue + 1;
                HashMap<String, String> ret = new HashMap<String, String>();
                ret.put("powSe", Boolean.TRUE.toString());
                return ret;
            }
        };
        this.flexContainerServiceRegistration = this.bundleContext.registerService(FlexContainerService.class, (Object)fcs, null);
        ResponsePrimitive response = this.sendRetrieveRequest(this.flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            retrievedFlexContainer = (BinarySwitchFlexContainer)response.getContent();
            if (!retrievedFlexContainer.getCustomAttribute("powSe").getCustomAttributeValue().equals(Boolean.TRUE.toString())) {
                this.createTestReport("testCallback", TestReport.Status.KO, "invalid powerState value, expecting true", null);
                return;
            }
            if (this.numberOfGetAttributeValue != 1) {
                this.createTestReport("testCallback", TestReport.Status.KO, "invalid numberOfGetAttributeValue, expecting 1, found " + this.numberOfGetAttributeValue, null);
                return;
            }
        }
        this.flexContainerServiceRegistration.unregister();
        response = this.sendRetrieveRequest(this.flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            retrievedFlexContainer = (BinarySwitchFlexContainer)response.getContent();
            if (!retrievedFlexContainer.getCustomAttribute("powSe").getCustomAttributeValue().equals(Boolean.TRUE.toString())) {
                this.createTestReport("testCallback", TestReport.Status.KO, "invalid powerState value, expecting true", null);
                return;
            }
            if (this.numberOfGetAttributeValue != 1) {
                this.createTestReport("testCallback", TestReport.Status.KO, "invalid numberOfGetAttributeValue, expecting 1, found " + this.numberOfGetAttributeValue, null);
                return;
            }
        }
        this.createTestReport("testCallback_Retrieve", TestReport.Status.OK, null, null);
    }

    public void testCallback_update() {
        this.numberOfGetAttributeValue = 0;
        FlexContainerService fcs = new FlexContainerService(){

            public void setCustomAttributeValues(List<CustomAttribute> customAttributes, RequestPrimitive requestPrimitive) throws Om2mException {
                if (customAttributes.isEmpty()) {
                    throw new Om2mException("not allowed. Missing powerState", ResponseStatusCode.INVALID_ARGUMENTS);
                }
                if (customAttributes.size() != 1) {
                    throw new Om2mException("not allowed. Invalid size of CustomAttribute", ResponseStatusCode.INVALID_ARGUMENTS);
                }
                CustomAttribute powerStateCA = customAttributes.get(0);
                if (!"powSe".equals(powerStateCA.getCustomAttributeName())) {
                    throw new Om2mException("not allowed", ResponseStatusCode.INVALID_ARGUMENTS);
                }
                Boolean booleanValue = null;
                try {
                    booleanValue = new Boolean(powerStateCA.getCustomAttributeValue());
                }
                catch (Exception e) {
                    throw new Om2mException("not allowed", ResponseStatusCode.INVALID_ARGUMENTS);
                }
                if (!Boolean.TRUE.equals(booleanValue)) {
                    throw new Om2mException("not allowed", ResponseStatusCode.INVALID_ARGUMENTS);
                }
            }

            public String getFlexContainerLocation() {
                return CallbackTest.this.flexContainer.getResourceID();
            }

            public String getCustomAttributeValue(String customAttributeName) throws Om2mException {
                if (!customAttributeName.equals("powSe")) {
                    throw new Om2mException("unexpected getCustomAttributeValue for attributeName=" + customAttributeName, ResponseStatusCode.NOT_IMPLEMENTED);
                }
                CallbackTest callbackTest = CallbackTest.this;
                callbackTest.numberOfGetAttributeValue = callbackTest.numberOfGetAttributeValue + 1;
                return Boolean.TRUE.toString();
            }

            public Map<String, String> getCustomAttributeValues(List<String> customAttributeNames) throws Om2mException {
                if (customAttributeNames.size() != 1 || customAttributeNames.get(0).equals("powSe")) {
                    throw new Om2mException("unexpected getCustomAttributeValue for attributeName=" + customAttributeNames, ResponseStatusCode.NOT_IMPLEMENTED);
                }
                CallbackTest callbackTest = CallbackTest.this;
                callbackTest.numberOfGetAttributeValue = callbackTest.numberOfGetAttributeValue + 1;
                HashMap<String, String> ret = new HashMap<String, String>();
                ret.put("powSe", Boolean.TRUE.toString());
                return ret;
            }
        };
        this.flexContainerServiceRegistration = this.bundleContext.registerService(FlexContainerService.class, (Object)fcs, null);
        BinarySwitchFlexContainer toBeUpdated = new BinarySwitchFlexContainer();
        CustomAttribute powerState = new CustomAttribute();
        powerState.setCustomAttributeValue("true");
        powerState.setCustomAttributeName("powSe");
        toBeUpdated.getCustomAttributes().add(powerState);
        ResponsePrimitive response = this.sendUpdateFlexContainerRequest(this.flexContainerLocation, (AbstractFlexContainer)toBeUpdated);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.UPDATED)) {
            this.createTestReport("testCallback_update", TestReport.Status.KO, "unable to update FlexContainer:" + response.getContent(), null);
            return;
        }
        BinarySwitchFlexContainer updatedFlexContainer = (BinarySwitchFlexContainer)response.getContent();
        if (!updatedFlexContainer.getCustomAttribute("powSe").getCustomAttributeValue().equals(Boolean.TRUE.toString())) {
            this.createTestReport("testCallback_update", TestReport.Status.KO, "invalid for powerState, expecting TRUE, found" + updatedFlexContainer.getCustomAttribute("powSe").getCustomAttributeValue(), null);
            return;
        }
        response = this.sendRetrieveRequest(this.flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            BinarySwitchFlexContainer retrievedFlexContainer = (BinarySwitchFlexContainer)response.getContent();
            if (!retrievedFlexContainer.getCustomAttribute("powSe").getCustomAttributeValue().equals(Boolean.TRUE.toString())) {
                this.createTestReport("testCallback", TestReport.Status.KO, "invalid powerState value, expecting true", null);
                return;
            }
            if (this.numberOfGetAttributeValue != 1) {
                this.createTestReport("testCallback", TestReport.Status.KO, "invalid numberOfGetAttributeValue, expecting 1, found " + this.numberOfGetAttributeValue, null);
                return;
            }
        }
        this.createTestReport("testCallback_update", TestReport.Status.OK, null, null);
    }
}

