/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.monitoring.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.AccessControl;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.NotificationContentType;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.AccessControlPolicy;
import org.eclipse.om2m.commons.resource.AccessControlRule;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.ContentInstance;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.SetOfAcrs;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.interworking.service.InterworkingService;
import org.eclipse.om2m.sdt.home.monitoring.servlet.SessionManager;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class AeRegistration
implements InterworkingService {
    private static Log LOGGER = LogFactory.getLog(AeRegistration.class);
    private static final String HOME_MONITORING_NAME = "SDT_Home_Monitoring_Application";
    private static final String FRIENDLY_HOME_MONITORING_NAME = "Home Monitoring Application";
    private static final String ACP_HOME_MONITORING_NAME = "SDT_Home_Monitoring_Application_ACP";
    private static final String HOME_MONITORING_RESOURCE_ID = "ResourceID/SDT_Home_Monitoring_Application";
    private static final String RESOURCE_TYPE = "ResourceType/Application";
    private static final String POA = "HomeMonitoringPOA";
    private static final AeRegistration INSTANCE = new AeRegistration();
    private CseService cseService;
    private AE registeredApplication;
    private AccessControlPolicy registeredAcp;
    private Map<String, Set<String>> subscriptionsPerSessions;
    private Map<String, List<JSONObject>> notifications = new HashMap<String, List<JSONObject>>();
    private Map<String, String> subscriptions = new HashMap<String, String>();
    private Map<String, String> subscribedToResourcesSet = new HashMap<String, String>();

    public static AeRegistration getInstance() {
        return INSTANCE;
    }

    private AeRegistration() {
        this.subscriptionsPerSessions = new HashMap<String, Set<String>>();
    }

    public void setCseService(CseService pCseService) {
        this.cseService = pCseService;
    }

    public boolean createAe() {
        Container presentationUrlContainer;
        if (this.cseService == null) {
            return false;
        }
        if (!this.createACP()) {
            return false;
        }
        RequestPrimitive request = new RequestPrimitive();
        AE ae = new AE();
        ae.setName(HOME_MONITORING_NAME);
        ae.setAppName(FRIENDLY_HOME_MONITORING_NAME);
        ae.setAppID(HOME_MONITORING_NAME);
        ae.setRequestReachability(Boolean.TRUE);
        ae.getLabels().add(HOME_MONITORING_RESOURCE_ID);
        ae.getLabels().add(RESOURCE_TYPE);
        ae.getAccessControlPolicyIDs().add(this.registeredAcp.getResourceID());
        ae.getPointOfAccess().add(POA);
        request.setOperation(Operation.CREATE);
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTargetId("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME);
        request.setResourceType(2);
        request.setReturnContentType("application/obj");
        request.setRequestContentType("application/obj");
        request.setContent((Object)ae);
        ResponsePrimitive response = this.cseService.doRequest(request);
        if (!ResponseStatusCode.CREATED.equals(response.getResponseStatusCode())) {
            return false;
        }
        try {
            this.registeredApplication = (AE)response.getContent();
        }
        catch (ClassCastException e) {
            return false;
        }
        Container iconContainer = this.createContainer(this.registeredApplication.getResourceID(), "ICON");
        if (iconContainer != null) {
            String logoUrlSuffix = "/Home_Monitoring_Application/webapps/images/logo.png";
            this.createContentInstance(iconContainer, logoUrlSuffix);
        }
        if ((presentationUrlContainer = this.createContainer(this.registeredApplication.getResourceID(), "PRESENTATION_URL")) != null) {
            String presentationUrlSuffix = "/Home_Monitoring_Application/webapps/login.html";
            this.createContentInstance(presentationUrlContainer, presentationUrlSuffix);
        }
        return true;
    }

    public void deleteAe() {
        this.deleteAllSubscriptions();
        if (this.registeredApplication == null) {
            return;
        }
        if (this.cseService == null) {
            return;
        }
        RequestPrimitive request = new RequestPrimitive();
        request.setOperation(Operation.DELETE);
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTargetId(this.registeredApplication.getResourceID());
        this.cseService.doRequest(request);
        this.deleteAcp();
    }

    private boolean createACP() {
        LOGGER.info((Object)"createACP");
        RequestPrimitive request = new RequestPrimitive();
        AccessControlPolicy acp = new AccessControlPolicy();
        acp.setName(ACP_HOME_MONITORING_NAME);
        acp.setPrivileges(new SetOfAcrs());
        AccessControlRule adminAccessControlRule = new AccessControlRule();
        adminAccessControlRule.setAccessControlOperations(AccessControl.ALL);
        adminAccessControlRule.getAccessControlOriginators().add(Constants.ADMIN_REQUESTING_ENTITY);
        acp.getPrivileges().getAccessControlRule().add(adminAccessControlRule);
        acp.setSelfPrivileges(new SetOfAcrs());
        acp.getSelfPrivileges().getAccessControlRule().add(adminAccessControlRule);
        request.setOperation(Operation.CREATE);
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTargetId("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME);
        request.setResourceType(1);
        request.setReturnContentType("application/obj");
        request.setRequestContentType("application/obj");
        request.setContent((Object)acp);
        ResponsePrimitive response = this.cseService.doRequest(request);
        BigInteger code = response.getResponseStatusCode();
        if (!ResponseStatusCode.CREATED.equals(code)) {
            LOGGER.info((Object)("createACP KO " + code));
            return false;
        }
        try {
            this.registeredAcp = (AccessControlPolicy)response.getContent();
            LOGGER.info((Object)("createACP OK " + this.registeredAcp));
            return true;
        }
        catch (ClassCastException e) {
            LOGGER.info((Object)("createACP KO " + e));
            return false;
        }
    }

    public void deleteAcp() {
        if (this.registeredAcp == null) {
            return;
        }
        LOGGER.info((Object)("deleteAcp " + this.registeredAcp));
        RequestPrimitive request = new RequestPrimitive();
        request.setOperation(Operation.DELETE);
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTargetId(this.registeredAcp.getResourceID());
        this.cseService.doRequest(request);
    }

    private Container createContainer(String resourceID, String name) {
        Container container = new Container();
        container.setName(name);
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTargetId(resourceID);
        request.setOperation(Operation.CREATE);
        request.setResourceType(3);
        request.setReturnContentType("application/obj");
        request.setRequestContentType("application/obj");
        request.setContent((Object)container);
        ResponsePrimitive response = this.cseService.doRequest(request);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            return null;
        }
        return (Container)response.getContent();
    }

    private void createContentInstance(Container iconContainer, String value) {
        ContentInstance contentInstance = new ContentInstance();
        contentInstance.setContentInfo("paint");
        contentInstance.setContent(value);
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTargetId(iconContainer.getResourceID());
        request.setOperation(Operation.CREATE);
        request.setResourceType(4);
        request.setReturnContentType("application/obj");
        request.setRequestContentType("application/obj");
        request.setContent((Object)contentInstance);
        ResponsePrimitive response = this.cseService.doRequest(request);
    }

    public ResponsePrimitive doExecute(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        if (!request.getOperation().equals(Operation.NOTIFY)) {
            response.setResponseStatusCode(ResponseStatusCode.NOT_IMPLEMENTED);
            return response;
        }
        String content = null;
        JSONParser parser = new JSONParser();
        JSONObject notification = null;
        try {
            content = (String)request.getContent();
            notification = (JSONObject)parser.parse(content);
        }
        catch (ClassCastException | ParseException e) {
            response.setResponseStatusCode(ResponseStatusCode.BAD_REQUEST);
            return response;
        }
        this.addNotification(notification);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    public String getAPOCPath() {
        return POA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JSONObject> getNotificationsAndClears(String sessionId) {
        List<JSONObject> notifsPerSession;
        ArrayList<JSONObject> notificationsToBeReturned = new ArrayList<JSONObject>();
        Object object = this.notifications;
        synchronized (object) {
            notifsPerSession = this.notifications.get(sessionId);
        }
        if (notifsPerSession != null) {
            object = notifsPerSession;
            synchronized (object) {
                notificationsToBeReturned.addAll(notifsPerSession);
                notifsPerSession.clear();
            }
        }
        return notificationsToBeReturned;
    }

    private void addNotification(JSONObject notification) {
        LOGGER.debug((Object)"add notification from subscription ");
        String subscriptionId = (String)((JSONObject)notification.get((Object)"m2m:sgn")).get((Object)"m2m:sur");
        for (Map.Entry<String, Set<String>> entry : this.subscriptionsPerSessions.entrySet()) {
            if (!entry.getValue().contains(subscriptionId)) continue;
            this.addNotification(entry.getKey(), notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNotification(String sessionId, JSONObject notification) {
        List<JSONObject> notifsPerSession = null;
        Object object = this.notifications;
        synchronized (object) {
            notifsPerSession = this.notifications.get(sessionId);
            if (notifsPerSession == null) {
                notifsPerSession = new ArrayList<JSONObject>();
                this.notifications.put(sessionId, notifsPerSession);
            }
        }
        object = notifsPerSession;
        synchronized (object) {
            notifsPerSession.add(notification);
        }
    }

    public boolean createSubscription(String resourceId, String sessionId) {
        if (resourceId == null || sessionId == null || !SessionManager.getInstance().checkTokenExists(sessionId)) {
            return false;
        }
        String subscriptionId = null;
        subscriptionId = this.checkIfSubscriptionExists(resourceId);
        if (subscriptionId != null) {
            this.associateSubscriptionAndSession(subscriptionId, sessionId);
            return true;
        }
        Subscription subscription = new Subscription();
        subscription.setNotificationContentType(NotificationContentType.WHOLE_RESOURCE);
        subscription.getNotificationURI().add(this.registeredApplication.getResourceID());
        RequestPrimitive request = new RequestPrimitive();
        request.setOperation(Operation.CREATE);
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTargetId(resourceId);
        request.setResourceType(23);
        request.setReturnContentType("application/json");
        request.setRequestContentType("application/obj");
        request.setContent((Object)subscription);
        ResponsePrimitive response = this.cseService.doRequest(request);
        if (!ResponseStatusCode.CREATED.equals(response.getResponseStatusCode())) {
            return false;
        }
        String content = (String)response.getContent();
        JSONParser parser = new JSONParser();
        try {
            JSONObject createdSubscription = (JSONObject)parser.parse(content);
            subscriptionId = (String)((JSONObject)createdSubscription.get((Object)"m2m:sub")).get((Object)"ri");
            this.addSubscription(subscriptionId, resourceId);
            this.associateSubscriptionAndSession(subscriptionId, sessionId);
        }
        catch (ParseException e) {
            LOGGER.error((Object)"unable to parse subscription json payload", (Throwable)e);
            return false;
        }
        catch (NullPointerException e) {
            LOGGER.error((Object)"unable to retrieve subscription object", (Throwable)e);
            return false;
        }
        catch (ClassCastException e) {
            LOGGER.error((Object)"unable to cast subscription object", (Throwable)e);
            return false;
        }
        return true;
    }

    private void deleteSubscription(String subscriptionId) {
        RequestPrimitive request = new RequestPrimitive();
        request.setOperation(Operation.DELETE);
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTargetId(subscriptionId);
        request.setResourceType(23);
        request.setReturnContentType("application/obj");
        request.setRequestContentType("application/obj");
        ResponsePrimitive response = this.cseService.doRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSubscription(String subscriptionId, String resourceId) {
        Map<String, String> map = this.subscriptions;
        synchronized (map) {
            this.subscriptions.put(subscriptionId, resourceId);
        }
        map = this.subscribedToResourcesSet;
        synchronized (map) {
            this.subscribedToResourcesSet.put(resourceId, subscriptionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAllSubscriptions() {
        Map<String, String> map = this.subscriptions;
        synchronized (map) {
            for (String subId : this.subscriptions.keySet()) {
                this.deleteSubscription(subId);
            }
            this.subscriptions.clear();
        }
        map = this.subscribedToResourcesSet;
        synchronized (map) {
            this.subscribedToResourcesSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkIfSubscriptionExists(String subscribedToResourceId) {
        Map<String, String> map = this.subscribedToResourcesSet;
        synchronized (map) {
            return this.subscribedToResourcesSet.get(subscribedToResourceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void associateSubscriptionAndSession(String subscriptionId, String sessionId) {
        Set<String> subscriptionIds = null;
        Object object = this.subscriptionsPerSessions;
        synchronized (object) {
            subscriptionIds = this.subscriptionsPerSessions.get(sessionId);
            if (subscriptionIds == null) {
                subscriptionIds = new HashSet<String>();
                this.subscriptionsPerSessions.put(sessionId, subscriptionIds);
            }
        }
        object = subscriptionIds;
        synchronized (object) {
            subscriptionIds.add(subscriptionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deassociateSubscriptionAndSessions(String sessionId) {
        Map<String, Set<String>> map = this.subscriptionsPerSessions;
        synchronized (map) {
            this.subscriptionsPerSessions.remove(sessionId);
        }
        List<JSONObject> notifsPerSession = null;
        Object object = this.notifications;
        synchronized (object) {
            notifsPerSession = this.notifications.remove(sessionId);
        }
        if (notifsPerSession != null) {
            object = notifsPerSession;
            synchronized (object) {
                notifsPerSession.clear();
            }
        }
    }
}

