/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sample.sdt.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.ipe.sample.sdt.monitor.SampleMonitor;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.events.SDTEventListener;
import org.eclipse.om2m.sdt.events.SDTNotification;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DeviceType;
import org.eclipse.om2m.sdt.home.types.ModuleType;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class GUI
extends JFrame
implements SDTEventListener {
    static Log LOGGER = LogFactory.getLog(GUI.class);
    private static final long serialVersionUID = 1L;
    static ImageIcon iconLampON = new ImageIcon(FrameworkUtil.getBundle(GUI.class).getResource("images/Lamp_ON.png"));
    static ImageIcon iconLampOFF = new ImageIcon(FrameworkUtil.getBundle(GUI.class).getResource("images/Lamp_OFF.png"));
    static ImageIcon iconButtonON = new ImageIcon(FrameworkUtil.getBundle(GUI.class).getResource("images/Btn_ON.png"));
    static ImageIcon iconButtonOFF = new ImageIcon(FrameworkUtil.getBundle(GUI.class).getResource("images/Btn_OFF.png"));
    static GUI frame;
    static JLabel LABEL_LAMP_0;
    static JLabel LABEL_LAMP_1;
    static String LAMP_0;
    static String LAMP_1;
    private static final int B = 10;
    private static final int W0 = 320;
    private static final int W1 = 200;
    private static final int H0 = 250;
    private static final int WL = 150;
    private static final int HL = 230;
    private static final int WB = 120;
    private static final int HB = 150;
    private JPanel contentPanel;
    private JTextArea redArea;
    private JTextArea greenArea;
    private JTextArea blueArea;
    private int red = 255;
    private int green = 255;
    private int blue = 0;

    static {
        LABEL_LAMP_0 = new JLabel("");
        LABEL_LAMP_1 = new JLabel("");
        LAMP_0 = "LAMP_0";
        LAMP_1 = "LAMP_1";
    }

    public static void init(final BundleContext bundleContext) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    frame = new GUI(bundleContext, null);
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"GUI init Error", (Throwable)e);
                }
            }
        });
    }

    public static void stop() {
        frame.setVisible(false);
        frame.dispose();
    }

    private GUI(BundleContext bundleContext) {
        this.setLocationByPlatform(true);
        this.setVisible(false);
        this.setResizable(false);
        this.setTitle("Sample Simulated IPE");
        this.setDefaultCloseOperation(0);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 500) / 2, (screenSize.height - 570) / 2, 560, 560);
        this.contentPanel = new JPanel();
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPanel);
        this.contentPanel.setLayout(null);
        JPanel panel_Lamp0 = new JPanel();
        panel_Lamp0.setBounds(10, 10, 320, 250);
        this.contentPanel.add(panel_Lamp0);
        panel_Lamp0.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        panel_Lamp0.setLayout(null);
        LABEL_LAMP_0.setIcon(iconLampOFF);
        LABEL_LAMP_0.setHorizontalTextPosition(0);
        LABEL_LAMP_0.setHorizontalAlignment(0);
        LABEL_LAMP_0.setBounds(10, 10, 150, 230);
        LABEL_LAMP_0.setBorder(new LineBorder(new Color(this.red, this.green, this.blue), 5, true));
        panel_Lamp0.add(LABEL_LAMP_0);
        JButton button_Lamp0 = new JButton();
        button_Lamp0.setOpaque(false);
        button_Lamp0.setPressedIcon(iconButtonON);
        button_Lamp0.setIcon(iconButtonOFF);
        button_Lamp0.setBounds(170, 50, 120, 150);
        panel_Lamp0.add(button_Lamp0);
        button_Lamp0.setMinimumSize(new Dimension(30, 23));
        button_Lamp0.setMaximumSize(new Dimension(30, 23));
        button_Lamp0.setPreferredSize(new Dimension(30, 23));
        JLabel labelSwitcher0 = new JLabel("Switch LAMP_0");
        labelSwitcher0.setFont(new Font("Vani", 3, 14));
        labelSwitcher0.setFocusCycleRoot(true);
        labelSwitcher0.setBorder(null);
        labelSwitcher0.setAutoscrolls(true);
        labelSwitcher0.setBounds(170, 200, 120, 30);
        panel_Lamp0.add(labelSwitcher0);
        button_Lamp0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            SampleMonitor.switchLamp(LAMP_0);
                        }
                        catch (DataPointException e) {
                            LOGGER.warn((Object)"Data error", (Throwable)e);
                        }
                        catch (AccessException e) {
                            LOGGER.warn((Object)"Access error", (Throwable)e);
                        }
                    }
                }.start();
            }
        });
        JPanel panel_Lamp1 = new JPanel();
        panel_Lamp1.setBounds(10, 270, 320, 250);
        this.contentPanel.add(panel_Lamp1);
        panel_Lamp1.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        panel_Lamp1.setLayout(null);
        LABEL_LAMP_1.setIcon(iconLampOFF);
        LABEL_LAMP_1.setHorizontalTextPosition(0);
        LABEL_LAMP_1.setHorizontalAlignment(0);
        LABEL_LAMP_1.setBounds(10, 10, 150, 230);
        LABEL_LAMP_1.setBorder(new LineBorder(new Color(this.red, this.green, this.blue), 5, true));
        panel_Lamp1.add(LABEL_LAMP_1);
        JButton button_Lamp1 = new JButton();
        button_Lamp1.setOpaque(false);
        button_Lamp1.setPressedIcon(iconButtonON);
        button_Lamp1.setIcon(iconButtonOFF);
        button_Lamp1.setBounds(170, 50, 120, 150);
        panel_Lamp1.add(button_Lamp1);
        button_Lamp1.setMinimumSize(new Dimension(30, 23));
        button_Lamp1.setMaximumSize(new Dimension(30, 23));
        button_Lamp1.setPreferredSize(new Dimension(30, 23));
        JLabel labelSwitcher1 = new JLabel("Switch LAMP_1");
        labelSwitcher1.setFont(new Font("Vani", 3, 14));
        labelSwitcher1.setFocusCycleRoot(true);
        labelSwitcher1.setBorder(null);
        labelSwitcher1.setAutoscrolls(true);
        labelSwitcher1.setBounds(170, 200, 120, 30);
        panel_Lamp1.add(labelSwitcher1);
        button_Lamp1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            SampleMonitor.switchLamp(LAMP_1);
                        }
                        catch (DataPointException e) {
                            LOGGER.warn((Object)"Data error", (Throwable)e);
                        }
                        catch (AccessException e) {
                            LOGGER.warn((Object)"Access error", (Throwable)e);
                        }
                    }
                }.start();
            }
        });
        JPanel switchAllPanel = new JPanel();
        switchAllPanel.setBounds(340, 10, 200, 250);
        this.contentPanel.add(switchAllPanel);
        switchAllPanel.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        switchAllPanel.setLayout(null);
        JButton buttonAllLamp = new JButton();
        buttonAllLamp.setOpaque(false);
        buttonAllLamp.setPressedIcon(iconButtonON);
        buttonAllLamp.setIcon(iconButtonOFF);
        buttonAllLamp.setBounds(40, 50, 120, 150);
        switchAllPanel.add(buttonAllLamp);
        buttonAllLamp.setMinimumSize(new Dimension(30, 23));
        buttonAllLamp.setMaximumSize(new Dimension(30, 23));
        buttonAllLamp.setPreferredSize(new Dimension(30, 23));
        JLabel labelSwitchAll = new JLabel("Switch All");
        labelSwitchAll.setAutoscrolls(true);
        labelSwitchAll.setFont(new Font("Vani", 3, 14));
        labelSwitchAll.setFocusCycleRoot(true);
        labelSwitchAll.setBorder(null);
        labelSwitchAll.setBounds(60, 210, 120, 30);
        switchAllPanel.add(labelSwitchAll);
        buttonAllLamp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            SampleMonitor.switchAll();
                        }
                        catch (DataPointException e) {
                            LOGGER.warn((Object)"Data error", (Throwable)e);
                        }
                        catch (AccessException e) {
                            LOGGER.warn((Object)"Access error", (Throwable)e);
                        }
                    }
                }.start();
            }
        });
        JPanel colorPanel = new JPanel();
        colorPanel.setBounds(340, 270, 200, 250);
        this.contentPanel.add(colorPanel);
        colorPanel.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        colorPanel.setLayout(null);
        JLabel colorLabel = new JLabel("Set Color");
        colorLabel.setFont(new Font("Vani", 3, 14));
        colorLabel.setFocusCycleRoot(true);
        colorLabel.setBorder(null);
        colorLabel.setAutoscrolls(true);
        colorLabel.setBounds(60, 20, 200, 30);
        colorPanel.add(colorLabel);
        JLabel redLabel = new JLabel("Red (0-255)");
        redLabel.setFont(new Font("Vani", 2, 14));
        redLabel.setFocusCycleRoot(true);
        redLabel.setBorder(null);
        redLabel.setAutoscrolls(true);
        redLabel.setBounds(20, 60, 100, 30);
        colorPanel.add(redLabel);
        this.redArea = new JTextArea();
        this.redArea.setBorder(null);
        this.redArea.setAutoscrolls(true);
        this.redArea.setBounds(120, 60, 30, 20);
        this.redArea.setText("" + this.red);
        colorPanel.add(this.redArea);
        JLabel greenLabel = new JLabel("Green (0-255)");
        greenLabel.setFont(new Font("Vani", 2, 14));
        greenLabel.setFocusCycleRoot(true);
        greenLabel.setBorder(null);
        greenLabel.setAutoscrolls(true);
        greenLabel.setBounds(20, 100, 100, 30);
        colorPanel.add(greenLabel);
        this.greenArea = new JTextArea();
        this.greenArea.setBorder(null);
        this.greenArea.setAutoscrolls(true);
        this.greenArea.setBounds(120, 100, 30, 20);
        this.greenArea.setText("" + this.green);
        colorPanel.add(this.greenArea);
        JLabel blueLabel = new JLabel("Blue (0-255)");
        blueLabel.setFont(new Font("Vani", 2, 14));
        blueLabel.setFocusCycleRoot(true);
        blueLabel.setBorder(null);
        blueLabel.setAutoscrolls(true);
        blueLabel.setBounds(20, 140, 100, 30);
        colorPanel.add(blueLabel);
        this.blueArea = new JTextArea();
        this.blueArea.setBorder(null);
        this.blueArea.setAutoscrolls(true);
        this.blueArea.setBounds(120, 140, 30, 20);
        this.blueArea.setText("" + this.blue);
        colorPanel.add(this.blueArea);
        JButton colorButton = new JButton();
        colorButton.setOpaque(false);
        colorButton.setText("OK");
        colorButton.setBounds(60, 190, 60, 30);
        colorPanel.add(colorButton);
        colorButton.setMinimumSize(new Dimension(30, 23));
        colorButton.setMaximumSize(new Dimension(30, 23));
        colorButton.setPreferredSize(new Dimension(30, 23));
        colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            LOGGER.info((Object)"Set color");
                            SampleMonitor.setColor(Integer.parseInt(GUI.this.redArea.getText().trim()), Integer.parseInt(GUI.this.greenArea.getText().trim()), Integer.parseInt(GUI.this.blueArea.getText().trim()));
                        }
                        catch (DataPointException e) {
                            LOGGER.warn((Object)"Data error", (Throwable)e);
                        }
                        catch (AccessException e) {
                            LOGGER.warn((Object)"Access error", (Throwable)e);
                        }
                        catch (Exception e) {
                            LOGGER.warn((Object)"Unknown error", (Throwable)e);
                        }
                    }
                }.start();
            }
        });
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("sdt.devices.definitions", DeviceType.deviceLight.getDefinition());
        bundleContext.registerService(SDTEventListener.class.getName(), (Object)this, props);
    }

    public void handleNotification(SDTNotification notif) {
        if (notif != null) {
            String moduleDef = ((Module)notif.getModule()).getDefinition();
            if (moduleDef.equals(ModuleType.binarySwitch.getDefinition())) {
                LOGGER.info((Object)("Received switch notif " + notif.getValue() + " for " + notif.getDevice().getId()));
                JLabel label = notif.getDevice().getId().endsWith("0") ? LABEL_LAMP_0 : LABEL_LAMP_1;
                label.setIcon((Boolean)notif.getValue() != false ? iconLampON : iconLampOFF);
            } else if (moduleDef.equals(ModuleType.colour.getDefinition()) && notif.getDevice().getId().endsWith("0")) {
                String rgb = notif.getDataPoint().getName();
                int val = (Integer)notif.getValue();
                LOGGER.info((Object)("Received color notif " + val + " for " + rgb));
                if (rgb.equals("red")) {
                    this.red = val;
                } else if (rgb.equals("green")) {
                    this.green = val;
                } else if (rgb.equals("blue")) {
                    this.blue = val;
                }
                LABEL_LAMP_0.setBorder(new LineBorder(new Color(this.red, this.green, this.blue), 5, true));
                LABEL_LAMP_1.setBorder(new LineBorder(new Color(this.red, this.green, this.blue), 5, true));
            }
        }
    }

    public void setAuthenticationThreadGroup(ThreadGroup group) {
    }

    /* synthetic */ GUI(BundleContext bundleContext, GUI gUI) {
        this(bundleContext);
    }
}

