/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.mocked.devices;

import java.util.List;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Event;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.devices.SmokeDetector;
import org.eclipse.om2m.sdt.home.mocked.devices.Activator;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedDevice;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedFaultDetection;
import org.eclipse.om2m.sdt.home.modules.AbstractAlarmSensor;
import org.eclipse.om2m.sdt.home.modules.SmokeSensor;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.osgi.framework.ServiceRegistration;

public class MockedSmokeDetector
extends SmokeDetector
implements MockedDevice {
    private List<ServiceRegistration> serviceRegistrations;
    private boolean smokeAlarm = false;
    private boolean running = false;
    private SmokeSensor smokeSensor;
    private int detectedTime;

    public MockedSmokeDetector(String id, String serial, Domain domain) {
        super(id, serial, domain);
        this.smokeSensor = new SmokeSensor("smokeSensor_" + id, domain, new BooleanDataPoint((Identifiers)DatapointType.alarm){

            public Boolean doGetValue() throws DataPointException {
                return MockedSmokeDetector.this.smokeAlarm;
            }
        });
        this.smokeSensor.setDetectedTime(new IntegerDataPoint((Identifiers)DatapointType.detectedTime){

            protected Integer doGetValue() throws DataPointException {
                return MockedSmokeDetector.this.detectedTime;
            }

            protected void doSetValue(Integer v) throws DataPointException {
                MockedSmokeDetector.this.detectedTime = v;
            }
        });
        this.addModule((AbstractAlarmSensor)this.smokeSensor);
        this.addModule(new MockedFaultDetection("faultDetection_" + id, domain));
    }

    @Override
    public void registerDevice() {
        this.running = true;
        if (this.serviceRegistrations != null && !this.serviceRegistrations.isEmpty()) {
            return;
        }
        this.serviceRegistrations = Activator.register((GenericDevice)this);
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (MockedSmokeDetector.this.running) {
                    try {
                        Thread.sleep((int)(180000.0 + 5000.0 * Math.random()));
                        Activator.logger.info("Generating Smoke Alarm event");
                        Event evt = new Event("ALARM");
                        MockedSmokeDetector.this.smokeAlarm = !MockedSmokeDetector.this.smokeAlarm;
                        evt.addDataPoint(MockedSmokeDetector.this.smokeSensor.getDataPoint("alarm"));
                        evt.setValue((Object)MockedSmokeDetector.this.smokeAlarm);
                        MockedSmokeDetector.this.smokeSensor.addEvent(evt);
                        if (!MockedSmokeDetector.this.smokeAlarm) continue;
                        MockedSmokeDetector.this.detectedTime = (int)(System.currentTimeMillis() / 1000L);
                    }
                    catch (Throwable e) {
                        Activator.logger.warning("Error generating event", e);
                    }
                }
            }
        }).start();
    }

    @Override
    public void unregisterDevice() {
        this.running = false;
        if (this.serviceRegistrations == null) {
            return;
        }
        for (ServiceRegistration reg : this.serviceRegistrations) {
            reg.unregister();
        }
        this.serviceRegistrations.clear();
    }
}

