/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.mocked.devices;

import java.util.List;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Event;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.FloatDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.devices.WeatherStation;
import org.eclipse.om2m.sdt.home.mocked.devices.Activator;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedDevice;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedTemperature;
import org.eclipse.om2m.sdt.home.modules.Noise;
import org.eclipse.om2m.sdt.home.modules.RelativeHumidity;
import org.eclipse.om2m.sdt.home.modules.Temperature;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.osgi.framework.ServiceRegistration;

public class MockedWeatherStation
extends WeatherStation
implements MockedDevice {
    private static final int MIN = 15;
    private static final int MAX = 35;
    private List<ServiceRegistration> serviceRegistrations;
    private float temp;
    private float humidity;
    private Temperature temperature;
    private RelativeHumidity relativeHumidity;
    private boolean running = true;
    private int delta = 1;

    public MockedWeatherStation(String id, String serial, Domain domain) {
        super(id, serial, domain);
        this.temperature = new MockedTemperature("temperature_" + id, domain, new FloatDataPoint((Identifiers)DatapointType.currentTemperature){

            public Float doGetValue() throws DataPointException {
                return Float.valueOf(MockedWeatherStation.this.temp);
            }
        });
        this.addModule((Module)this.temperature);
        this.relativeHumidity = new RelativeHumidity("humidity_" + id, domain, new FloatDataPoint((Identifiers)DatapointType.relativeHumidity){

            public Float doGetValue() throws DataPointException {
                return Float.valueOf(MockedWeatherStation.this.humidity);
            }
        });
        this.addModule((Module)this.relativeHumidity);
        this.addModule((Module)new Noise("noise_" + id, domain, new IntegerDataPoint((Identifiers)DatapointType.noise){

            protected Integer doGetValue() throws DataPointException {
                return 37;
            }
        }));
        new MyThread().start();
    }

    @Override
    public void registerDevice() {
        this.running = true;
        if (this.serviceRegistrations != null && !this.serviceRegistrations.isEmpty()) {
            return;
        }
        this.serviceRegistrations = Activator.register((GenericDevice)this);
    }

    @Override
    public void unregisterDevice() {
        this.running = false;
        if (this.serviceRegistrations == null) {
            return;
        }
        for (ServiceRegistration reg : this.serviceRegistrations) {
            reg.unregister();
        }
        this.serviceRegistrations.clear();
    }

    private class MyThread
    extends Thread {
        private MyThread() {
        }

        @Override
        public void run() {
            while (MockedWeatherStation.this.running) {
                try {
                    MyThread.sleep(20000L);
                    MockedWeatherStation mockedWeatherStation = MockedWeatherStation.this;
                    mockedWeatherStation.temp = mockedWeatherStation.temp + (float)MockedWeatherStation.this.delta;
                    if (MockedWeatherStation.this.temp <= 15.0f || MockedWeatherStation.this.temp >= 35.0f) {
                        MockedWeatherStation.this.delta = -MockedWeatherStation.this.delta;
                    }
                    MockedWeatherStation.this.humidity = (float)(Math.random() * 100.0);
                    Event evt = new Event("ALARM");
                    evt.addDataPoint(MockedWeatherStation.this.temperature.getDataPointByShortName(DatapointType.currentTemperature.getShortName()));
                    evt.setValue((Object)Float.valueOf(MockedWeatherStation.this.temp));
                    MockedWeatherStation.this.temperature.addEvent(evt);
                }
                catch (InterruptedException interruptedException) {
                    MockedWeatherStation.this.running = false;
                }
            }
        }
    }
}

