/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt;

import java.util.Collection;
import org.eclipse.om2m.sdt.Doc;

public class Element {
    protected String name;
    private Doc doc;

    public Element(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Name cannot be null or empty: " + name);
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public void setDoc(Doc doc) {
        this.doc = doc;
    }

    public void setDoc(String text) {
        this.doc = new Doc(text);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj == null || this.getClass() != obj.getClass() ? false : this.name.equals(((Element)obj).name);
    }

    public String toString() {
        return "<" + this.getClass().getSimpleName() + " name=\"" + this.name + "\"/>";
    }

    public String prettyPrint() {
        return this.prettyPrint("");
    }

    protected String prettyPrint(String tab) {
        return String.valueOf(tab) + "<" + this.getClass().getSimpleName() + " name=\"" + this.name + "\"/>";
    }

    protected void prettyPrint(StringBuffer ret, Collection<? extends Element> items, String title, String t1) {
        if (!items.isEmpty()) {
            String t2 = String.valueOf(t1) + "\t";
            ret.append("\n").append(t1).append("<" + title + ">");
            for (Element element : items) {
                ret.append("\n");
                ret.append(element.prettyPrint(t2));
            }
            ret.append("\n").append(t1).append("</" + title + ">");
        }
    }
}

