/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite.crud;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.das.testsuite.Test;

public class UpdateDASTest
extends Test {
    public UpdateDASTest(CseService pCseService) {
        super("Update DAS", pCseService);
    }

    @Override
    public void performTest() {
        DynamicAuthorizationConsultation createdDas = this.createDAS();
        if (createdDas == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create a DAS");
            return;
        }
        if (!this.updateDas(createdDas.getResourceID(), createdDas)) {
            return;
        }
        createdDas = this.createDAS();
        if (createdDas == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create a DAS");
            return;
        }
        if (!this.updateDas("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME + "/" + createdDas.getName(), createdDas)) {
            return;
        }
        this.setState(Test.State.OK);
    }

    private boolean updateDas(String dasUrl, DynamicAuthorizationConsultation createdDas) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
        Boolean enabled = Boolean.FALSE;
        ArrayList<String> poa = new ArrayList<String>();
        poa.add("poa3");
        poa.add("poa4");
        poa.add("poa5");
        String lifetime = new Date().toString();
        DynamicAuthorizationConsultation toBeUpdateDas = new DynamicAuthorizationConsultation();
        toBeUpdateDas.setDynamicAuthorisationPoA(poa);
        toBeUpdateDas.setDynamicAuthorizationEnabled(enabled);
        toBeUpdateDas.setDynamicAuthorizationLifetime(lifetime);
        RequestPrimitive request = new RequestPrimitive();
        request.setContent((Object)toBeUpdateDas);
        request.setOperation(Operation.UPDATE);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(dasUrl);
        ResponsePrimitive response = this.getCseService().doRequest(request);
        if (response != null) {
            if (!ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
                this.setState(Test.State.KO);
                this.setMessage("expecting " + ResponseStatusCode.UPDATED + " status code, found " + response.getResponseStatusCode());
                return false;
            }
            DynamicAuthorizationConsultation updatedDac = null;
            try {
                updatedDac = (DynamicAuthorizationConsultation)response.getContent();
            }
            catch (ClassCastException classCastException) {
                this.setState(Test.State.KO);
                this.setMessage("unable to cast content as a DynamicAuthorizationConsultation");
                return false;
            }
            if (!this.checkNull(updatedDac.getName(), "name")) {
                return false;
            }
            if (!this.checkNull(updatedDac.getResourceType(), "type")) {
                return false;
            }
            if (!this.checkNull(updatedDac.getResourceID(), "resourceID")) {
                return false;
            }
            if (!this.checkNull(updatedDac.getParentID(), "parentID")) {
                return false;
            }
            if (!this.checkNull(updatedDac.getExpirationTime(), "expirationTime")) {
                return false;
            }
            if (!this.checkEmpty(updatedDac.getAccessControlPolicyIDs(), "accessControlPolicyIDs")) {
                return false;
            }
            if (!this.checkNull(updatedDac.getCreationTime(), "creationTime")) {
                return false;
            }
            if (!this.checkNotEmpty(updatedDac.getLastModifiedTime(), "lastModifiedTime")) {
                return false;
            }
            if (updatedDac.getLastModifiedTime().equals(createdDas.getLastModifiedTime())) {
                this.setState(Test.State.KO);
                this.setMessage("lastModifiedTime must be different");
                return false;
            }
            if (!this.checkEmpty(updatedDac.getLabels(), "labels")) {
                return false;
            }
            if (!this.checkEquals(updatedDac.getDynamicAuthorizationEnabled(), enabled, "dynamicAuthorizationEnabled")) {
                return false;
            }
            if (!this.checkEquals(updatedDac.getDynamicAuthorisationPoA(), poa, "dynamicAuthorizationPoA")) {
                return false;
            }
            return this.checkEquals(updatedDac.getDynamicAuthorizationLifetime(), lifetime, "dynamicAuthorizationLifetime");
        }
        this.setState(Test.State.KO);
        this.setMessage("response is null");
        return false;
    }
}

