/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite.dacis;

import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.RemoteCSE;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.das.testsuite.Test;

public class RemoteCseDacisTest
extends Test {
    public RemoteCseDacisTest(CseService pCseService) {
        super("Remote Cse Dacis", pCseService);
    }

    @Override
    public void performTest() {
        DynamicAuthorizationConsultation dac = this.createDAS();
        if (dac == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create DAC");
            return;
        }
        RemoteCSE toBeCreatedRemoteCse = new RemoteCSE();
        toBeCreatedRemoteCse.getDynamicAuthorizationConsultationIDs().add(dac.getResourceID());
        toBeCreatedRemoteCse.setRequestReachability(Boolean.FALSE);
        toBeCreatedRemoteCse.setCSEBase("/cseBase" + UUID.randomUUID());
        toBeCreatedRemoteCse.setCSEID("cseId" + UUID.randomUUID());
        toBeCreatedRemoteCse.setName("RemoteCSE_" + UUID.randomUUID());
        RequestPrimitive createRequest = new RequestPrimitive();
        createRequest.setOperation(Operation.CREATE);
        createRequest.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        createRequest.setTo("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME);
        createRequest.setRequestContentType("application/obj");
        createRequest.setReturnContentType("application/obj");
        createRequest.setResourceType(16);
        createRequest.setContent((Object)toBeCreatedRemoteCse);
        ResponsePrimitive createResponse = this.getCseService().doRequest(createRequest);
        if (createResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("response is null");
            return;
        }
        if (!ResponseStatusCode.CREATED.equals(createResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create RemoteCse: expecting " + ResponseStatusCode.CREATED + ", found " + createResponse.getResponseStatusCode());
            return;
        }
        RemoteCSE createdRemoteCse = null;
        try {
            createdRemoteCse = (RemoteCSE)createResponse.getContent();
        }
        catch (ClassCastException classCastException) {
            this.setState(Test.State.KO);
            this.setMessage("expected response content is not a RemoteCse");
            return;
        }
        if (!this.checkEquals(createdRemoteCse.getDynamicAuthorizationConsultationIDs(), toBeCreatedRemoteCse.getDynamicAuthorizationConsultationIDs(), "dynamicAuthorizationConsultationIDs")) {
            return;
        }
        ResponsePrimitive retrieveResponse = this.retrieveEntity(createdRemoteCse.getResourceID());
        if (retrieveResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("retrieveResponse is null");
            return;
        }
        if (!ResponseStatusCode.OK.equals(retrieveResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to retrieve RemoteCse: expecting " + ResponseStatusCode.OK + ", found " + createResponse.getResponseStatusCode());
            return;
        }
        RemoteCSE retrievedRemoteCse = null;
        try {
            retrievedRemoteCse = (RemoteCSE)retrieveResponse.getContent();
        }
        catch (ClassCastException classCastException) {
            this.setState(Test.State.KO);
            this.setMessage("expected response content is not a RemoteCse");
            return;
        }
        if (!this.checkEquals(retrievedRemoteCse.getDynamicAuthorizationConsultationIDs(), toBeCreatedRemoteCse.getDynamicAuthorizationConsultationIDs(), "dynamicAuthorizationConsultationIDs")) {
            return;
        }
        RequestPrimitive deleteRequest = new RequestPrimitive();
        deleteRequest.setOperation(Operation.DELETE);
        deleteRequest.setTo(dac.getResourceID());
        deleteRequest.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        ResponsePrimitive deleteResponse = this.getCseService().doRequest(deleteRequest);
        if (!ResponseStatusCode.DELETED.equals(deleteResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to delete DAC");
            return;
        }
        retrieveResponse = this.retrieveEntity(createdRemoteCse.getResourceID());
        if (retrieveResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("retrieveResponse is null");
            return;
        }
        if (!ResponseStatusCode.OK.equals(retrieveResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to retrieve RemoteCse: expecting " + ResponseStatusCode.OK + ", found " + createResponse.getResponseStatusCode());
            return;
        }
        retrievedRemoteCse = null;
        try {
            retrievedRemoteCse = (RemoteCSE)retrieveResponse.getContent();
        }
        catch (ClassCastException classCastException) {
            this.setState(Test.State.KO);
            this.setMessage("expected response content is not a RemoteCse");
            return;
        }
        if (!this.checkEquals(retrievedRemoteCse.getDynamicAuthorizationConsultationIDs(), new ArrayList(), "dynamicAuthorizationConsultationIDs")) {
            return;
        }
        this.setState(Test.State.OK);
    }
}

