/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.announcer;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.CreatedAnnouncedResourceEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.NotImplementedException;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.AEAnnc;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.AbstractFlexContainerAnnc;
import org.eclipse.om2m.commons.resource.AnnounceableResource;
import org.eclipse.om2m.commons.resource.AnnouncedResource;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.FlexContainerFactory;
import org.eclipse.om2m.core.persistence.PersistenceService;
import org.eclipse.om2m.core.redirector.Redirector;
import org.eclipse.om2m.persistence.service.DBService;
import org.eclipse.om2m.persistence.service.DBTransaction;
import org.eclipse.om2m.persistence.service.util.AnnouncedResourceUtil;

public class Announcer
implements Constants {
    private static Log LOGGER = LogFactory.getLog(Announcer.class);

    public static List<String> announce(List<String> announceTo, List<String> announceToAttribute, AnnounceableResource toBeAnnounced, String requestingEntity, String remoteDestination) {
        AEAnnc announcedResource = null;
        switch (toBeAnnounced.getResourceType().intValue()) {
            case 2: {
                AEAnnc aeAnnc = new AEAnnc();
                aeAnnc.setAppID(((AE)toBeAnnounced).getAppID());
                announcedResource = aeAnnc;
                break;
            }
            case 28: {
                AbstractFlexContainer afc = (AbstractFlexContainer)toBeAnnounced;
                AbstractFlexContainerAnnc flexContainerAnnc = FlexContainerFactory.getSpecializationFlexContainerAnnc((String)(String.valueOf(afc.getShortName()) + "Annc"));
                announcedResource = flexContainerAnnc;
            }
        }
        announcedResource.setName(String.valueOf(toBeAnnounced.getName()) + "_Annc");
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        AnnouncedResourceUtil dao = dbs.getDBUtilManager().getAnnouncedResourceUtil();
        announcedResource.getLabels().addAll(toBeAnnounced.getLabels());
        announcedResource.setLink(toBeAnnounced.getResourceID());
        for (String cseId : announceTo) {
            RemoteCSEEntity remoteCSE = (RemoteCSEEntity)dbs.getDAOFactory().getRemoteCSEbyCseIdDAO().find(transaction, (Object)cseId);
            RequestPrimitive request = new RequestPrimitive();
            CreatedAnnouncedResourceEntity parentResource = dao.find(transaction, toBeAnnounced.getParentID(), cseId);
            if (parentResource != null) {
                request.setTo(parentResource.getRemoteAnnouncedId());
            } else {
                if (!remoteDestination.startsWith("/")) {
                    remoteDestination = "/" + remoteDestination;
                }
                request.setTo(String.valueOf(remoteCSE.getRemoteCseId()) + "/" + remoteCSE.getName() + "/" + Constants.CSE_NAME + remoteDestination);
            }
            request.setOperation(Operation.CREATE);
            switch (toBeAnnounced.getResourceType().intValue()) {
                case 2: {
                    request.setResourceType(10002);
                    break;
                }
                case 28: {
                    request.setResourceType(10028);
                    break;
                }
                default: {
                    throw new NotImplementedException("");
                }
            }
            request.setContent((Object)announcedResource);
            request.setRequestContentType("application/obj");
            request.setReturnContentType("application/obj");
            request.setFrom(requestingEntity);
            ResponsePrimitive response = Redirector.retarget(request);
            if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) continue;
            AnnouncedResource ar = (AnnouncedResource)response.getContent();
            CreatedAnnouncedResourceEntity announcedResourceEntity = new CreatedAnnouncedResourceEntity();
            announcedResourceEntity.setAnnounceCseId(cseId);
            announcedResourceEntity.setLocalAnnounceableId(toBeAnnounced.getResourceID());
            announcedResourceEntity.setRemoteAnnouncedId(ar.getResourceID());
            dao.create(transaction, (Object)announcedResourceEntity);
        }
        transaction.commit();
        transaction.close();
        return null;
    }

    public static void deAnnounce(List<String> announceTo, ResourceEntity toBeDeAnnounced, String requestingEntity) {
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        AnnouncedResourceUtil announceResourceUtil = dbs.getDBUtilManager().getAnnouncedResourceUtil();
        for (String cseId : announceTo) {
            CreatedAnnouncedResourceEntity are = announceResourceUtil.find(transaction, toBeDeAnnounced.getResourceID(), cseId);
            if (are == null) continue;
            RequestPrimitive request = new RequestPrimitive();
            request.setTo(are.getRemoteAnnouncedId());
            request.setOperation(Operation.DELETE);
            request.setFrom(requestingEntity);
            Redirector.retarget(request);
            announceResourceUtil.delete(transaction, (Object)are);
        }
        transaction.commit();
        transaction.close();
    }
}

