/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.mocked.modules;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.mocked.devices.Activator;
import org.eclipse.om2m.sdt.home.modules.Colour;
import org.eclipse.om2m.sdt.home.types.DatapointType;

public class MockedColour
extends Colour {
    private static int red;
    private static int green;
    private static int blue;

    public MockedColour(String name, Domain domain) {
        super(name, domain, new IntegerDataPoint((Identifiers)DatapointType.red){

            public void doSetValue(Integer value) throws DataPointException {
                Activator.logger.info("set single red " + value);
                red = value;
            }

            public Integer doGetValue() throws DataPointException {
                int v = red == 0 ? (int)(Math.random() * 255.0) : red;
                Activator.logger.info("get single red " + v);
                return v;
            }
        }, new IntegerDataPoint((Identifiers)DatapointType.green){

            public void doSetValue(Integer value) throws DataPointException {
                green = value;
            }

            public Integer doGetValue() throws DataPointException {
                return green == 0 ? (int)(Math.random() * 255.0) : green;
            }
        }, new IntegerDataPoint((Identifiers)DatapointType.blue){

            public void doSetValue(Integer value) throws DataPointException {
                blue = value;
            }

            public Integer doGetValue() throws DataPointException {
                return blue == 0 ? (int)(Math.random() * 255.0) : blue;
            }
        });
        this.setDatapointHandler(new Module.DatapointHandler(){

            public void setValues(Map<String, Object> values) throws DataPointException, AccessException {
                Activator.logger.info("set values " + values);
                for (Map.Entry<String, Object> entry : values.entrySet()) {
                    switch (entry.getKey()) {
                        case "red": {
                            red = (Integer)entry.getValue();
                            break;
                        }
                        case "green": {
                            green = (Integer)entry.getValue();
                            break;
                        }
                        case "blue": {
                            blue = (Integer)entry.getValue();
                            break;
                        }
                    }
                }
            }

            public Map<String, Object> getValues(List<String> names) throws DataPointException, AccessException {
                HashMap<String, Object> ret = new HashMap<String, Object>();
                Iterator<String> iterator = names.iterator();
                while (iterator.hasNext()) {
                    String name;
                    switch (name = iterator.next()) {
                        case "red": {
                            ret.put(name, red);
                            break;
                        }
                        case "green": {
                            ret.put(name, green);
                            break;
                        }
                        case "blue": {
                            ret.put(name, blue);
                            break;
                        }
                    }
                }
                Activator.logger.info("get values " + names + " -> " + ret);
                return ret;
            }
        });
    }
}

