/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.types;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.om2m.sdt.types.BasicType;
import org.eclipse.om2m.sdt.types.DataType;

public class SimpleType
implements DataType.TypeChoice {
    private static Map<String, SimpleType> values = new HashMap<String, SimpleType>();
    public static final SimpleType Boolean = new SimpleType(BasicType.BOOLEAN);
    public static final SimpleType Byte = new SimpleType(BasicType.BYTE);
    public static final SimpleType Integer = new SimpleType(BasicType.INTEGER);
    public static final SimpleType Float = new SimpleType(BasicType.FLOAT);
    public static final SimpleType String = new SimpleType(BasicType.STRING);
    public static final SimpleType Enum = new SimpleType(BasicType.ENUM);
    public static final SimpleType Date = new SimpleType(BasicType.DATE);
    public static final SimpleType Time = new SimpleType(BasicType.TIME);
    public static final SimpleType Datetime = new SimpleType(BasicType.DATETIME);
    public static final SimpleType Blob = new SimpleType(BasicType.BLOB);
    public static final SimpleType Uri = new SimpleType(BasicType.URI);
    private BasicType type;

    protected SimpleType(BasicType type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        values.put(type.getValue(), this);
    }

    public BasicType getType() {
        return this.type;
    }

    @Override
    public String getOneM2MType() {
        return "xs:" + this.getType().getValue();
    }

    public static SimpleType getSimpleType(String s) {
        return values.get(s);
    }

    public String toString() {
        return "<SimpleType type=\"" + this.type + "\"/>";
    }
}

