/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.testsuite.flexcontainer;

import org.eclipse.om2m.commons.constants.AccessControl;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.AccessControlPolicy;
import org.eclipse.om2m.commons.resource.AccessControlRule;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.SetOfAcrs;
import org.eclipse.om2m.commons.resource.flexcontainerspec.BinarySwitchFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.testsuite.flexcontainer.FlexContainerTestSuite;
import org.eclipse.om2m.testsuite.flexcontainer.TestReport;

public class AccessControlPolicyTest
extends FlexContainerTestSuite {
    public AccessControlPolicyTest(CseService pCseService) {
        super(pCseService);
    }

    @Override
    protected String getTestSuiteName() {
        return "AccessControlPolicyTest";
    }

    public void testCreateAccessControlPolicy() {
        String acpName = "acp_" + System.currentTimeMillis();
        AccessControlPolicy acp = new AccessControlPolicy();
        acp.setName(acpName);
        SetOfAcrs privileges = new SetOfAcrs();
        AccessControlRule accessControlRule = new AccessControlRule();
        accessControlRule.getAccessControlOriginators().add("greg:greg");
        accessControlRule.setAccessControlOperations(AccessControl.ALL);
        privileges.getAccessControlRule().add(accessControlRule);
        acp.setPrivileges(privileges);
        SetOfAcrs selfPrivileges = new SetOfAcrs();
        AccessControlRule selfAccessControlRule = new AccessControlRule();
        selfAccessControlRule.getAccessControlOriginators().add("admin:admin");
        selfAccessControlRule.setAccessControlOperations(AccessControl.ALL);
        selfPrivileges.getAccessControlRule().add(selfAccessControlRule);
        acp.setSelfPrivileges(selfPrivileges);
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String cfr_ignored_0 = String.valueOf(baseLocation) + "/" + acpName;
        ResponsePrimitive response = this.sendCreateAccessControlPolicyRequest(acp, baseLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testAccessControlPolicy", TestReport.Status.KO, "unable to create a new acp", null);
            return;
        }
        AccessControlPolicy returnedAcp = (AccessControlPolicy)response.getContent();
        BinarySwitchFlexContainer flexContainer = new BinarySwitchFlexContainer();
        CustomAttribute ca = new CustomAttribute();
        ca.setCustomAttributeName("powSe");
        ca.setCustomAttributeValue("false");
        flexContainer.getCustomAttributes().add(ca);
        String flexContainerName = "flexContainerACPTest_" + System.currentTimeMillis();
        flexContainer.setName(flexContainerName);
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        flexContainer.getAccessControlPolicyIDs().add(returnedAcp.getResourceID());
        response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        BinarySwitchFlexContainer createdFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testAccessControlPolicy", TestReport.Status.KO, "unable to create a FlexContainer", null);
            return;
        }
        createdFlexContainer = (BinarySwitchFlexContainer)response.getContent();
        response = this.sendRetrieveRequest(flexContainerLocation, "greg:greg");
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            this.createTestReport("testAccessControlPolicy", TestReport.Status.KO, "unable to retrieve the FlexContainer", null);
            return;
        }
        BinarySwitchFlexContainer toBeRetrieved = (BinarySwitchFlexContainer)response.getContent();
        try {
            this.checkFlexContainer((AbstractFlexContainer)createdFlexContainer, (AbstractFlexContainer)toBeRetrieved);
        }
        catch (Exception exception) {
            this.createTestReport("testAccessControlPolicy", TestReport.Status.KO, "flexContainer are differents", null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation, Constants.ADMIN_REQUESTING_ENTITY);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.ACCESS_DENIED)) {
            this.createTestReport("testAccessControlPolicy", TestReport.Status.KO, "expected " + ResponseStatusCode.ACCESS_DENIED + ", received:" + response.getResponseStatusCode(), null);
            return;
        }
        this.createTestReport("testAccessControlPolicy", TestReport.Status.OK, null, null);
    }

    public void testCreateFlexContainerWithNoRight() {
        String acpName = "acp_" + System.currentTimeMillis();
        AccessControlPolicy acp = new AccessControlPolicy();
        acp.setName(acpName);
        SetOfAcrs privileges = new SetOfAcrs();
        AccessControlRule accessControlRule = new AccessControlRule();
        accessControlRule.getAccessControlOriginators().add("greg:greg");
        accessControlRule.setAccessControlOperations(AccessControl.RETRIEVE);
        privileges.getAccessControlRule().add(accessControlRule);
        acp.setPrivileges(privileges);
        SetOfAcrs selfPrivileges = new SetOfAcrs();
        AccessControlRule selfAccessControlRule = new AccessControlRule();
        selfAccessControlRule.getAccessControlOriginators().add("admin:admin");
        selfAccessControlRule.setAccessControlOperations(AccessControl.ALL);
        selfPrivileges.getAccessControlRule().add(selfAccessControlRule);
        acp.setSelfPrivileges(selfPrivileges);
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String cfr_ignored_0 = String.valueOf(baseLocation) + "/" + acpName;
        ResponsePrimitive response = this.sendCreateAccessControlPolicyRequest(acp, baseLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testCreateFlexContainerWithNoRight", TestReport.Status.KO, "unable to create a new acp", null);
            return;
        }
        AccessControlPolicy cfr_ignored_1 = (AccessControlPolicy)response.getContent();
        String flexContainerName = "flexContainerACPTest_" + System.currentTimeMillis();
        BinarySwitchFlexContainer flexContainer = new BinarySwitchFlexContainer();
        flexContainer.setName(flexContainerName);
        CustomAttribute ca = new CustomAttribute();
        ca.setCustomAttributeName("powSe");
        ca.setCustomAttributeValue("false");
        flexContainer.getCustomAttributes().add(ca);
        String cfr_ignored_2 = String.valueOf(baseLocation) + "/" + flexContainerName;
        response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, "greg:greg");
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.ACCESS_DENIED)) {
            this.createTestReport("testCreateFlexContainerWithNoRight", TestReport.Status.KO, "error : expected " + ResponseStatusCode.ACCESS_DENIED + ", received:" + response.getResponseStatusCode(), null);
            return;
        }
        this.createTestReport("testCreateFlexContainerWithNoRight", TestReport.Status.OK, null, null);
    }

    public void testDeleteFlexContainerWithNoRight() {
        String acpName = "acp_" + System.currentTimeMillis();
        AccessControlPolicy acp = new AccessControlPolicy();
        acp.setName(acpName);
        SetOfAcrs privileges = new SetOfAcrs();
        AccessControlRule accessControlRule = new AccessControlRule();
        accessControlRule.getAccessControlOriginators().add("greg:greg");
        accessControlRule.setAccessControlOperations(AccessControl.RETRIEVE);
        privileges.getAccessControlRule().add(accessControlRule);
        acp.setPrivileges(privileges);
        SetOfAcrs selfPrivileges = new SetOfAcrs();
        AccessControlRule selfAccessControlRule = new AccessControlRule();
        selfAccessControlRule.getAccessControlOriginators().add("admin:admin");
        selfAccessControlRule.setAccessControlOperations(AccessControl.ALL);
        selfPrivileges.getAccessControlRule().add(selfAccessControlRule);
        acp.setSelfPrivileges(selfPrivileges);
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String cfr_ignored_0 = String.valueOf(baseLocation) + "/" + acpName;
        ResponsePrimitive response = this.sendCreateAccessControlPolicyRequest(acp, baseLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testDeleteFlexContainerWithNoRight", TestReport.Status.KO, "unable to create a new acp", null);
            return;
        }
        AccessControlPolicy cfr_ignored_1 = (AccessControlPolicy)response.getContent();
        String flexContainerName = "flexContainerACPTest_" + System.currentTimeMillis();
        BinarySwitchFlexContainer flexContainer = new BinarySwitchFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setContainerDefinition("org.onem2m.home.moduleclass.binaryswitch");
        CustomAttribute ca = new CustomAttribute();
        ca.setCustomAttributeName("powSe");
        ca.setCustomAttributeValue("false");
        flexContainer.getCustomAttributes().add(ca);
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        BinarySwitchFlexContainer createdFlexContainer = null;
        response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testDeleteFlexContainerWithNoRight", TestReport.Status.KO, "error : expected " + ResponseStatusCode.CREATED + ", received:" + response.getResponseStatusCode(), null);
            return;
        }
        createdFlexContainer = (BinarySwitchFlexContainer)response.getContent();
        response = this.sendDeleteRequest(flexContainerLocation, "greg:greg");
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.ACCESS_DENIED)) {
            this.createTestReport("testDeleteFlexContainerWithNoRight", TestReport.Status.KO, "error : expected " + ResponseStatusCode.ACCESS_DENIED + ", received:" + response.getResponseStatusCode(), null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation, "greg:greg");
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            this.createTestReport("testDeleteFlexContainerWithNoRight", TestReport.Status.KO, "error : expected " + ResponseStatusCode.OK + ", received:" + response.getResponseStatusCode(), null);
            return;
        }
        try {
            this.checkFlexContainer((AbstractFlexContainer)createdFlexContainer, (AbstractFlexContainer)((BinarySwitchFlexContainer)response.getContent()));
        }
        catch (Exception e) {
            this.createTestReport("testDeleteFlexContainerWithNoRight", TestReport.Status.KO, "flexContainers are differents:" + e.getMessage(), e);
        }
        this.createTestReport("testDeleteFlexContainerWithNoRight", TestReport.Status.OK, null, null);
    }
}

