/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class Colour
extends Module {
    private IntegerDataPoint red;
    private IntegerDataPoint green;
    private IntegerDataPoint blue;

    public Colour(String name, Domain domain, IntegerDataPoint red, IntegerDataPoint green, IntegerDataPoint blue) {
        super(name, domain, (Identifiers)ModuleType.colour);
        this.setExtends(domain.getName(), "Colour");
        if (red == null || !red.getShortName().equals(DatapointType.red.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong red datapoint: " + red);
        }
        this.red = red;
        this.red.setDoc("The R value of RGB; the range is [0,255]");
        this.addDataPoint((DataPoint)this.red);
        if (green == null || !green.getShortName().equals(DatapointType.green.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong green datapoint: " + green);
        }
        this.green = green;
        this.green.setDoc("The G value of RGB; the range is [0,255]");
        this.addDataPoint((DataPoint)this.green);
        if (blue == null || !blue.getShortName().equals(DatapointType.blue.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong blue datapoint: " + blue);
        }
        this.blue = blue;
        this.blue.setDoc("The B value of RGB; the range is [0,255]");
        this.addDataPoint((DataPoint)this.blue);
    }

    public Colour(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (IntegerDataPoint)dps.get(DatapointType.red.getShortName()), (IntegerDataPoint)dps.get(DatapointType.green.getShortName()), (IntegerDataPoint)dps.get(DatapointType.blue.getShortName()));
    }

    public int getRed() throws DataPointException, AccessException {
        return (Integer)this.red.getValue();
    }

    public void setRed(int value) throws DataPointException, AccessException {
        this.red.setValue((Object)value);
    }

    public int getGreen() throws DataPointException, AccessException {
        return (Integer)this.green.getValue();
    }

    public void setGreen(int value) throws DataPointException, AccessException {
        this.green.setValue((Object)value);
    }

    public int getBlue() throws DataPointException, AccessException {
        return (Integer)this.blue.getValue();
    }

    public void setBlue(int value) throws DataPointException, AccessException {
        this.blue.setValue((Object)value);
    }
}

