/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.math.BigInteger;
import java.util.List;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.ConflictException;
import org.eclipse.om2m.commons.exceptions.NotImplementedException;
import org.eclipse.om2m.commons.exceptions.NotPermittedAttrException;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.AnnounceableResource;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.utils.Util;
import org.eclipse.om2m.core.announcer.Announcer;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.notifier.Notifier;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.core.util.ControllerUtil;
import org.eclipse.om2m.persistence.service.DAO;

public class AEController
extends Controller {
    @Override
    public ResponsePrimitive doCreate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        Patterns patterns = new Patterns();
        DAO<?> dao = patterns.getDAO(request.getTo(), this.dbs);
        if (dao == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        ResourceEntity parentEntity = (ResourceEntity)dao.find(this.transaction, (Object)request.getTo());
        if (parentEntity == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        this.transaction.lock((Object)parentEntity);
        List acpsToCheck = null;
        List childAes = null;
        List subs = null;
        if (parentEntity.getResourceType().intValue() == 5) {
            CSEBaseEntity cseBase = (CSEBaseEntity)parentEntity;
            acpsToCheck = cseBase.getAccessControlPolicies();
            childAes = cseBase.getAes();
            subs = cseBase.getSubscriptions();
        }
        if (parentEntity.getResourceType().intValue() == 16) {
            RemoteCSEEntity csr = (RemoteCSEEntity)parentEntity;
            acpsToCheck = csr.getAccessControlPolicies();
            childAes = csr.getChildAes();
            subs = csr.getSubscriptions();
        }
        if (parentEntity.getResourceType().intValue() == 10016) {
            throw new NotImplementedException("remote cse announcer not implemented");
        }
        boolean assignAeiC = true;
        if (request.getFrom() != null) {
            if (request.getFrom().startsWith("S")) {
                throw new NotImplementedException("originator starting with S not implemented yet");
            }
            if (request.getFrom().startsWith("C")) {
                assignAeiC = false;
            } else if (!request.getFrom().equals("")) {
                this.checkPermissions(request, parentEntity, acpsToCheck);
            }
        }
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for AE creation");
        }
        AE ae = null;
        try {
            ae = request.getRequestContentType().equals("application/obj") ? (AE)request.getContent() : (AE)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (ae == null) {
            throw new BadRequestException("Error in provided content");
        }
        AeEntity aeEntity = new AeEntity();
        ControllerUtil.CreateUtil.fillEntityFromAnnounceableResource((AnnounceableResource)ae, (AnnounceableSubordinateEntity)aeEntity);
        if (ae.getAEID() != null) {
            throw new NotPermittedAttrException("ae-id is Not Permitted");
        }
        if (ae.getNodeLink() != null) {
            aeEntity.setNodeLink(ae.getNodeLink());
        }
        if (ae.getAppID() == null) {
            throw new BadRequestException("App ID is Mandatory");
        }
        aeEntity.setAppID(ae.getAppID());
        if (ae.getRequestReachability() == null) {
            throw new BadRequestException("Request Reachability is Mandatory");
        }
        aeEntity.setRequestReachability(ae.getRequestReachability().booleanValue());
        String generatedId = AEController.generateId();
        if (assignAeiC) {
            aeEntity.setAeid("C" + "ae".toUpperCase() + generatedId);
        } else {
            aeEntity.setAeid(request.getFrom());
        }
        aeEntity.setResourceID("/" + Constants.CSE_ID + "/" + aeEntity.getAeid());
        if (this.dbs.getDAOFactory().getAeDAO().find(this.transaction, (Object)aeEntity.getResourceID()) != null) {
            throw new ConflictException("Already registered");
        }
        if (!ae.getAccessControlPolicyIDs().isEmpty()) {
            aeEntity.setAccessControlPolicies(ControllerUtil.buildAcpEntityList(ae.getAccessControlPolicyIDs(), this.transaction));
        } else {
            aeEntity.getAccessControlPolicies().addAll(acpsToCheck);
        }
        if (!ae.getDynamicAuthorizationConsultationIDs().isEmpty()) {
            aeEntity.setDynamicAuthorizationConsultations(ControllerUtil.buildDacEntityList(ae.getDynamicAuthorizationConsultationIDs(), this.transaction));
        }
        if (ae.getAppName() != null) {
            aeEntity.setAppName(ae.getAppName());
        }
        if (!ae.getPointOfAccess().isEmpty()) {
            aeEntity.getPointOfAccess().addAll(ae.getPointOfAccess());
        }
        if (ae.getOntologyRef() != null) {
            aeEntity.setOntologyRef(ae.getOntologyRef());
        }
        aeEntity.setParentID(parentEntity.getResourceID());
        switch (parentEntity.getResourceType().intValue()) {
            case 16: {
                aeEntity.setParentCsr((RemoteCSEEntity)parentEntity);
                break;
            }
            case 5: {
                aeEntity.setParentCse((CSEBaseEntity)parentEntity);
            }
        }
        aeEntity.setResourceType(BigInteger.valueOf(2L));
        if (ae.getName() != null) {
            if (!patterns.checkResourceName(ae.getName())) {
                throw new BadRequestException("Name provided is incorrect. Must be:" + patterns.ID_STRING);
            }
            aeEntity.setName(ae.getName());
        } else {
            aeEntity.setName("ae_" + generatedId);
        }
        aeEntity.setHierarchicalURI(String.valueOf(parentEntity.getHierarchicalURI()) + "/" + aeEntity.getName());
        if (!UriMapper.addNewUri(aeEntity.getHierarchicalURI(), aeEntity.getResourceID(), 2)) {
            throw new ConflictException("Name already present in the parent collection.");
        }
        this.dbs.getDAOFactory().getAeDAO().create(this.transaction, (Object)aeEntity);
        AeEntity aeDB = (AeEntity)this.dbs.getDAOFactory().getAeDAO().find(this.transaction, (Object)aeEntity.getResourceID());
        childAes.add(aeDB);
        dao.update(this.transaction, (Object)parentEntity);
        for (DynamicAuthorizationConsultationEntity dace : aeDB.getDynamicAuthorizationConsultations()) {
            DynamicAuthorizationConsultationEntity daceFromDB = (DynamicAuthorizationConsultationEntity)this.dbs.getDAOFactory().getDynamicAuthorizationDAO().find(this.transaction, (Object)dace.getResourceID());
            daceFromDB.getLinkedAeEntities().add(aeDB);
            this.dbs.getDAOFactory().getDynamicAuthorizationDAO().update(this.transaction, (Object)daceFromDB);
        }
        this.transaction.commit();
        if (!ae.getAnnounceTo().isEmpty()) {
            ae.setName(aeDB.getName());
            ae.setResourceID(aeDB.getResourceID());
            ae.setResourceType(2);
            Announcer.announce((AnnounceableResource)ae, request.getFrom(), "");
        }
        response.setResponseStatusCode(ResponseStatusCode.CREATED);
        this.setLocationAndCreationContent(request, response, (ResourceEntity)aeDB);
        Notifier.notify(subs, (ResourceEntity)aeDB, 1);
        return response;
    }

    @Override
    public ResponsePrimitive doRetrieve(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        AeEntity aeEntity = (AeEntity)this.dbs.getDAOFactory().getAeDAO().find(this.transaction, (Object)request.getTo());
        if (aeEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        this.checkPermissions(request, (ResourceEntity)aeEntity, aeEntity.getAccessControlPolicies());
        AE ae = EntityMapperFactory.getAEMapper().mapEntityToResource(aeEntity, request);
        response.setContent((Object)ae);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    @Override
    public ResponsePrimitive doUpdate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        AeEntity aeEntity = (AeEntity)this.dbs.getDAOFactory().getAeDAO().find(this.transaction, (Object)request.getTo());
        if (aeEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        this.transaction.lock((Object)aeEntity);
        this.checkPermissions(request, (ResourceEntity)aeEntity, aeEntity.getAccessControlPolicies());
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for AE update");
        }
        AE ae = null;
        try {
            ae = request.getRequestContentType().equals("application/obj") ? (AE)request.getContent() : (AE)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (ae == null) {
            throw new BadRequestException("Error in provided content");
        }
        ControllerUtil.UpdateUtil.checkNotPermittedParameters((Resource)ae);
        if (ae.getAppID() != null) {
            throw new BadRequestException("AppID is NP");
        }
        if (ae.getAEID() != null) {
            throw new BadRequestException("AE ID is NP");
        }
        if (ae.getNodeLink() != null) {
            aeEntity.setNodeLink(ae.getNodeLink());
        }
        AE modifiedAttributes = new AE();
        if (!ae.getLabels().isEmpty()) {
            aeEntity.setLabelsEntitiesFromSring(ae.getLabels());
            modifiedAttributes.getLabels().addAll(ae.getLabels());
        }
        if (!ae.getAccessControlPolicyIDs().isEmpty()) {
            for (AccessControlPolicyEntity acpe : aeEntity.getAccessControlPolicies()) {
                this.checkSelfACP(acpe, request.getFrom(), Operation.UPDATE);
            }
            aeEntity.getAccessControlPolicies().clear();
            aeEntity.setAccessControlPolicies(ControllerUtil.buildAcpEntityList(ae.getAccessControlPolicyIDs(), this.transaction));
            modifiedAttributes.getAccessControlPolicyIDs().addAll(ae.getAccessControlPolicyIDs());
        }
        List previousDynamicAuthorizationConsultations = null;
        if (ae.getRawDynamicAuthorizationConsultationIDs() != null) {
            previousDynamicAuthorizationConsultations = aeEntity.getDynamicAuthorizationConsultations();
            aeEntity.setDynamicAuthorizationConsultations(ControllerUtil.buildDacEntityList(ae.getDynamicAuthorizationConsultationIDs(), this.transaction));
        }
        if (ae.getExpirationTime() != null) {
            aeEntity.setExpirationTime(ae.getExpirationTime());
            modifiedAttributes.setExpirationTime(ae.getExpirationTime());
        }
        if (!ae.getAnnounceTo().isEmpty()) {
            aeEntity.getAnnounceTo().clear();
            aeEntity.getAnnounceTo().addAll(ae.getAnnounceTo());
            modifiedAttributes.getAnnounceTo().addAll(ae.getAnnounceTo());
        }
        if (!ae.getAnnouncedAttribute().isEmpty()) {
            aeEntity.getAnnouncedAttribute().clear();
            aeEntity.getAnnouncedAttribute().addAll(ae.getAnnouncedAttribute());
            modifiedAttributes.getAnnouncedAttribute().addAll(ae.getAnnouncedAttribute());
        }
        if (ae.getAppName() != null) {
            aeEntity.setAppName(ae.getAppName());
            modifiedAttributes.setAppName(ae.getAppName());
        }
        if (!ae.getPointOfAccess().isEmpty()) {
            aeEntity.getPointOfAccess().clear();
            aeEntity.getPointOfAccess().addAll(ae.getPointOfAccess());
            modifiedAttributes.getPointOfAccess().addAll(ae.getPointOfAccess());
        }
        if (ae.getOntologyRef() != null) {
            aeEntity.setOntologyRef(ae.getOntologyRef());
            modifiedAttributes.setOntologyRef(ae.getOntologyRef());
        }
        if (ae.getRequestReachability() != null) {
            aeEntity.setRequestReachability(ae.getRequestReachability().booleanValue());
            modifiedAttributes.setRequestReachability(ae.getRequestReachability());
        }
        aeEntity.setLastModifiedTime(Util.DateUtil.now());
        modifiedAttributes.setLastModifiedTime(aeEntity.getLastModifiedTime());
        response.setContent((Object)modifiedAttributes);
        this.dbs.getDAOFactory().getAeDAO().update(this.transaction, (Object)aeEntity);
        if (previousDynamicAuthorizationConsultations != null) {
            DynamicAuthorizationConsultationEntity daceFromDB;
            for (DynamicAuthorizationConsultationEntity dace : previousDynamicAuthorizationConsultations) {
                daceFromDB = (DynamicAuthorizationConsultationEntity)this.dbs.getDAOFactory().getDynamicAuthorizationDAO().find(this.transaction, (Object)dace.getResourceID());
                daceFromDB.getLinkedAeEntities().remove(aeEntity);
                this.dbs.getDAOFactory().getDynamicAuthorizationDAO().update(this.transaction, (Object)daceFromDB);
            }
            for (DynamicAuthorizationConsultationEntity dace : aeEntity.getDynamicAuthorizationConsultations()) {
                daceFromDB = (DynamicAuthorizationConsultationEntity)this.dbs.getDAOFactory().getDynamicAuthorizationDAO().find(this.transaction, (Object)dace.getResourceID());
                daceFromDB.getLinkedAeEntities().add(aeEntity);
                this.dbs.getDAOFactory().getDynamicAuthorizationDAO().update(this.transaction, (Object)daceFromDB);
            }
        }
        this.transaction.commit();
        Notifier.notify(aeEntity.getSubscriptions(), (ResourceEntity)aeEntity, 3);
        response.setResponseStatusCode(ResponseStatusCode.UPDATED);
        return response;
    }

    @Override
    public ResponsePrimitive doDelete(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        AeEntity aeEntity = (AeEntity)this.dbs.getDAOFactory().getAeDAO().find(this.transaction, (Object)request.getTo());
        if (aeEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        this.transaction.lock((Object)aeEntity);
        this.checkPermissions(request, (ResourceEntity)aeEntity, aeEntity.getAccessControlPolicies());
        UriMapper.deleteUri(aeEntity.getHierarchicalURI());
        if (aeEntity.getGeneratedAcp() != null) {
            UriMapper.deleteUri(aeEntity.getGeneratedAcp().getHierarchicalURI());
        }
        Notifier.notifyDeletion(aeEntity.getSubscriptions(), (ResourceEntity)aeEntity);
        this.dbs.getDAOFactory().getAeDAO().delete(this.transaction, (Object)aeEntity);
        this.transaction.commit();
        if (!aeEntity.getAnnounceTo().isEmpty()) {
            Announcer.deAnnounce((AnnounceableSubordinateEntity)aeEntity, Constants.ADMIN_REQUESTING_ENTITY);
        }
        response.setResponseStatusCode(ResponseStatusCode.DELETED);
        return response;
    }
}

