/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite.ae;

import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.FlexContainer;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.das.testsuite.Test;
import org.eclipse.om2m.das.testsuite.ae.AbstractDASServiceTest;
import org.eclipse.om2m.interworking.service.InterworkingService;
import org.osgi.framework.ServiceRegistration;

public class DASServiceTest_FlexContainer
extends AbstractDASServiceTest {
    public DASServiceTest_FlexContainer(CseService pCseService) {
        super("DasServiceTest_FlexContainer", pCseService);
    }

    @Override
    public void performTest() {
        DynamicAuthorizationConsultation dac = this.createDAS(this.getDasAE().getResourceID());
        if (dac == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create dac");
            return;
        }
        this.setExpectedNumberOfCall(1);
        ServiceRegistration<InterworkingService> interworkingServiceRegistration = this.registerInterworkingService(this);
        ArrayList<String> dacis = new ArrayList<String>();
        dacis.add(dac.getResourceID());
        FlexContainer createdFlexContainer = this.createFlexContainer(dacis);
        if (createdFlexContainer == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create FlexContainer");
            return;
        }
        ResponsePrimitive response = this.retrieveEntity(createdFlexContainer.getResourceID(), "nom:password");
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to retrieve FlexContainer, expecting " + ResponseStatusCode.OK + ", found =" + response.getResponseStatusCode());
            return;
        }
        if (!this.checkCall(0, createdFlexContainer.getResourceID(), "nom:password", Operation.RETRIEVE)) {
            return;
        }
        this.clearCalls();
        FlexContainer toBeUpdated = new FlexContainer();
        CustomAttribute customAttribute = new CustomAttribute();
        customAttribute.setShortName("test");
        customAttribute.setValue("value");
        createdFlexContainer.getCustomAttributes().add(customAttribute);
        RequestPrimitive updateRequest = new RequestPrimitive();
        updateRequest.setFrom("nom:prenom");
        updateRequest.setTo(createdFlexContainer.getResourceID());
        updateRequest.setOperation(Operation.UPDATE);
        updateRequest.setRequestContentType("application/obj");
        updateRequest.setReturnContentType("application/obj");
        updateRequest.setContent((Object)toBeUpdated);
        ResponsePrimitive updateResponse = this.getCseService().doRequest(updateRequest);
        if (updateResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("updateFlexContainer response is null");
            return;
        }
        if (!ResponseStatusCode.UPDATED.equals(updateResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to update FlexContainer, expecting " + ResponseStatusCode.UPDATED + ", found " + updateResponse.getResponseStatusCode());
            return;
        }
        if (!this.checkCall(0, createdFlexContainer.getResourceID(), "nom:prenom", Operation.UPDATE)) {
            return;
        }
        this.clearCalls();
        FlexContainer flexContainerChildToBeCreated = new FlexContainer();
        flexContainerChildToBeCreated.setContainerDefinition("tototto");
        flexContainerChildToBeCreated.setName("FlexContainer_" + UUID.randomUUID());
        RequestPrimitive createChildRequest = new RequestPrimitive();
        createChildRequest.setContent((Object)flexContainerChildToBeCreated);
        createChildRequest.setRequestContentType("application/obj");
        createChildRequest.setReturnContentType("application/obj");
        createChildRequest.setResourceType(28);
        createChildRequest.setFrom("nana:nono");
        createChildRequest.setTo(createdFlexContainer.getResourceID());
        createChildRequest.setOperation(Operation.CREATE);
        ResponsePrimitive createChildResponse = this.getCseService().doRequest(createChildRequest);
        if (createChildResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("create child response is null");
            return;
        }
        if (!ResponseStatusCode.CREATED.equals(createChildResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create a child FlexContainer, expecting " + ResponseStatusCode.CREATED + ", found " + createChildResponse.getResponseStatusCode());
            return;
        }
        if (!this.checkCall(0, createdFlexContainer.getResourceID(), "nana:nono", Operation.CREATE)) {
            return;
        }
        this.clearCalls();
        RequestPrimitive deleteRequest = new RequestPrimitive();
        deleteRequest.setTo(createdFlexContainer.getResourceID());
        deleteRequest.setFrom("toto:tata");
        deleteRequest.setOperation(Operation.DELETE);
        ResponsePrimitive deleteResponse = this.getCseService().doRequest(deleteRequest);
        if (deleteResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("deleteFlexContainer response is null");
            return;
        }
        if (!ResponseStatusCode.DELETED.equals(deleteResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to delete FlexContainer, expecting " + ResponseStatusCode.DELETED + ", found " + deleteResponse.getResponseStatusCode());
            return;
        }
        if (!this.checkCall(0, createdFlexContainer.getResourceID(), "toto:tata", Operation.DELETE)) {
            return;
        }
        this.unregisterInterworkingService(interworkingServiceRegistration);
        this.setState(Test.State.OK);
    }
}

