/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.hue.impl.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.hue.api.Group;
import org.eclipse.om2m.hue.api.types.HueException;
import org.eclipse.om2m.hue.api.types.UnknownHueGatewayException;
import org.eclipse.om2m.hue.impl.controller.HueConstants;
import org.eclipse.om2m.hue.impl.controller.Light;
import org.eclipse.om2m.hue.impl.controller.LightGroup;
import org.eclipse.om2m.hue.impl.controller.Utils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Controller
implements HueConstants {
    private static Log Logger = LogFactory.getLog(Controller.class);
    private String IP;
    private String userName;
    private List<LightGroup> groups;
    private List<Light> lights;
    private boolean pairWithBridge = true;

    public Controller(String IP, String usr) throws HueException, UnknownHueGatewayException {
        this.IP = IP;
        this.userName = usr;
        this.lights = new ArrayList<Light>();
        this.groups = new ArrayList<LightGroup>();
        if (this.userName == null || this.userName.equals("")) {
            this.pairWithBridge();
        }
        this.discoverBridgeResources();
    }

    private void pairWithBridge() throws UnknownHueGatewayException {
        while (this.pairWithBridge && !Thread.currentThread().isInterrupted()) {
            Logger.warn((Object)"Press the button on the Hue bridge. Next pairing attempt in 10 seconds...");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                Logger.warn((Object)"Pairing interrupted", (Throwable)e);
            }
            try {
                JSONParser parser = new JSONParser();
                String resp = this.sendPairRequest("", "{\"devicetype\":\"onem2m#mn-cse-hue-app\"}");
                if (!resp.substring(3, 8).equals("error")) {
                    JSONArray response = (JSONArray)parser.parse(resp);
                    this.userName = String.valueOf(((JSONObject)((JSONObject)response.get(0)).get((Object)"success")).get((Object)"username"));
                    this.pairWithBridge = false;
                    Logger.info((Object)("Bridge paired for user: " + this.userName));
                    return;
                }
                Logger.warn((Object)"Pairing failed, retrying...");
            }
            catch (HueException hueException) {
                Logger.warn((Object)"Pairing failed, retrying...");
            }
            catch (Exception e) {
                Logger.error((Object)"Unexpected communication error with Hue Bridge", (Throwable)e);
                throw new UnknownHueGatewayException(e.getMessage());
            }
        }
    }

    private void discoverBridgeResources() throws HueException, UnknownHueGatewayException {
        this.groupDiscovery();
        this.lightDiscovery();
    }

    private void groupDiscovery() throws HueException, UnknownHueGatewayException {
        String resp = this.sendRequest("groups");
        if (resp.equals("{}")) {
            return;
        }
        if (resp.substring(3, 8).equals("error")) {
            throw new HueException("ERROR while getting Hue groups! Check if username : " + this.userName + " is correct" + "\n\t" + resp);
        }
        try {
            ContainerFactory containerFactory = new ContainerFactory(){

                public List creatArrayContainer() {
                    return new ArrayList();
                }

                public Map createObjectContainer() {
                    return new HashMap();
                }
            };
            Map objs = (Map)new JSONParser().parse(resp, containerFactory);
            for (Map.Entry entry : objs.entrySet()) {
                String groupId = entry.getKey().toString();
                String groupName = entry.getValue().toString();
                groupName = groupName.substring(6, groupName.indexOf("}"));
                this.groups.add(new LightGroup(this.IP, this.userName, groupId, groupName));
            }
        }
        catch (ParseException parseException) {
            throw new HueException("ERROR while getting Hue groups! Error while parsing response : \n\t" + resp);
        }
        for (LightGroup group : this.groups) {
            resp = this.sendRequest("groups/" + group.getId());
            if (resp.equals("{}")) continue;
            if (resp.substring(3, 8).equals("error")) {
                throw new HueException("ERROR! could not get lights for group : " + group.getName() + "\n\t" + resp);
            }
            try {
                JSONObject obj = (JSONObject)new JSONParser().parse(resp);
                JSONArray jsonLights = (JSONArray)obj.get((Object)"lights");
                Iterator it2 = jsonLights.iterator();
                while (it2.hasNext()) {
                    group.addLight(new Light(this.IP, this.userName, it2.next().toString()));
                }
            }
            catch (ParseException parseException) {
                throw new HueException("ERROR while getting Hue lights for groups! Error while parsing response : \n\t" + resp);
            }
        }
    }

    private void lightDiscovery() throws HueException, UnknownHueGatewayException {
        String resp = this.sendRequest("lights");
        if (resp.equals("") || resp.equals("{}")) {
            return;
        }
        if (resp.substring(3, 8).equals("error")) {
            throw new HueException("ERROR wile getting lights! Check if username : " + this.userName + " is correct" + "\n\t" + resp);
        }
        try {
            ContainerFactory containerFactory = new ContainerFactory(){

                public List creatArrayContainer() {
                    return new ArrayList();
                }

                public Map createObjectContainer() {
                    return new HashMap();
                }
            };
            Map obj = (Map)new JSONParser().parse(resp, containerFactory);
            Iterator it = obj.keySet().iterator();
            while (it.hasNext()) {
                String lightId = it.next().toString();
                this.lights.add(new Light(this.IP, this.userName, lightId));
            }
            int all = 0;
            LightGroup lg = new LightGroup(this.IP, this.userName, "" + all, Group.getGroup((int)all));
            lg.setLightList(this.lights);
            this.groups.add(lg);
        }
        catch (ParseException parseException) {
            throw new HueException("ERROR while getting Hue lights for groups! Error while parsing response : \n\t" + resp);
        }
    }

    public List<Light> getLights() throws HueException, UnknownHueGatewayException {
        this.lights.clear();
        this.lightDiscovery();
        return this.lights;
    }

    public Light getLightByName(String lightName) throws HueException {
        for (Light l : this.lights) {
            if (!l.getName().equals(lightName)) continue;
            return l;
        }
        throw new HueException("Not found Light element for name : " + lightName);
    }

    public Light getLightById(String lightId) throws HueException {
        for (Light l : this.lights) {
            if (!l.getId().equals(lightId)) continue;
            return l;
        }
        throw new HueException("Not found Light element for id : " + lightId);
    }

    public List<LightGroup> getGroups() {
        return this.groups;
    }

    public List<Light> getLights(String groupName) {
        try {
            return this.getGroup(groupName).getLights();
        }
        catch (HueException hueException) {
            return new ArrayList<Light>();
        }
    }

    public LightGroup getGroup(String groupName) throws HueException {
        for (LightGroup g : this.groups) {
            if (!g.getName().equals(groupName)) continue;
            return g;
        }
        throw new HueException("Not found LightGroup element for name : " + groupName);
    }

    public String getIP() {
        return this.IP;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPairWithBridge(boolean pairWithBridge) {
        this.pairWithBridge = pairWithBridge;
    }

    private final String sendRequest(String req) throws HueException, UnknownHueGatewayException {
        Logger.debug((Object)("Sending request to: " + this.IP + "/api/" + this.userName + "/" + req));
        return Utils.sendGetRequest(String.valueOf(this.IP) + "/api/" + this.userName, req);
    }

    private final String sendPairRequest(String req, String body) throws HueException, UnknownHueGatewayException {
        Logger.debug((Object)("Sending request to: " + this.IP + "/api/ with body: " + body));
        return Utils.sendPostRequest(String.valueOf(this.IP) + "/api", req, body);
    }
}

