/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.netatmo.model;

import java.util.ArrayList;
import java.util.List;

public class Token {
    private final String accessToken;
    private final String refreshToken;
    private final List<String> scopes;
    private final Long expireIn;
    private final long expire;
    private boolean isInvalid = false;

    public Token(String pAccessToken, String pRefreshToken, Long pExpireIn) {
        this.accessToken = pAccessToken;
        this.refreshToken = pRefreshToken;
        this.expireIn = pExpireIn;
        this.scopes = new ArrayList<String>();
        this.expire = System.currentTimeMillis() + this.expireIn * 1000L;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void addScope(String scope) {
        this.scopes.add(scope);
    }

    public Long getExpireIn() {
        return this.expireIn;
    }

    public boolean isValid() {
        return !this.isInvalid && System.currentTimeMillis() < this.expire;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Token(accessToken=");
        sb.append(this.accessToken);
        sb.append(", refreshToken=");
        sb.append(this.refreshToken);
        sb.append(", expireIn=");
        sb.append(this.expireIn);
        sb.append(")");
        return sb.toString();
    }

    public void invalidateToken() {
        this.isInvalid = true;
    }
}

