/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.netatmo.sdt;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.datapoints.ArrayDataPoint;
import org.eclipse.om2m.sdt.datapoints.StringDataPoint;
import org.eclipse.om2m.sdt.datapoints.UriDataPoint;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.devices.Camera;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.driver.Logger;
import org.eclipse.om2m.sdt.home.driver.Utils;
import org.eclipse.om2m.sdt.home.modules.PersonSensor;
import org.eclipse.om2m.sdt.home.modules.PlayerControl;
import org.eclipse.om2m.sdt.home.modules.SessionDescription;
import org.eclipse.om2m.sdt.home.netatmo.impl.Activator;
import org.eclipse.om2m.sdt.home.netatmo.model.DetectedPerson;
import org.eclipse.om2m.sdt.home.netatmo.model.WelcomeCamera;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.PlayerMode;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class SDTWelcomeCameraDevice
extends Camera {
    private static final long DEFAULT_DETECTION_THRESHOLD = 75000L;
    private static final Logger LOGGER = new Logger("Netatmo");
    private static List<PlayerMode.Values> supportedPlayerModes = Arrays.asList(PlayerMode.Values.play, PlayerMode.Values.stop, PlayerMode.Values.pause, PlayerMode.Values.resume);
    private final WelcomeCamera camera;
    private List<ServiceRegistration> serviceRegistrations;
    private long detectionThreshold;
    private Map<String, DetectedPerson> detectedPersons = new HashMap<String, DetectedPerson>();

    public SDTWelcomeCameraDevice(WelcomeCamera pCamera, int detectionThreshold) {
        super(SDTWelcomeCameraDevice.computeId(pCamera.getName()), pCamera.getId(), Activator.NETATMO_DOMAIN);
        this.camera = pCamera;
        this.detectionThreshold = detectionThreshold <= 0 ? 75000L : (long)detectionThreshold;
        this.setDeviceManufacturer("Netatmo");
        this.setDeviceName(pCamera.getName());
        this.setDeviceModelName(this.camera.getType());
        this.setProtocol("Netatmo");
        try {
            this.setPresentationURL(new URL("https://www.netatmo.com/product/security/welcome"));
        }
        catch (MalformedURLException malformedURLException) {}
        this.setPersonSensor(new PersonSensor("personSensor_" + this.getId(), Activator.NETATMO_DOMAIN, (ArrayDataPoint)new ArrayDataPoint<String>((Identifiers.Typed)DatapointType.detectedPersons){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<String> doGetValue() throws DataPointException {
                ArrayList<String> ret = new ArrayList<String>();
                Map map = SDTWelcomeCameraDevice.this.detectedPersons;
                synchronized (map) {
                    for (DetectedPerson dp : SDTWelcomeCameraDevice.this.detectedPersons.values()) {
                        Activator.logger.info("check " + dp.getPersonName() + " date=" + new Date(dp.getTime() * 1000L), SDTWelcomeCameraDevice.class);
                        if (!SDTWelcomeCameraDevice.this.recentlyDetected(dp)) continue;
                        ret.add(dp.getPersonName());
                    }
                }
                return ret;
            }
        }));
        SessionDescription sdp = new SessionDescription("sdp_" + this.getId(), Activator.NETATMO_DOMAIN);
        sdp.setUrl(new UriDataPoint((Identifiers)DatapointType.url){

            protected URI doGetValue() throws DataPointException {
                try {
                    return new URI(String.valueOf(SDTWelcomeCameraDevice.this.camera.getVpnUrl()) + "/live/" + (SDTWelcomeCameraDevice.this.camera.getUseLocalUrl() != false ? "index_local.m3u8" : "index.m3u8"));
                }
                catch (URISyntaxException e) {
                    throw new DataPointException((Throwable)e);
                }
            }
        });
        sdp.setSdp(new StringDataPoint((Identifiers)DatapointType.sdp){

            protected String doGetValue() throws DataPointException {
                return "HLS";
            }
        });
        this.setSessionDescription(sdp);
        this.setPlayerControl(new PlayerControl("player_" + this.getId(), Activator.NETATMO_DOMAIN, new PlayerMode(){

            protected PlayerMode.Values doGetValue() throws DataPointException {
                return SDTWelcomeCameraDevice.this.camera.getAlimOk().booleanValue() ? (SDTWelcomeCameraDevice.this.camera.getIsOn().booleanValue() ? PlayerMode.Values.play : PlayerMode.Values.stop) : PlayerMode.Values.pause;
            }

            protected void doSetValue(PlayerMode.Values v) throws DataPointException {
                throw new DataPointException("Not implemented");
            }
        }, (ArrayDataPoint)new ArrayDataPoint<PlayerMode.Values>((Identifiers.Typed)DatapointType.supportedPlayerModes){

            public List<PlayerMode.Values> doGetValue() throws DataPointException {
                return supportedPlayerModes;
            }
        }));
    }

    public void register(BundleContext context) {
        if (this.serviceRegistrations == null) {
            this.serviceRegistrations = Utils.register((GenericDevice)this, (BundleContext)context);
        }
    }

    public void unregister() {
        if (this.serviceRegistrations != null) {
            for (ServiceRegistration sr : this.serviceRegistrations) {
                sr.unregister();
            }
        }
        Activator.NETATMO_DOMAIN.removeDevice(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPerson(String personId, String personName, Long time) {
        Map<String, DetectedPerson> map = this.detectedPersons;
        synchronized (map) {
            DetectedPerson dp = this.detectedPersons.get(personId);
            if (dp == null) {
                dp = new DetectedPerson(personId, personName);
                this.detectedPersons.put(personId, dp);
            }
            dp.setTime(time);
        }
    }

    private boolean recentlyDetected(DetectedPerson dp) {
        long diff = System.currentTimeMillis() - dp.getTime() * 1000L;
        boolean ret = diff < this.detectionThreshold;
        Activator.logger.info(String.valueOf(dp.getPersonName()) + (ret ? " detected recently " : "detected too long ago ") + diff);
        LOGGER.info(String.valueOf(dp.getPersonName()) + (ret ? " detected recently " : "detected too long ago ") + diff + " " + this.detectionThreshold);
        return ret;
    }

    private static String computeId(String pId) {
        return pId.replaceAll("[^a-zA-Z0-9]+", "_").trim();
    }
}

