/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt;

import org.eclipse.om2m.sdt.Device;
import org.eclipse.om2m.sdt.Element;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.types.DataType;

public class DataPoint
extends Element {
    private boolean optional;
    private boolean readable;
    private boolean writable;
    private DataType type;
    private Device owner;
    private Module parent;
    private String longName;
    private String shortName;

    public DataPoint(Identifiers name, DataType type) {
        super(name.getShortName());
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.optional = false;
        this.readable = true;
        this.writable = true;
        this.longName = name.getLongName();
        this.shortName = name.getShortName();
    }

    public DataType getDataType() {
        return this.type;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public void setReadable(boolean readable) {
        this.readable = readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public void setWritable(boolean writable) {
        this.writable = writable;
    }

    @Override
    protected String prettyPrint(String t1) {
        String t2 = String.valueOf(t1) + "\t";
        StringBuffer ret = new StringBuffer(t1).append("<DataPoint name=\"" + this.getName() + "\" readable=\"" + this.readable + "\" writable=\"" + this.writable + "\">");
        if (this.getDoc() != null) {
            ret.append("\n").append(t2).append(this.getDoc());
        }
        return ret.append("\n").append(this.type.prettyPrint(t2)).append("\n").append(t1).append("</DataPoint>").toString();
    }

    void setOwner(Device owner) {
        this.owner = owner;
    }

    public Device getOwner() {
        return this.owner;
    }

    void setParent(Module parent) {
        this.parent = parent;
    }

    public Module getParent() {
        return this.parent;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String toString() {
        return "<" + this.getClass().getSimpleName() + " name=" + this.name + " shortName=" + this.shortName + " longName=" + this.longName + " type=" + this.type + "/>";
    }
}

