/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.types;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.sdt.types.DataType;

public class Array<T>
implements DataType.TypeChoice {
    private DataType dataType;

    public Array(DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public String getOneM2MType() {
        String ret = this.dataType.getTypeChoice().getOneM2MType();
        return ret.startsWith("[") ? ret : "[" + ret + "]";
    }

    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public String toString(Object val) throws Exception {
        if (val instanceof List) {
            String ret = "[";
            boolean first = true;
            for (Object item : (List)val) {
                if (first) {
                    first = false;
                } else {
                    ret = String.valueOf(ret) + ",";
                }
                ret = String.valueOf(ret) + this.dataType.getTypeChoice().toString(item);
            }
            return String.valueOf(ret) + "]";
        }
        return val.toString();
    }

    @Override
    public Object fromString(String val) throws Exception {
        ArrayList<Object> ret = new ArrayList<Object>();
        String s = val.trim();
        if (s.startsWith("[")) {
            s = s.substring(1, s.length() - 1);
        }
        String[] stringArray = s.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            ret.add(this.dataType.getTypeChoice().fromString(item));
            ++n2;
        }
        return ret;
    }
}

