/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sample.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.ipe.sample.model.Lamp;

public class SampleModel {
    private static Map<String, Lamp> LAMPS = new HashMap<String, Lamp>();
    private static List<LampObserver> OBSERVERS = new ArrayList<LampObserver>();

    private SampleModel() {
    }

    public static void setLampState(String lampId, boolean value) {
        SampleModel.checkLampIdValue(lampId);
        LAMPS.get(lampId).setState(value);
        SampleModel.notifyObservers(lampId, value);
    }

    public static boolean getLampValue(String lampId) {
        SampleModel.checkLampIdValue(lampId);
        return LAMPS.get(lampId).getState();
    }

    public static void checkLampIdValue(String lampId) {
        if (lampId == null || !LAMPS.containsKey(lampId)) {
            throw new BadRequestException("Unknow lamp id");
        }
    }

    public static void addObserver(LampObserver obs) {
        if (!OBSERVERS.contains(obs)) {
            OBSERVERS.add(obs);
        }
    }

    public static void deleteObserver(LampObserver obs) {
        if (OBSERVERS.contains(obs)) {
            OBSERVERS.remove(obs);
        }
    }

    private static void notifyObservers(final String lampId, final boolean state) {
        new Thread(){

            @Override
            public void run() {
                for (LampObserver obs : OBSERVERS) {
                    obs.onLampStateChange(lampId, state);
                }
            }
        }.start();
    }

    public static void setModel(Map<String, Lamp> lamps2) {
        LAMPS = lamps2;
    }

    public static interface LampObserver {
        public void onLampStateChange(String var1, boolean var2);
    }
}

