/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeAnncEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.FlexContainerEntity;
import org.eclipse.om2m.commons.entities.GroupEntity;
import org.eclipse.om2m.commons.entities.NodeAnncEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.PollingChannelEntity;
import org.eclipse.om2m.commons.entities.ScheduleEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;

@Entity(name="CSR")
@Inheritance(strategy=InheritanceType.JOINED)
public class RemoteCSEEntity
extends AnnounceableSubordinateEntity {
    @Column(name="cst")
    protected BigInteger cseType;
    @Column(name="poa")
    protected List<String> pointOfAccess;
    @Column(name="cb")
    protected String remoteCseUri;
    @Column(name="csi")
    protected String remoteCseId;
    @Column(name="mei")
    protected String m2mExtId;
    @Column(name="tri")
    protected Long triggerRecipientID;
    @Column(name="rr")
    protected boolean requestReachability;
    @Column(name="nl")
    protected String nodeLink;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    protected AccessControlPolicyEntity generatedAcp;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=CSEBaseEntity.class)
    @JoinTable(name="CSB_CSR", joinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="CSEB_ID", referencedColumnName="ri")})
    protected CSEBaseEntity parentCseBase;
    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="CSR_ACP_JOIN", joinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AccessControlPolicyEntity> accessControlPolicies;
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="linkedRemoteCSEEntities")
    @JoinTable(name="CSR_DAC_JOIN", joinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="DAC_JOINID", referencedColumnName="ri")})
    protected List<DynamicAuthorizationConsultationEntity> dynamicAuthorizationConsultations;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="parentCsr")
    @JoinTable(name="CSR_CHAE_JOIN", joinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="AE_ID", referencedColumnName="ri")})
    protected List<AeEntity> childAes;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="CSR_CHCNT_JOIN", joinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="CNT_ID", referencedColumnName="ri")})
    protected List<ContainerEntity> childCnt;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="parentCSR")
    @JoinTable(name="CSR_CHFCNT_JOIN", joinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="FCNT_ID", referencedColumnName="ri")})
    protected List<FlexContainerEntity> childFcnt;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="CSR_CHGRP_JOIN", joinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="grp_id", referencedColumnName="ri")})
    protected List<GroupEntity> childGrps;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentCsr", cascade={CascadeType.ALL})
    @JoinTable(name="CSR_ACPCH_JOIN", joinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AccessControlPolicyEntity> childAcps;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentCsr", cascade={CascadeType.ALL})
    @JoinTable(name="CSR_AEANNCH_JOIN", joinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="AEANNC_ID", referencedColumnName="ri")})
    protected List<AeAnncEntity> childAeAnncs;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="parentCsr")
    @JoinTable(name="CSR_SUB_JOIN", joinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected List<SubscriptionEntity> subscriptions;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, targetEntity=PollingChannelEntity.class)
    @JoinTable(name="CSR_PCH_JOIN", joinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="PCH_JOIN_ID", referencedColumnName="ri")})
    protected List<PollingChannelEntity> pollingChannels;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, targetEntity=ScheduleEntity.class)
    @JoinColumn(name="sch_id")
    protected ScheduleEntity linkedSchedule;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="parentCsr")
    @JoinTable(name="CSR_NOD_CH_JOIN", joinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")})
    protected List<NodeEntity> childNodes;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="parentCsr")
    @JoinTable(name="CSR_NODANNC_CH_JOIN", joinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="NODANNC_JOIN_ID", referencedColumnName="ri")})
    protected List<NodeAnncEntity> childAnncNodes;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="parentRemoteCse")
    @JoinTable(name="CSR_DACCHILD_JOIN", joinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="DAC_JOINID", referencedColumnName="ri")})
    private List<DynamicAuthorizationConsultationEntity> childDynamicAuthorizationConsultation;

    public BigInteger getCseType() {
        return this.cseType;
    }

    public void setCseType(BigInteger cseType) {
        this.cseType = cseType;
    }

    public List<String> getPointOfAccess() {
        if (this.pointOfAccess == null) {
            this.pointOfAccess = new ArrayList<String>();
        }
        return this.pointOfAccess;
    }

    public void setPointOfAccess(List<String> pointOfAccess) {
        this.pointOfAccess = pointOfAccess;
    }

    public String getRemoteCseUri() {
        return this.remoteCseUri;
    }

    public void setRemoteCseUri(String remoteCseUri) {
        this.remoteCseUri = remoteCseUri;
    }

    public String getRemoteCseId() {
        return this.remoteCseId;
    }

    public void setRemoteCseId(String remoteCseId) {
        this.remoteCseId = remoteCseId;
    }

    public String getM2mExtId() {
        return this.m2mExtId;
    }

    public void setM2mExtId(String m2mExtId) {
        this.m2mExtId = m2mExtId;
    }

    public Long getTriggerRecipientID() {
        return this.triggerRecipientID;
    }

    public void setTriggerRecipientID(Long triggerRecipientID) {
        this.triggerRecipientID = triggerRecipientID;
    }

    public boolean isRequestReachability() {
        return this.requestReachability;
    }

    public void setRequestReachability(boolean requestReachability) {
        this.requestReachability = requestReachability;
    }

    public String getNodeLink() {
        return this.nodeLink;
    }

    public void setNodeLink(String nodeLink) {
        this.nodeLink = nodeLink;
    }

    public CSEBaseEntity getParentCseBase() {
        return this.parentCseBase;
    }

    public void setParentCseBase(CSEBaseEntity parentCseBase) {
        this.parentCseBase = parentCseBase;
    }

    @Override
    public List<AccessControlPolicyEntity> getAccessControlPolicies() {
        if (this.accessControlPolicies == null) {
            this.accessControlPolicies = new ArrayList<AccessControlPolicyEntity>();
        }
        return this.accessControlPolicies;
    }

    @Override
    public void setAccessControlPolicies(List<AccessControlPolicyEntity> accessControlPolicies) {
        this.accessControlPolicies = accessControlPolicies;
    }

    public List<AeEntity> getChildAes() {
        if (this.childAes == null) {
            this.childAes = new ArrayList<AeEntity>();
        }
        return this.childAes;
    }

    public void setChildAes(List<AeEntity> childAes) {
        this.childAes = childAes;
    }

    public List<AeAnncEntity> getChildAeAnncs() {
        if (this.childAeAnncs == null) {
            this.childAeAnncs = new ArrayList<AeAnncEntity>();
        }
        return this.childAeAnncs;
    }

    public void setChildAeAnncs(List<AeAnncEntity> childAeAnncs) {
        this.childAeAnncs = childAeAnncs;
    }

    public List<ContainerEntity> getChildCnt() {
        if (this.childCnt == null) {
            this.childCnt = new ArrayList<ContainerEntity>();
        }
        return this.childCnt;
    }

    public void setChildCnt(List<ContainerEntity> childCnt) {
        this.childCnt = childCnt;
    }

    public List<FlexContainerEntity> getChildFcnt() {
        if (this.childFcnt == null) {
            this.childFcnt = new ArrayList<FlexContainerEntity>();
        }
        return this.childFcnt;
    }

    public void setChildFcnt(List<FlexContainerEntity> childFcnt) {
        this.childFcnt = childFcnt;
    }

    public List<GroupEntity> getChildGrps() {
        if (this.childGrps == null) {
            this.childGrps = new ArrayList<GroupEntity>();
        }
        return this.childGrps;
    }

    public void setChildGrps(List<GroupEntity> childGrps) {
        this.childGrps = childGrps;
    }

    public List<AccessControlPolicyEntity> getChildAcps() {
        if (this.childAcps == null) {
            this.childAcps = new ArrayList<AccessControlPolicyEntity>();
        }
        return this.childAcps;
    }

    public void setChildAcps(List<AccessControlPolicyEntity> childAcps) {
        this.childAcps = childAcps;
    }

    public List<SubscriptionEntity> getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<SubscriptionEntity>();
        }
        return this.subscriptions;
    }

    public void setSubscriptions(List<SubscriptionEntity> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public List<PollingChannelEntity> getPollingChannels() {
        if (this.pollingChannels == null) {
            this.pollingChannels = new ArrayList<PollingChannelEntity>();
        }
        return this.pollingChannels;
    }

    public void setPollingChannels(List<PollingChannelEntity> pollingChannels) {
        this.pollingChannels = pollingChannels;
    }

    public ScheduleEntity getLinkedSchedule() {
        return this.linkedSchedule;
    }

    public void setLinkedSchedule(ScheduleEntity linkedSchedule) {
        this.linkedSchedule = linkedSchedule;
    }

    public List<NodeEntity> getChildNodes() {
        if (this.childNodes == null) {
            this.childNodes = new ArrayList<NodeEntity>();
        }
        return this.childNodes;
    }

    public void setChildNodes(List<NodeEntity> childNodes) {
        this.childNodes = childNodes;
    }

    public List<NodeAnncEntity> getChildAnncNodes() {
        if (this.childAnncNodes == null) {
            this.childAnncNodes = new ArrayList<NodeAnncEntity>();
        }
        return this.childAnncNodes;
    }

    public void setChildAnncNodes(List<NodeAnncEntity> childNodes) {
        this.childAnncNodes = childNodes;
    }

    public AccessControlPolicyEntity getGeneratedAcp() {
        return this.generatedAcp;
    }

    public void setGeneratedAcp(AccessControlPolicyEntity generatedAcp) {
        this.generatedAcp = generatedAcp;
    }

    public List<DynamicAuthorizationConsultationEntity> getChildDynamicAuthorizationConsultation() {
        if (this.childDynamicAuthorizationConsultation == null) {
            this.childDynamicAuthorizationConsultation = new ArrayList<DynamicAuthorizationConsultationEntity>();
        }
        return this.childDynamicAuthorizationConsultation;
    }

    public void setChildDynamicAuthorizationConsultation(List<DynamicAuthorizationConsultationEntity> childDynamicAuthorizationConsultation) {
        this.childDynamicAuthorizationConsultation = childDynamicAuthorizationConsultation;
    }

    @Override
    public List<DynamicAuthorizationConsultationEntity> getDynamicAuthorizationConsultations() {
        if (this.dynamicAuthorizationConsultations == null) {
            this.dynamicAuthorizationConsultations = new ArrayList<DynamicAuthorizationConsultationEntity>();
        }
        return this.dynamicAuthorizationConsultations;
    }

    @Override
    public void setDynamicAuthorizationConsultations(List<DynamicAuthorizationConsultationEntity> list) {
        this.dynamicAuthorizationConsultations = list;
    }
}

