/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.modules.AbstractAlarmSensor;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class SmokeSensor
extends AbstractAlarmSensor {
    private IntegerDataPoint detectedTime;
    private IntegerDataPoint smokeThreshhold;
    private IntegerDataPoint currentValue;

    public SmokeSensor(String name, Domain domain, BooleanDataPoint alarm) {
        super(name, domain, alarm, ModuleType.smokeSensor, "The detection of smoke.");
    }

    public SmokeSensor(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (BooleanDataPoint)dps.get(DatapointType.alarm.getShortName()));
        IntegerDataPoint dp = (IntegerDataPoint)dps.get(DatapointType.detectedTime.getShortName());
        if (dp != null) {
            this.setDetectedTime(dp);
        }
        if ((dp = (IntegerDataPoint)dps.get(DatapointType.smokeThreshhold.getShortName())) != null) {
            this.setSmokeThreshhold(dp);
        }
        if ((dp = (IntegerDataPoint)dps.get(DatapointType.currentValue.getShortName())) != null) {
            this.setCurrentValue(dp);
        }
    }

    public void setDetectedTime(IntegerDataPoint dp) {
        this.detectedTime = dp;
        this.detectedTime.setOptional(true);
        this.detectedTime.setDoc("The time the smoke is detected.");
        this.addDataPoint((DataPoint)this.detectedTime);
    }

    public int getDetectedTime() throws DataPointException, AccessException {
        if (this.detectedTime == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.detectedTime.getValue();
    }

    public void setDetectedTime(int v) throws DataPointException, AccessException {
        if (this.detectedTime == null) {
            throw new DataPointException("Not implemented");
        }
        this.detectedTime.setValue((Object)v);
    }

    private void setCurrentValue(IntegerDataPoint dp) {
        this.currentValue = dp;
        this.currentValue.setOptional(true);
        this.currentValue.setWritable(false);
        this.currentValue.setDoc("The current data value of the smoke sensor.");
        this.addDataPoint((DataPoint)this.currentValue);
    }

    public int getCurrentValue() throws DataPointException, AccessException {
        if (this.currentValue == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.currentValue.getValue();
    }

    private void setSmokeThreshhold(IntegerDataPoint dp) {
        this.smokeThreshhold = dp;
        this.smokeThreshhold.setOptional(true);
        this.smokeThreshhold.setDoc("The threshhold to trigger the alarm. The unit of measure is ppm.");
        this.addDataPoint((DataPoint)this.smokeThreshhold);
    }

    public int getSmokeThreshhold() throws DataPointException, AccessException {
        if (this.smokeThreshhold == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.smokeThreshhold.getValue();
    }

    public void setSmokeThreshhold(int v) throws DataPointException, AccessException {
        if (this.smokeThreshhold == null) {
            throw new DataPointException("Not implemented");
        }
        this.smokeThreshhold.setValue((Object)v);
    }
}

