/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.MgmtObjEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.AnnounceableResource;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.MgmtObj;
import org.eclipse.om2m.commons.resource.Node;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.entitymapper.MgmtObjMapper;
import org.eclipse.om2m.core.entitymapper.SubscriptionMapper;

public class NodeMapper
extends EntityMapper<NodeEntity, Node> {
    private MgmtObjMapper mgmtObjMapper = new MgmtObjMapper();

    @Override
    protected void mapAttributes(NodeEntity entity, Node resource, int level, int offset) {
        if (level < 0) {
            return;
        }
        EntityMapperFactory.getAnnounceableSubordonateEntity_AnnounceableResourceMapper().mapAttributes((AnnounceableSubordinateEntity)entity, (AnnounceableResource)resource, level, offset);
        resource.setNodeID(entity.getNodeID());
        resource.setHostedCSELink(entity.getHostedCSELink());
        resource.setHostedServiceLinks(entity.getHostedServiceLinks());
    }

    @Override
    protected List<ChildResourceRef> getChildResourceRef(NodeEntity entity, int level, int offset) {
        ArrayList<ChildResourceRef> childRefs = new ArrayList<ChildResourceRef>();
        if (level == 0) {
            return childRefs;
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            ChildResourceRef child = new ChildResourceRef();
            child.setResourceName(sub.getName());
            child.setType(23);
            child.setValue(sub.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new SubscriptionMapper().getChildResourceRef(sub, level - 1, offset - 1));
        }
        for (MgmtObjEntity mgmtObj : entity.getMgmtObjEntities()) {
            childRefs.add(this.createChildResourceRef(mgmtObj));
            childRefs.addAll(this.mgmtObjMapper.getChildResourceRef(mgmtObj, level - 1, offset - 1));
        }
        return childRefs;
    }

    @Override
    protected void mapChildResourceRef(NodeEntity entity, Node resource, int level, int offset) {
        resource.getChildResource().addAll(this.getChildResourceRef(entity, level, offset));
    }

    @Override
    protected void mapChildResources(NodeEntity entity, Node resource, int level, int offset) {
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            Subscription subRes = (Subscription)new SubscriptionMapper().mapEntityToResource(sub, ResultContent.ATTRIBUTES, level - 1, offset - 1);
            resource.getSubscriptions().add(subRes);
        }
        for (MgmtObjEntity mgmtObj : entity.getMgmtObjEntities()) {
            resource.getMgmtObjs().add((MgmtObj)this.mgmtObjMapper.mapEntityToResource(mgmtObj, ResultContent.ATTRIBUTES, level - 1, offset - 1));
        }
    }

    @Override
    protected Node createResource() {
        return new Node();
    }

    private final ChildResourceRef createChildResourceRef(MgmtObjEntity entity) {
        ChildResourceRef chref = new ChildResourceRef();
        chref.setResourceName(entity.getName());
        chref.setType(13);
        chref.setValue(entity.getResourceID());
        return chref;
    }
}

