/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.nblocking;

import java.math.BigInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.RequestStatus;
import org.eclipse.om2m.commons.constants.ResponseType;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.RequestEntity;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.notifier.Notifier;
import org.eclipse.om2m.core.persistence.PersistenceService;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.router.Router;
import org.eclipse.om2m.persistence.service.DBService;
import org.eclipse.om2m.persistence.service.DBTransaction;

public class NonBlockingWorker
extends Thread {
    private String requestIdentifier;
    private RequestPrimitive request;
    private static final Log LOGGER = LogFactory.getLog(NonBlockingWorker.class);
    private boolean async = false;

    public NonBlockingWorker(String requestIdentifier, RequestPrimitive request) {
        this.requestIdentifier = requestIdentifier;
        this.request = request;
    }

    @Override
    public void run() {
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        Patterns patterns = new Patterns();
        RequestEntity managedRequest = (RequestEntity)dbs.getDAOFactory().getRequestEntityDAO().find(transaction, (Object)this.requestIdentifier);
        this.async = this.request.getResponseTypeInfo().getResponseType().equals(ResponseType.NON_BLOCKING_REQUEST_ASYNCH);
        this.request.getResponseTypeInfo().setResponseType(ResponseType.BLOCKING_REQUEST);
        if (!patterns.match(patterns.NON_RETARGETING_PATTERN, this.request.getTo())) {
            managedRequest.setRequestStatus(RequestStatus.FORWARDED);
            managedRequest.setStateTag(managedRequest.getStateTag().add(BigInteger.valueOf(1L)));
            dbs.getDAOFactory().getRequestEntityDAO().update(transaction, (Object)managedRequest);
            transaction.commit();
            transaction.close();
            transaction = dbs.getDbTransaction();
            transaction.open();
            managedRequest = (RequestEntity)dbs.getDAOFactory().getRequestEntityDAO().find(transaction, (Object)this.requestIdentifier);
        }
        this.request.setReturnContentType(managedRequest.getReturnContentType());
        ResponsePrimitive response = new Router().doRequest(this.request);
        if (response.getResponseStatusCode().intValue() >= 4000) {
            managedRequest.setRequestStatus(RequestStatus.FAILED);
            LOGGER.info((Object)("Request " + this.requestIdentifier + " failed."));
        } else {
            LOGGER.info((Object)("Request " + this.requestIdentifier + " completed"));
            managedRequest.setRequestStatus(RequestStatus.COMPLETED);
        }
        if (response.getContent() != null) {
            if (this.request.getReturnContentType().equals("application/obj")) {
                managedRequest.setOperationResultContent(DataMapperSelector.getDataMapperList().get("application/json").objToString(response.getContent()));
            } else if (this.request.getReturnContentType().equals("application/xml")) {
                Object objReseult = DataMapperSelector.getDataMapperList().get("application/xml").stringToObj((String)response.getContent());
                String jsonResult = DataMapperSelector.getDataMapperList().get("application/json").objToString(objReseult);
                managedRequest.setOperationResultContent(jsonResult);
            } else {
                managedRequest.setOperationResultContent((String)response.getContent());
            }
        }
        managedRequest.setOperationResultEventCategory(response.getEventCategory());
        managedRequest.setOperationResultFrom(response.getFrom());
        managedRequest.setOperationResultOriginatingTimestamp(response.getOriginatingTimestamp());
        managedRequest.setOperationResultRequestIdentifier(response.getRequestIdentifier());
        managedRequest.setOperationResultResponseStatusCode(response.getResponseStatusCode());
        managedRequest.setOperationResultResultExpirationTimestamp(response.getResultExpirationTimestamp());
        managedRequest.setOperationResultTo(response.getTo());
        dbs.getDAOFactory().getRequestEntityDAO().update(transaction, (Object)managedRequest);
        transaction.commit();
        if (this.async) {
            LOGGER.info((Object)"Asynchronous case, notifying URIs.");
            String representation = DataMapperSelector.getDataMapperList().get(this.request.getReturnContentType()).objToString((Object)EntityMapperFactory.getRequestMapper().mapEntityToResource(managedRequest, ResultContent.ATTRIBUTES, 0, 0));
            for (String uriNotif : this.request.getResponseTypeInfo().getNotificationURI()) {
                RequestPrimitive notifRequest = new RequestPrimitive();
                notifRequest.setTo(uriNotif);
                notifRequest.setContent((Object)representation);
                notifRequest.setFrom("/" + Constants.CSE_ID);
                notifRequest.setOperation(Operation.NOTIFY);
                notifRequest.setRequestContentType(this.request.getReturnContentType());
                Notifier.notify(notifRequest, uriNotif);
            }
        }
        transaction.close();
    }

    public String getRequestIdentifier() {
        return this.requestIdentifier;
    }

    public void setRequestIdentifier(String requestIdentifier) {
        this.requestIdentifier = requestIdentifier;
    }
}

