/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.workingsets.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.predicates.provider.PredicateItemProvider;
import org.eclipse.oomph.workingsets.ExclusionPredicate;
import org.eclipse.oomph.workingsets.WorkingSet;
import org.eclipse.oomph.workingsets.WorkingSetsPackage;
import org.eclipse.oomph.workingsets.provider.WorkingSetsEditPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExclusionPredicateItemProvider
extends PredicateItemProvider {
    public static void filterCircularWorkingSets(EObject root, Collection<?> objects) {
        Resource resource = root.eResource();
        EObject eObject = root.eContainer();
        while (eObject != null) {
            if (eObject instanceof WorkingSet) {
                Iterator<?> it = objects.iterator();
                while (it.hasNext()) {
                    Object value = it.next();
                    if (value instanceof WorkingSet) {
                        WorkingSet workingSet = (WorkingSet)value;
                        if (workingSet != eObject && workingSet.eResource() == resource && !ExclusionPredicateItemProvider.getReachableWorkingSets(workingSet).contains(eObject)) continue;
                        it.remove();
                        continue;
                    }
                    it.remove();
                }
            }
            eObject = eObject.eContainer();
        }
    }

    public static Set<WorkingSet> getReachableWorkingSets(WorkingSet workingSet) {
        HashSet<WorkingSet> workingSets = new HashSet<WorkingSet>();
        ExclusionPredicateItemProvider.collectReachableWorkingSets(workingSet, workingSets);
        return workingSets;
    }

    private static void collectReachableWorkingSets(WorkingSet workingSet, Set<WorkingSet> workingSets) {
        TreeIterator it = workingSet.eAllContents();
        while (it.hasNext()) {
            EObject child = (EObject)it.next();
            for (EObject reference : child.eCrossReferences()) {
                WorkingSet referecedWorkingSet;
                if (!(reference instanceof WorkingSet) || !workingSets.add(referecedWorkingSet = (WorkingSet)reference)) continue;
                ExclusionPredicateItemProvider.collectReachableWorkingSets(referecedWorkingSet, workingSets);
            }
        }
    }

    public ExclusionPredicateItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addExcludedWorkingSetsPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addExcludedWorkingSetsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ExclusionPredicate_excludedWorkingSets_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ExclusionPredicate_excludedWorkingSets_feature", "_UI_ExclusionPredicate_type"), (EStructuralFeature)WorkingSetsPackage.Literals.EXCLUSION_PREDICATE__EXCLUDED_WORKING_SETS, true, false, true, null, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                Collection result = super.getChoiceOfValues(object);
                ExclusionPredicateItemProvider.filterCircularWorkingSets((EObject)object, result);
                return result;
            }
        });
    }

    public boolean hasChildren(Object object) {
        return this.hasChildren(object, true);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/ExclusionPredicate"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        ExclusionPredicate exclusionPredicate = (ExclusionPredicate)object;
        StringBuilder result = new StringBuilder();
        for (WorkingSet workingSet : exclusionPredicate.getExcludedWorkingSets()) {
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(workingSet.getName());
        }
        return result.toString();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(ExclusionPredicate.class)) {
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected Command factorAddCommand(EditingDomain domain, CommandParameter commandParameter) {
        if (commandParameter.getFeature() == null) {
            EObject eOwner = commandParameter.getEOwner();
            ArrayList collection = commandParameter.getCollection();
            if (collection != null) {
                collection = new ArrayList(collection);
                ExclusionPredicateItemProvider.filterCircularWorkingSets(eOwner, collection);
                if (collection.size() == commandParameter.getCollection().size()) {
                    return new AddCommand(domain, eOwner, (EStructuralFeature)WorkingSetsPackage.Literals.EXCLUSION_PREDICATE__EXCLUDED_WORKING_SETS, collection);
                }
            }
        }
        return super.factorAddCommand(domain, commandParameter);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return WorkingSetsEditPlugin.INSTANCE;
    }
}

