/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.provider.ScopeItemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceItemProvider
extends ScopeItemProvider {
    private static final String EXPECTED_SUFFIX = ".metadata/.plugins/org.eclipse.oomph.setup/workspace.setup";

    public WorkspaceItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addStreamsPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addStreamsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Workspace_streams_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Workspace_streams_feature", "_UI_Workspace_type"), (EStructuralFeature)SetupPackage.Literals.WORKSPACE__STREAMS, true, false, true, null, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Workspace"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        URI uri;
        Workspace workspace = (Workspace)object;
        if (workspace.eContainer() != null) {
            return super.getText(object);
        }
        String label = this.getString("_UI_Workspace_type");
        Resource resource = workspace.eResource();
        if (resource != null && (uri = resource.getURI()) != null && (label = String.valueOf(label) + " " + uri).endsWith(EXPECTED_SUFFIX)) {
            label = label.substring(0, label.length() - EXPECTED_SUFFIX.length());
        }
        return label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Workspace.class)) {
            case 6: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected Command factorAddCommand(EditingDomain domain, CommandParameter commandParameter) {
        Collection collection = commandParameter.getCollection();
        if (collection != null) {
            for (Object object : collection) {
                Project project;
                EList streams;
                if (object instanceof Stream) {
                    return AddCommand.create((EditingDomain)domain, (Object)commandParameter.getOwner(), (Object)SetupPackage.Literals.WORKSPACE__STREAMS, object);
                }
                if (!(object instanceof Project) || (streams = (project = (Project)object).getStreams()).isEmpty()) continue;
                return AddCommand.create((EditingDomain)domain, (Object)commandParameter.getOwner(), (Object)SetupPackage.Literals.WORKSPACE__STREAMS, (Object)streams.get(0));
            }
        }
        return super.factorAddCommand(domain, commandParameter);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

