/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.ReplaceCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.Macro;
import org.eclipse.oomph.setup.MacroTask;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class InlineMacroTaskAction
implements IObjectActionDelegate {
    private final Set<MacroTask> macroTasks = new HashSet<MacroTask>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.macroTasks.clear();
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                MacroTask macroTask;
                Macro macro;
                Object element = objectArray[n2];
                if (element instanceof MacroTask && (macro = (macroTask = (MacroTask)element).getMacro()) != null && macroTask.getArguments().size() == macro.getParameters().size() && !StringUtil.isEmpty((String)macroTask.getID())) {
                    this.macroTasks.add(macroTask);
                }
                ++n2;
            }
        }
        action.setEnabled(!this.macroTasks.isEmpty());
        action.setImageDescriptor(SetupUIPlugin.INSTANCE.getImageDescriptor("inline"));
    }

    public void run(IAction action) {
        MacroTask firstTask = this.macroTasks.iterator().next();
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)firstTask);
        CompoundCommand compoundCommand = new CompoundCommand("Inline");
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)firstTask, (boolean)true);
        EList eAdapters = rootContainer.eAdapters();
        ECrossReferenceAdapter eCrossReferenceAdapter = new ECrossReferenceAdapter();
        eAdapters.add((Object)eCrossReferenceAdapter);
        for (MacroTask macroTask : this.macroTasks) {
            CompoundTask replacement = SetupTaskPerformer.expand((MacroTask)macroTask);
            Collection inverseReferences = eCrossReferenceAdapter.getInverseReferences((EObject)macroTask);
            for (EStructuralFeature.Setting setting : inverseReferences) {
                compoundCommand.append(ReplaceCommand.create((EditingDomain)domain, (Object)setting.getEObject(), (Object)setting.getEStructuralFeature(), (Object)macroTask, Collections.singleton(replacement)));
            }
        }
        eAdapters.remove((Object)eCrossReferenceAdapter);
        domain.getCommandStack().execute((Command)compoundCommand);
    }
}

