/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader;

import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.sources.FilteredSourcePackage;
import org.eclipse.osgi.internal.loader.sources.PackageSource;
import org.eclipse.osgi.internal.loader.sources.SingleSourcePackage;

public class BundleLoaderSources {
    static SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    private final ConcurrentMap<String, PackageSource> pkgSources = new ConcurrentHashMap<String, PackageSource>();
    private final BundleLoader loader;

    public BundleLoaderSources(BundleLoader loader) {
        this.loader = loader;
    }

    PackageSource getPackageSource(String pkgName) {
        PackageSource pkgSource = (PackageSource)this.pkgSources.get(pkgName);
        if (pkgSource != null) {
            return pkgSource;
        }
        SingleSourcePackage newSource = new SingleSourcePackage(pkgName, this.loader);
        PackageSource existingSource = this.pkgSources.putIfAbsent(newSource.getId(), newSource);
        return existingSource != null ? existingSource : newSource;
    }

    boolean forceSourceCreation(ModuleCapability packageCapability) {
        Map<String, String> directives = packageCapability.getDirectives();
        return directives.get("exclude") != null || directives.get("exclude") != null;
    }

    public PackageSource createPackageSource(ModuleCapability packageCapability, boolean storeSource) {
        PackageSource pkgSource = null;
        String name = (String)packageCapability.getAttributes().get("osgi.wiring.package");
        String includes = packageCapability.getDirectives().get("include");
        String excludes = packageCapability.getDirectives().get("exclude");
        if (includes != null || excludes != null) {
            pkgSource = new FilteredSourcePackage(name, this.loader, includes, excludes);
        }
        if (storeSource) {
            PackageSource existingSource;
            if (pkgSource != null && (existingSource = this.pkgSources.putIfAbsent(pkgSource.getId(), pkgSource)) != null) {
                pkgSource = existingSource;
            }
        } else if (pkgSource == null && (pkgSource = this.getPackageSource(name)).getClass() != SingleSourcePackage.class) {
            return new SingleSourcePackage(name, this.loader);
        }
        return pkgSource;
    }
}

