/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.wizards;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.oomph.internal.setup.SetupPrompter;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.core.util.CatalogManager;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.ui.ButtonBar;
import org.eclipse.oomph.ui.HelpSupport;
import org.eclipse.oomph.ui.OomphWizardDialog;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class SetupWizardPage
extends WizardPage
implements HelpSupport.HelpProvider {
    public SetupWizardPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public SetupWizard getWizard() {
        return (SetupWizard)super.getWizard();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = super.getDialogSettings();
        String sectionName = this.getName();
        return UIUtil.getOrCreateSection((IDialogSettings)settings, (String)sectionName);
    }

    public ComposedAdapterFactory getAdapterFactory() {
        return this.getWizard().getAdapterFactory();
    }

    public String getHelpPath() {
        String id = "Doc" + ((Object)((Object)this)).getClass().getSimpleName();
        return "/org.eclipse.oomph.setup.doc/html/user/wizard/" + id + ".html#" + id + "_1_table";
    }

    public ResourceSet getResourceSet() {
        return this.getWizard().getResourceSet();
    }

    public CatalogManager getCatalogManager() {
        return this.getWizard().getCatalogManager();
    }

    public Trigger getTrigger() {
        return this.getWizard().getTrigger();
    }

    public String getTriggerName() {
        return this.getWizard().getTriggerName();
    }

    public Installation getInstallation() {
        return this.getWizard().getInstallation();
    }

    public Workspace getWorkspace() {
        return this.getWizard().getWorkspace();
    }

    public User getUser() {
        return this.getWizard().getUser();
    }

    public SetupTaskPerformer getPerformer() {
        return this.getWizard().getPerformer();
    }

    public void setPerformer(SetupTaskPerformer performer) {
        this.getWizard().setPerformer(performer);
    }

    protected final SetupTaskPerformer createPerformer(SetupPrompter prompter, boolean fullPrompt) throws Exception {
        User originalUser = this.getUser();
        Installation originalInstallation = this.getInstallation();
        Workspace originalWorkspace = this.getWorkspace();
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        User user = (User)copier.copy((EObject)originalUser);
        Installation installation = (Installation)copier.copy((EObject)originalInstallation);
        Workspace workspace = (Workspace)copier.copy((EObject)originalWorkspace);
        copier.copyReferences();
        this.createResource((EObject)originalUser, (EObject)user);
        this.createResource((EObject)originalInstallation, (EObject)installation);
        this.createResource((EObject)originalWorkspace, (EObject)workspace);
        SetupContext context = SetupContext.create((Installation)installation, (Workspace)workspace, (User)user);
        URIConverter uriConverter = this.getResourceSet().getURIConverter();
        Trigger trigger = this.getTrigger();
        return SetupTaskPerformer.create((URIConverter)uriConverter, (SetupPrompter)prompter, (Trigger)trigger, (SetupContext)context, (boolean)fullPrompt);
    }

    private void createResource(EObject originalEObject, EObject copiedEObject) {
        if (originalEObject != null) {
            URI uri = originalEObject.eResource().getURI();
            Resource resource = SetupCoreUtil.RESOURCE_FACTORY_REGISTRY.getFactory(uri).createResource(uri);
            resource.getContents().add((Object)copiedEObject);
        }
    }

    public WizardFinisher getWizardFinisher() {
        return null;
    }

    public boolean performCancel() {
        return true;
    }

    public void sendStats(boolean success) {
    }

    protected void handleInactivity(Display display, boolean inactive) {
    }

    public void enterPage(boolean forward) {
    }

    public void leavePage(boolean forward) {
    }

    public final void gotoNextPage() {
        IWizardPage page = this.getNextPage();
        this.gotoPage("nextPressed", page);
    }

    public final void gotoPreviousPage() {
        IWizardPage page = this.getPreviousPage();
        this.gotoPage("backPressed", page);
    }

    private void gotoPage(String methodName, IWizardPage page) {
        IWizardContainer container = this.getContainer();
        if (container instanceof WizardDialog) {
            try {
                ReflectUtil.invokeMethod((String)methodName, (Object)container);
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        container.showPage(page);
    }

    public final void createControl(Composite parent) {
        GridLayout gridLayout = UIUtil.createGridLayout((int)1);
        gridLayout.marginWidth = 5;
        Composite pageControl = new Composite(parent, 0);
        pageControl.setLayout((Layout)gridLayout);
        super.setControl((Control)pageControl);
        this.setPageComplete(false);
        Composite uiContainer = new Composite(pageControl, 0);
        uiContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        uiContainer.setLayout((Layout)UIUtil.createGridLayout((int)1));
        Point sizeHint = this.getSizeHint();
        GridData layoutData = new GridData(1808);
        layoutData.widthHint = sizeHint.x;
        layoutData.heightHint = sizeHint.y;
        Control ui = this.createUI(uiContainer);
        ui.setLayoutData((Object)layoutData);
        ButtonBar buttonBar = new ButtonBar(pageControl){

            protected IDialogSettings getDialogSettings() {
                return SetupWizardPage.this.getDialogSettings();
            }
        };
        this.createCheckButtons(buttonBar);
        this.createFooter(pageControl);
        parent.layout(true, true);
    }

    protected void createFooter(Composite parent) {
    }

    protected void createCheckButtons(ButtonBar buttonBar) {
    }

    protected final void setControl(Control newControl) {
        throw new UnsupportedOperationException();
    }

    protected Point getSizeHint() {
        return new Point(800, 500);
    }

    protected abstract Control createUI(Composite var1);

    protected final void addHelpCallout(Control control, int number) {
        IWizardContainer container = this.getContainer();
        if (container instanceof OomphWizardDialog) {
            OomphWizardDialog dialog = (OomphWizardDialog)container;
            dialog.getHelpSupport().addHelpCallout(control, number);
        }
    }

    protected void setButtonState(int buttonID, boolean enabled) {
        Button button = this.getButton(buttonID);
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    protected Button getButton(int buttonID) {
        try {
            IWizardContainer container = this.getContainer();
            Method method = ReflectUtil.getMethod(container.getClass(), (String)"getButton", (Class[])new Class[]{Integer.TYPE});
            method.setAccessible(true);
            Button button = (Button)method.invoke((Object)container, buttonID);
            return button;
        }
        catch (Throwable ex) {
            return null;
        }
    }

    protected abstract class PerformerCreationJob
    extends Job {
        private SetupTaskPerformer performer;
        private Throwable throwable;
        private long start;
        private long interval;
        private long delay;

        public PerformerCreationJob(String name) {
            super(name);
            this.delay = 5000L;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                try {
                    SetupTaskPerformer.setCreationMonitor((IProgressMonitor)monitor);
                    this.performer = this.createPerformer();
                }
                catch (Throwable throwable) {
                    this.throwable = throwable;
                    SetupTaskPerformer.setCreationMonitor(null);
                }
            }
            finally {
                SetupTaskPerformer.setCreationMonitor(null);
            }
            return Status.OK_STATUS;
        }

        protected abstract SetupTaskPerformer createPerformer() throws Exception;

        protected abstract Dialog createDialog();

        protected abstract void handleDialogResult(int var1);

        protected void heartBeat() {
        }

        public long getStart() {
            return this.start;
        }

        public long getDelay() {
            return this.delay;
        }

        public void setDelay(long delay) {
            this.interval = System.currentTimeMillis();
            this.delay = delay;
        }

        public SetupTaskPerformer getPerformer() {
            return this.performer;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public void create() {
            final Button button = SetupWizardPage.this.getButton(15);
            final String originalText = button.getText();
            final String[] animationText = new String[]{originalText};
            this.schedule();
            this.interval = this.start = System.currentTimeMillis();
            long nextAnimation = this.start + 500L;
            Shell shell = SetupWizardPage.this.getShell();
            final Display display = shell.getDisplay();
            while (this.getState() != 0) {
                if (!display.readAndDispatch()) {
                    display.sleep();
                }
                if (button.isDisposed()) {
                    return;
                }
                long now = System.currentTimeMillis();
                if (now > nextAnimation) {
                    nextAnimation = now + 500L;
                    animationText[0] = this.getNextAnimationText(originalText, animationText[0]);
                    button.setText(animationText[0]);
                    this.heartBeat();
                }
                if (now - this.interval > this.delay) {
                    final Dialog dialog = this.createDialog();
                    final AtomicBoolean closedAfterJobCompletion = new AtomicBoolean();
                    Runnable livenessChecker = new Runnable(){

                        public void run() {
                            if (PerformerCreationJob.this.getState() == 0) {
                                closedAfterJobCompletion.set(true);
                                dialog.close();
                            } else {
                                animationText[0] = PerformerCreationJob.this.getNextAnimationText(originalText, animationText[0]);
                                button.setText(animationText[0]);
                                PerformerCreationJob.this.heartBeat();
                                display.timerExec(1000, (Runnable)this);
                            }
                        }
                    };
                    display.asyncExec(livenessChecker);
                    int result = dialog.open();
                    if (!closedAfterJobCompletion.get()) {
                        this.handleDialogResult(result);
                    }
                }
                if (!shell.isDisposed()) continue;
                return;
            }
            button.setText(originalText);
        }

        private String getNextAnimationText(String originalText, String text) {
            if (text.length() > originalText.length() + 10) {
                return originalText;
            }
            return " " + text.substring(0, text.length() - 1) + " " + text.charAt(text.length() - 1);
        }

        protected Dialog createDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
            MessageDialog dialog = new MessageDialog(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex){

                protected int getShellStyle() {
                    return super.getShellStyle() | 0x10000000;
                }
            };
            return dialog;
        }
    }

    public static interface WizardFinisher {
        public boolean performFinish();
    }
}

