/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.statushandlers.StatusManager;

public class StatusUtil {
    protected static List<IStatus> flatten(IStatus aStatus) {
        ArrayList<IStatus> result = new ArrayList<IStatus>();
        if (aStatus.isMultiStatus()) {
            IStatus[] iStatusArray = aStatus.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus status = iStatusArray[n2];
                if (status.isMultiStatus()) {
                    Iterator<IStatus> childStatiiEnum = StatusUtil.flatten(status).iterator();
                    while (childStatiiEnum.hasNext()) {
                        result.add(childStatiiEnum.next());
                    }
                } else {
                    result.add(status);
                }
                ++n2;
            }
        } else {
            result.add(aStatus);
        }
        return result;
    }

    protected static IStatus newStatus(IStatus[] stati, String message, Throwable exception) {
        Assert.isTrue((message != null ? 1 : 0) != 0);
        Assert.isTrue((message.trim().length() != 0 ? 1 : 0) != 0);
        return new MultiStatus(WorkbenchPlugin.PI_WORKBENCH, 4, stati, message, exception);
    }

    public static IStatus newStatus(String pluginId, Throwable exception) {
        return StatusUtil.newStatus(pluginId, StatusUtil.getLocalizedMessage(exception), exception);
    }

    public static String getLocalizedMessage(Throwable exception) {
        String message = exception.getLocalizedMessage();
        if (message != null) {
            return message;
        }
        if (exception instanceof CoreException) {
            CoreException ce = (CoreException)exception;
            return ce.getStatus().getMessage();
        }
        return WorkbenchMessages.StatusUtil_errorOccurred;
    }

    public static IStatus newStatus(IStatus originalStatus, String newMessage) {
        return new Status(originalStatus.getSeverity(), originalStatus.getPlugin(), originalStatus.getCode(), newMessage, originalStatus.getException());
    }

    public static IStatus newStatus(String pluginId, String message, Throwable exception) {
        return new Status(4, pluginId, 0, message, exception);
    }

    public static IStatus newStatus(int severity, String message, Throwable exception) {
        String statusMessage = message;
        if (message == null || message.trim().isEmpty()) {
            statusMessage = exception.getMessage() == null ? exception.toString() : exception.getMessage();
        }
        return new Status(severity, WorkbenchPlugin.PI_WORKBENCH, severity, statusMessage, exception);
    }

    public static IStatus newStatus(List<IStatus> children, String message, Throwable exception) {
        ArrayList<IStatus> flatStatusCollection = new ArrayList<IStatus>();
        for (IStatus currentStatus : children) {
            Iterator<IStatus> childrenIter = StatusUtil.flatten(currentStatus).iterator();
            while (childrenIter.hasNext()) {
                flatStatusCollection.add(childrenIter.next());
            }
        }
        IStatus[] stati = new IStatus[flatStatusCollection.size()];
        flatStatusCollection.toArray(stati);
        return StatusUtil.newStatus(stati, message, exception);
    }

    public static void handleStatus(IStatus status, int hint, Shell shell) {
        StatusManager.getManager().handle(status, hint);
    }

    public static void handleStatus(Throwable e, int hint) {
        StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, e), hint);
    }

    public static void handleStatus(String message, Throwable e, int hint) {
        StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, message, e), hint);
    }

    public static void handleStatus(String message, Throwable e, int hint, Shell shell) {
        StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, message, e), hint);
    }

    public static void handleStatus(IStatus status, String message, int hint) {
        StatusManager.getManager().handle(StatusUtil.newStatus(status, message), hint);
    }

    public static void handleStatus(IStatus status, String message, int hint, Shell shell) {
        StatusManager.getManager().handle(StatusUtil.newStatus(status, message), hint);
    }

    public static void handleStatus(String message, int hint) {
        StatusUtil.handleStatus(message, null, hint);
    }

    public static void handleStatus(String message, int hint, Shell shell) {
        StatusUtil.handleStatus(message, null, hint);
    }
}

