/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.predicates.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.oomph.predicates.FilePredicate;
import org.eclipse.oomph.predicates.PredicatesPackage;
import org.eclipse.oomph.predicates.impl.PredicateImpl;

public class FilePredicateImpl
extends PredicateImpl
implements FilePredicate {
    protected static final String FILE_PATTERN_EDEFAULT = null;
    protected String filePattern = FILE_PATTERN_EDEFAULT;
    protected static final String CONTENT_PATTERN_EDEFAULT = null;
    protected String contentPattern = CONTENT_PATTERN_EDEFAULT;

    protected FilePredicateImpl() {
    }

    protected EClass eStaticClass() {
        return PredicatesPackage.Literals.FILE_PREDICATE;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public void setFilePattern(String newFilePattern) {
        String oldFilePattern = this.filePattern;
        this.filePattern = newFilePattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldFilePattern, (Object)this.filePattern));
        }
    }

    public String getContentPattern() {
        return this.contentPattern;
    }

    public void setContentPattern(String newContentPattern) {
        String oldContentPattern = this.contentPattern;
        this.contentPattern = newContentPattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldContentPattern, (Object)this.contentPattern));
        }
    }

    public boolean matches(IResource resource) {
        String filePattern = this.getFilePattern();
        if (filePattern != null) {
            StringBuilder pattern = new StringBuilder();
            int i = 0;
            int length = filePattern.length();
            while (i < length) {
                char character = filePattern.charAt(i);
                if (!Character.isJavaIdentifierPart(character)) {
                    if (character == '*') {
                        if (i + 1 < length && filePattern.charAt(i + 1) == '*') {
                            ++i;
                            pattern.append(".*");
                        } else {
                            pattern.append("[^/]*");
                        }
                    } else if (character == '?') {
                        pattern.append("[^/]");
                    } else {
                        pattern.append('\\');
                        pattern.append(character);
                    }
                } else {
                    pattern.append(character);
                }
                ++i;
            }
            try {
                final Pattern regex = Pattern.compile(pattern.toString());
                final CoreException matched = new CoreException(Status.OK_STATUS);
                final Pattern contentPattern = this.getContentPattern() == null ? null : Pattern.compile(this.getContentPattern());
                try {
                    resource.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            block16: {
                                String path = resource.getProjectRelativePath().toString();
                                if (regex.matcher(path).matches()) {
                                    if (contentPattern == null) {
                                        throw matched;
                                    }
                                    if (resource.getType() == 1) {
                                        IFile file = (IFile)resource;
                                        String charset = file.getCharset();
                                        InputStream inputStream = null;
                                        try {
                                            try {
                                                String contents;
                                                inputStream = file.getContents();
                                                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                                                byte[] input = new byte[bufferedInputStream.available()];
                                                bufferedInputStream.read(input);
                                                String string = contents = charset == null ? new String(input) : new String(input, charset);
                                                if (contentPattern.matcher(contents).find()) {
                                                    throw matched;
                                                }
                                            }
                                            catch (IOException iOException) {
                                                if (inputStream == null) break block16;
                                                try {
                                                    inputStream.close();
                                                }
                                                catch (IOException iOException2) {}
                                            }
                                        }
                                        finally {
                                            if (inputStream != null) {
                                                try {
                                                    inputStream.close();
                                                }
                                                catch (IOException iOException) {}
                                            }
                                        }
                                    }
                                }
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException ex) {
                    if (ex == matched) {
                        return true;
                    }
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return false;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getFilePattern();
            }
            case 2: {
                return this.getContentPattern();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setFilePattern((String)newValue);
                return;
            }
            case 2: {
                this.setContentPattern((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setFilePattern(FILE_PATTERN_EDEFAULT);
                return;
            }
            case 2: {
                this.setContentPattern(CONTENT_PATTERN_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return FILE_PATTERN_EDEFAULT == null ? this.filePattern != null : !FILE_PATTERN_EDEFAULT.equals(this.filePattern);
            }
            case 2: {
                return CONTENT_PATTERN_EDEFAULT == null ? this.contentPattern != null : !CONTENT_PATTERN_EDEFAULT.equals(this.contentPattern);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (filePattern: ");
        result.append(this.filePattern);
        result.append(", contentPattern: ");
        result.append(this.contentPattern);
        result.append(')');
        return result.toString();
    }
}

