/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.identity;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.AbstractObservableSet;
import org.eclipse.core.internal.databinding.identity.IdentitySet;

public class IdentityObservableSet<E>
extends AbstractObservableSet<E> {
    private Set<E> wrappedSet = new IdentitySet();
    private Object elementType;

    public IdentityObservableSet(Realm realm, Object elementType) {
        super(realm);
        this.elementType = elementType;
    }

    @Override
    protected Set<E> getWrappedSet() {
        return this.wrappedSet;
    }

    @Override
    public Object getElementType() {
        return this.elementType;
    }

    @Override
    public Iterator<E> iterator() {
        this.getterCalled();
        final Iterator<E> wrappedIterator = this.wrappedSet.iterator();
        return new Iterator<E>(){
            E last;

            @Override
            public boolean hasNext() {
                IdentityObservableSet.this.getterCalled();
                return wrappedIterator.hasNext();
            }

            @Override
            public E next() {
                IdentityObservableSet.this.getterCalled();
                this.last = wrappedIterator.next();
                return this.last;
            }

            @Override
            public void remove() {
                IdentityObservableSet.this.getterCalled();
                wrappedIterator.remove();
                Set emptySet = Collections.emptySet();
                IdentityObservableSet.this.fireSetChange(Diffs.createSetDiff(emptySet, Collections.singleton(this.last)));
            }
        };
    }

    @Override
    public boolean add(E o) {
        this.getterCalled();
        boolean changed = this.wrappedSet.add(o);
        if (changed) {
            Set emptySet = Collections.emptySet();
            this.fireSetChange(Diffs.createSetDiff(Collections.singleton(o), emptySet));
        }
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed;
        this.getterCalled();
        IdentitySet<E> additions = new IdentitySet<E>();
        for (E element : c) {
            if (!this.wrappedSet.add(element)) continue;
            additions.add(element);
        }
        boolean bl = changed = !additions.isEmpty();
        if (changed) {
            Set emptySet = Collections.emptySet();
            this.fireSetChange(Diffs.createSetDiff(additions, emptySet));
        }
        return changed;
    }

    @Override
    public boolean remove(Object o) {
        this.getterCalled();
        boolean changed = this.wrappedSet.remove(o);
        if (changed) {
            Set additions = Collections.emptySet();
            this.fireSetChange(Diffs.createSetDiff(additions, Collections.singleton(o)));
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed;
        this.getterCalled();
        IdentitySet removals = new IdentitySet();
        for (Object element : c) {
            if (!this.wrappedSet.remove(element)) continue;
            removals.add(element);
        }
        boolean bl = changed = !removals.isEmpty();
        if (changed) {
            Set additions = Collections.emptySet();
            this.fireSetChange(Diffs.createSetDiff(additions, removals));
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed;
        this.getterCalled();
        IdentitySet<E> removals = new IdentitySet<E>();
        Object[] toRetains = c.toArray();
        Iterator<E> iterator = this.wrappedSet.iterator();
        block0: while (iterator.hasNext()) {
            E element = iterator.next();
            Object[] objectArray = toRetains;
            int n = toRetains.length;
            int n2 = 0;
            while (n2 < n) {
                Object toRetain = objectArray[n2];
                if (element == toRetain) continue block0;
                ++n2;
            }
            iterator.remove();
            removals.add(element);
        }
        boolean bl = changed = !removals.isEmpty();
        if (changed) {
            Set additions = Collections.emptySet();
            this.fireSetChange(Diffs.createSetDiff(additions, removals));
        }
        return changed;
    }

    @Override
    public void clear() {
        this.getterCalled();
        if (!this.wrappedSet.isEmpty()) {
            Set<E> removals = this.wrappedSet;
            this.wrappedSet = new IdentitySet();
            Set additions = Collections.emptySet();
            this.fireSetChange(Diffs.createSetDiff(additions, removals));
        }
    }
}

