/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.pde.impl;

import java.io.File;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.log.ProgressLog;
import org.eclipse.oomph.setup.log.ProgressLogMonitor;
import org.eclipse.oomph.setup.pde.APIBaselineTask;
import org.eclipse.oomph.setup.pde.PDEPackage;
import org.eclipse.oomph.setup.pde.impl.AbstractAPIBaselineTaskImpl;
import org.eclipse.oomph.setup.pde.impl.Messages;
import org.eclipse.oomph.setup.util.DownloadUtil;
import org.eclipse.oomph.setup.util.FileUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.ZIPUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.model.ApiModelFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiBaselineManager;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;

public class APIBaselineTaskImpl
extends AbstractAPIBaselineTaskImpl
implements APIBaselineTask {
    protected static final String VERSION_EDEFAULT = null;
    protected String version = VERSION_EDEFAULT;
    protected static final String LOCATION_EDEFAULT = "";
    protected String location = "";
    protected static final String REMOTE_URI_EDEFAULT = null;
    protected String remoteURI = REMOTE_URI_EDEFAULT;
    private transient File remoteURIFile;
    private transient String baselineName;
    private transient File baselineDir;
    private transient IApiBaseline baseline;
    protected transient boolean backupBaseline;
    protected transient boolean createBaseline;

    protected APIBaselineTaskImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PDEPackage.Literals.API_BASELINE_TASK;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldVersion, (Object)this.version));
        }
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String newLocation) {
        String oldLocation = this.location;
        this.location = newLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldLocation, (Object)this.location));
        }
    }

    @Override
    public String getRemoteURI() {
        return this.remoteURI;
    }

    @Override
    public void setRemoteURI(String newRemoteURI) {
        String oldRemoteURI = this.remoteURI;
        this.remoteURI = newRemoteURI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)oldRemoteURI, (Object)this.remoteURI));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 12: {
                return this.getVersion();
            }
            case 13: {
                return this.getLocation();
            }
            case 14: {
                return this.getRemoteURI();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 12: {
                this.setVersion((String)newValue);
                return;
            }
            case 13: {
                this.setLocation((String)newValue);
                return;
            }
            case 14: {
                this.setRemoteURI((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 12: {
                this.setVersion(VERSION_EDEFAULT);
                return;
            }
            case 13: {
                this.setLocation(LOCATION_EDEFAULT);
                return;
            }
            case 14: {
                this.setRemoteURI(REMOTE_URI_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 12: {
                return VERSION_EDEFAULT == null ? this.version != null : !VERSION_EDEFAULT.equals(this.version);
            }
            case 13: {
                return LOCATION_EDEFAULT == null ? this.location != null : !LOCATION_EDEFAULT.equals(this.location);
            }
            case 14: {
                return REMOTE_URI_EDEFAULT == null ? this.remoteURI != null : !REMOTE_URI_EDEFAULT.equals(this.remoteURI);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (version: ");
        result.append(this.version);
        result.append(", location: ");
        result.append(this.location);
        result.append(", remoteURI: ");
        result.append(this.remoteURI);
        result.append(')');
        return result.toString();
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        ApiPlugin apiPlugin = ApiPlugin.getDefault();
        if (apiPlugin == null) {
            return false;
        }
        this.baselineName = String.valueOf(this.getName()) + "-" + this.getVersion();
        this.baselineDir = new File(this.getLocation());
        this.remoteURIFile = new File(this.baselineDir, "remoteURI.txt");
        IApiBaselineManager baselineManager = apiPlugin.getApiBaselineManager();
        IApiBaseline baseline = baselineManager.getApiBaseline(this.baselineName);
        if (baseline == null) {
            return true;
        }
        baseline.getApiComponents();
        if (!this.baselineDir.isDirectory() || !new File(baseline.getLocation()).equals(this.baselineDir)) {
            baselineManager.removeApiBaseline(this.baselineName);
            baseline.setName(String.valueOf(this.baselineName) + " " + System.currentTimeMillis());
            baselineManager.addApiBaseline(baseline);
            return true;
        }
        this.baseline = baseline;
        return this.isActivate() && baselineManager.getDefaultApiBaseline() != baseline || this.isDifferentRemoteURI();
    }

    public void perform(SetupTaskContext context) throws Exception {
        IApiBaselineManager baselineManager = ApiPlugin.getDefault().getApiBaselineManager();
        if (this.baseline == null) {
            if (this.isDifferentRemoteURI()) {
                FileUtil.delete((File)this.baselineDir, (IProgressMonitor)new ProgressLogMonitor((ProgressLog)context));
            }
            if (!this.baselineDir.exists()) {
                this.downloadAndUnzip(context);
            }
            IOUtil.writeFile((File)this.remoteURIFile, (byte[])this.getRemoteURI().getBytes("UTF-8"));
            String location = this.baselineDir.toString();
            context.log(NLS.bind((String)Messages.APIBaselineTaskImpl_CreatingBaseline_message, (Object)location));
            this.baseline = ApiModelFactory.newApiBaseline((String)this.baselineName, (String)location);
            ApiModelFactory.addComponents((IApiBaseline)this.baseline, (String)location, (IProgressMonitor)new ProgressLogMonitor((ProgressLog)context));
            baselineManager.addApiBaseline(this.baseline);
        }
        if (this.isActivate()) {
            context.log(NLS.bind((String)Messages.APIBaselineTaskImpl_ActivatingBaseline_message, (Object)this.baselineName));
            baselineManager.setDefaultApiBaseline(this.baselineName);
        }
    }

    private boolean isDifferentRemoteURI() throws Exception {
        String zipLocationURL;
        return this.remoteURIFile.exists() && !ObjectUtil.equals((Object)(zipLocationURL = new String(IOUtil.readFile((File)this.remoteURIFile), "UTF-8")), (Object)this.getRemoteURI());
    }

    private void downloadAndUnzip(final SetupTaskContext context) throws Exception {
        File zipFile = DownloadUtil.downloadURL((String)this.getRemoteURI(), (ProgressLog)context);
        this.baselineDir.mkdirs();
        ZIPUtil.unzip((File)zipFile, (ZIPUtil.UnzipHandler)new ZIPUtil.FileSystemUnzipHandler(this.baselineDir, 4096){

            public void unzipFile(String name, InputStream zipStream) {
                context.log(NLS.bind((String)Messages.APIBaselineTaskImpl_Unzipping_message, (Object)name));
                super.unzipFile(name, zipStream);
            }
        });
    }
}

