/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.version;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.oomph.internal.version.Activator;
import org.eclipse.oomph.internal.version.DeprecationUtil;
import org.eclipse.oomph.internal.version.Element;
import org.eclipse.oomph.internal.version.Messages;
import org.eclipse.oomph.internal.version.ReleaseManager;
import org.eclipse.oomph.internal.version.VersionBuilderArguments;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.version.IElement;
import org.eclipse.oomph.version.IElementResolver;
import org.eclipse.oomph.version.IRelease;
import org.eclipse.oomph.version.IReleaseManager;
import org.eclipse.oomph.version.Markers;
import org.eclipse.oomph.version.VersionUtil;
import org.eclipse.oomph.version.VersionValidator;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class VersionBuilder
extends IncrementalProjectBuilder
implements IElementResolver {
    private static final Path DESCRIPTION_PATH = new Path(".project");
    private static final Path OPTIONS_PATH = new Path(".options");
    private static final Path MAVEN_POM_PATH = new Path("pom.xml");
    private static final Path MANIFEST_PATH = new Path("META-INF/MANIFEST.MF");
    private static final Path FEATURE_PATH = new Path("feature.xml");
    public static final String INTEGRATION_PROPERTY_KEY = "baseline.for.integration";
    public static final String SERVICE_PROPERTY_KEY = "provide.service";
    public static final String DEVIATIONS_PROPERTY_KEY = "show.deviations";
    public static final String ROOT_PROJECTS_KEY = "root.projects";
    public static final String IGNORED_REFERENCES_KEY = "ignored.references";
    private static final Pattern DEBUG_OPTION_PATTERN = Pattern.compile("^( *)([^/ \\n\\r]+)/([^ =]+)( *=.*)$", 8);
    private static final String AUTOMATIC_MODULE_NAME_HEADER = "Automatic-Module-Name";
    private static final Pattern AUTOMATIC_MODULE_NAME_PATTERN = Pattern.compile("Automatic-Module-Name:( *)(.*)");
    private static final Set<String> releasePaths = new HashSet<String>();
    private static final Map<IElement, IElement> elementCache = new HashMap<IElement, IElement>();
    private static final Map<IElement, Set<IElement>> elementReferences = new HashMap<IElement, Set<IElement>>();
    private static IResourceChangeListener postBuildListener;
    private static SAXParserFactory parserFactory;
    private IRelease release;
    private Boolean integration;
    private Boolean service;
    private Boolean deviations;
    private Set<String> rootProjects;
    private Set<String> ignoredReferences;
    private VersionBuilderArguments arguments;

    @Override
    public IElement resolveElement(IElement key) {
        try {
            this.ensureCacheExists();
            return elementCache.get(key);
        }
        catch (Exception ex) {
            Activator.log(ex);
            return null;
        }
    }

    public Set<IElement> resolveReferences(IElement key) {
        try {
            this.ensureCacheExists();
            return elementReferences.get(key);
        }
        catch (Exception ex) {
            Activator.log(ex);
            return null;
        }
    }

    private void ensureCacheExists() throws NoSuchAlgorithmException, CoreException, IOException {
        for (String path : Activator.getReleasePaths()) {
            if (!releasePaths.add(path)) continue;
            Map<IElement, IElement> elements = IReleaseManager.INSTANCE.createElements(path, false);
            elementCache.putAll(elements);
            for (IElement element : elements.keySet()) {
                IElement.Type type = element.getType();
                if (type != IElement.Type.FEATURE && type != IElement.Type.PRODUCT) continue;
                for (IElement child : element.getChildren()) {
                    Set<IElement> references = elementReferences.get(child);
                    if (references == null) {
                        references = new HashSet<IElement>();
                        elementReferences.put(child, references);
                    }
                    references.add(element);
                }
            }
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        monitor.beginTask("", 1);
        monitor.subTask(NLS.bind((String)Messages.VersionBuilder_Clean_task, (Object)project.getName()));
        try {
            Activator.clearBuildState(project);
            Markers.deleteAllMarkers((IResource)project, new String[0]);
        }
        finally {
            monitor.done();
        }
    }

    protected final IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        UniqueEList buildDependencies = new UniqueEList();
        this.build(kind, args, monitor, (List<IProject>)buildDependencies);
        return buildDependencies.toArray(new IProject[buildDependencies.size()]);
    }

    /*
     * Unable to fully structure code
     */
    private void build(int kind, Map<String, String> args, IProgressMonitor monitor, List<IProject> buildDependencies) throws CoreException {
        this.arguments = new VersionBuilderArguments((Map<? extends String, ? extends String>)args);
        validator = null;
        project = this.getProject();
        projectDescription = project.getFile((IPath)VersionBuilder.DESCRIPTION_PATH);
        if (VersionBuilder.postBuildListener == null) {
            VersionBuilder.postBuildListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    elementCache.clear();
                    elementReferences.clear();
                    releasePaths.clear();
                    VersionBuilder.this.arguments = null;
                }
            };
            project.getWorkspace().addResourceChangeListener(VersionBuilder.postBuildListener, 16);
            Activator.setPostBuildListener(VersionBuilder.postBuildListener);
        }
        buildState = Activator.getBuildState(project);
        releaseSpecDigest = buildState.getReleaseSpecDigest();
        oldVersionBuilderArguments = new VersionBuilderArguments((Map<? extends String, ? extends String>)buildState.getArguments());
        buildState.setArguments(this.arguments);
        delta = releaseSpecDigest == null || kind == 6 || kind == 15 || oldVersionBuilderArguments.equals(this.arguments) == false ? null : this.getDelta(project);
        monitor.beginTask("", 1);
        monitor.subTask(NLS.bind((String)Messages.VersionBuilder_Checking_task, (Object)project.getName()));
        try {
            releasePathArg = this.arguments.getReleasePath();
            if (releasePathArg == null) {
                msg = Messages.VersionBuilder_NoReleaseSpecFile_message;
                Markers.addMarker(projectDescription, msg, 2, "(org.eclipse.oomph.version.VersionBuilder)");
                return;
            }
            if (Activator.getReleaseCheckMode(releasePathArg) == Activator.ReleaseCheckMode.NONE) {
                return;
            }
            releasePath = new Path(releasePathArg);
            try {
                releaseSpecFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)releasePath);
                buildDependencies.add(releaseSpecFile.getProject());
                release = releaseSpecFile.exists() == false ? IReleaseManager.INSTANCE.createRelease(releaseSpecFile) : IReleaseManager.INSTANCE.getRelease(releaseSpecFile);
                digest = VersionUtil.getSHA1(releaseSpecFile);
                if (releaseSpecDigest == null || !MessageDigest.isEqual(digest, releaseSpecDigest)) {
                    buildState.setReleaseSpecDigest(digest);
                    delta = null;
                }
                this.release = release;
                Markers.deleteAllMarkers((IResource)projectDescription, new String[]{"release.path"});
            }
            catch (Exception ex) {
                Activator.log(ex, 2);
                msg = NLS.bind((String)Messages.VersionBuilder_ReleaseSpecProblem_message, (Object)releasePath, (Object)ex.getMessage());
                marker = Markers.addMarker(projectDescription, msg, 2, "(" + releasePath.toString().replace(".", "\\.") + ")");
                if (marker != null) {
                    marker.setAttribute("problemType", (Object)"release.path");
                }
                this.deviations = null;
                this.integration = null;
                this.service = null;
                this.release = null;
                monitor.done();
                return;
            }
            propertiesFile = VersionUtil.getFile((IPath)releasePath, "properties");
            propertiesTimeStamp = propertiesFile.getLocalTimeStamp();
            formerDeviations = buildState.isDeviations();
            deleteDeviationMarkers = false;
            if (buildState.getPropertiesTimeStamp() != propertiesTimeStamp) {
                if (this.initReleaseProperties(propertiesFile)) {
                    delta = null;
                }
                buildState.setDeviations(this.deviations);
                buildState.setIntegration(this.integration);
                buildState.setService(this.service);
                buildState.setRootProjects(this.rootProjects);
                buildState.setIgnoredReferences(this.ignoredReferences);
                buildState.setPropertiesTimeStamp(propertiesTimeStamp);
                if (formerDeviations && !this.deviations.booleanValue()) {
                    deleteDeviationMarkers = true;
                }
            } else {
                this.deviations = formerDeviations;
                this.integration = buildState.isIntegration();
                this.service = buildState.isService();
                this.rootProjects = buildState.getRootProjects();
                this.ignoredReferences = buildState.getIgnoredReferences();
            }
            for (IModel componentModel : VersionUtil.getComponentModels(project)) {
                componentModelFile = (IFile)componentModel.getUnderlyingResource();
                if (deleteDeviationMarkers) {
                    Markers.deleteAllMarkers((IResource)componentModelFile, new String[]{"deviation"});
                }
                componentModelPath = componentModelFile.getProjectRelativePath();
                v0 = checkComponentModel = delta == null || delta.findMember(componentModelPath) != null;
                if (!this.arguments.isIgnoreLaxLowerBoundDependencyVersions() && componentModel instanceof IPluginModelBase) {
                    this.addDependencies(buildDependencies, project);
                }
                element = IReleaseManager.INSTANCE.createElement(componentModel, true, false);
                elementType = element.getType();
                for (IElement child : element.getAllChildren(this, this.release)) {
                    childProject = this.getProject(child);
                    if (childProject == null) continue;
                    buildDependencies.add(childProject);
                    if (!checkComponentModel || (childProjectComponentModel = VersionUtil.getComponentModel(childProject)) == null) continue;
                    underlyingResource = childProjectComponentModel.getUnderlyingResource();
                    Markers.deleteAllMarkers(underlyingResource, new String[]{"unreferenced.element"});
                }
                if (elementType != IElement.Type.PRODUCT) {
                    Markers.deleteAllMarkers((IResource)componentModelFile, new String[]{"unreferenced.element"});
                    if (Activator.getReleaseCheckMode(releasePathArg) == Activator.ReleaseCheckMode.FULL && !this.rootProjects.contains(project.getName()) && ((elementReference = this.resolveReferences(element)) == null || elementReference.isEmpty())) {
                        this.addUnreferencedElementMarker(componentModelFile, element);
                    }
                }
                releaseElement = this.release.getElements().get(element.trimVersion());
                contentMustChange = false;
                if (elementType == IElement.Type.PLUGIN) {
                    if (!this.arguments.isIgnoreSchemaBuilder()) {
                        if (delta == null || delta.findMember((IPath)VersionBuilder.DESCRIPTION_PATH) != null) {
                            this.checkSchemaBuilder((IPluginModelBase)componentModel, projectDescription);
                        }
                    } else if (!oldVersionBuilderArguments.isIgnoreSchemaBuilder()) {
                        Markers.deleteAllMarkers((IResource)projectDescription, new String[]{"schema.builder"});
                    }
                    if (!this.arguments.isIgnoreDebugOptions()) {
                        if (delta == null || delta.findMember((IPath)VersionBuilder.OPTIONS_PATH) != null) {
                            this.checkDebugOptions((IPluginModelBase)componentModel);
                        }
                    } else if (!oldVersionBuilderArguments.isIgnoreDebugOptions()) {
                        Markers.deleteAllMarkers((IResource)project.getFile((IPath)VersionBuilder.OPTIONS_PATH), new String[]{"debug.option"});
                    }
                    if (!this.arguments.isIgnoreAutomaticModuleName()) {
                        if (delta == null || delta.findMember((IPath)VersionBuilder.MANIFEST_PATH) != null) {
                            this.checkAutomaticModuleName((IPluginModelBase)componentModel);
                        }
                    } else if (!oldVersionBuilderArguments.isIgnoreDebugOptions()) {
                        Markers.deleteAllMarkers((IResource)project.getFile((IPath)VersionBuilder.MANIFEST_PATH), new String[]{"debug.option"});
                    }
                    if (!this.arguments.isIgnoreMissingDependencyRanges()) {
                        if (checkComponentModel) {
                            this.checkDependencyRanges((IPluginModelBase)componentModel);
                        }
                    } else if (!oldVersionBuilderArguments.isIgnoreMissingDependencyRanges()) {
                        Markers.deleteAllMarkers((IResource)this.getProject().getFile((IPath)VersionBuilder.MANIFEST_PATH), new String[]{"lower.bound.version"});
                    }
                    laxLowerBoundCheckMode = Activator.getLaxLowerBoundCheckMode(releasePathArg);
                    if (!(this.arguments.isIgnoreLaxLowerBoundDependencyVersions() || releaseElement != null && releaseElement.getVersion().equals((Object)element.getVersion()) && laxLowerBoundCheckMode != Activator.LaxLowerBoundCheckMode.ALL)) {
                        contentMustChange = this.checkLowerBoundVersions((IPluginModelBase)componentModel, laxLowerBoundCheckMode) == false;
                    } else if (!oldVersionBuilderArguments.isIgnoreLaxLowerBoundDependencyVersions()) {
                        Markers.deleteAllMarkers((IResource)this.getProject().getFile((IPath)VersionBuilder.MANIFEST_PATH), new String[]{"lower.bound.version"});
                    }
                    if (!this.arguments.isIgnoreMissingExportVersions()) {
                        if (checkComponentModel) {
                            this.checkPackageExports((IPluginModelBase)componentModel);
                        }
                    } else if (!oldVersionBuilderArguments.isIgnoreMissingExportVersions()) {
                        Markers.deleteAllMarkers((IResource)this.getProject().getFile((IPath)VersionBuilder.MANIFEST_PATH), new String[]{"export.version"});
                    }
                    if (this.hasAPIToolsMarker((IPluginModelBase)componentModel)) {
                        continue;
                    }
                } else if (elementType == IElement.Type.FEATURE) {
                    if (!this.arguments.isIgnoreFeatureNature()) {
                        if (delta == null || delta.findMember((IPath)VersionBuilder.DESCRIPTION_PATH) != null) {
                            this.checkFeatureNature(projectDescription);
                        }
                    } else if (!oldVersionBuilderArguments.isIgnoreFeatureNature()) {
                        Markers.deleteAllMarkers((IResource)projectDescription, new String[]{"feature.nature"});
                    }
                }
                if (!this.arguments.isIgnoreMalformedVersions()) {
                    if (checkComponentModel && this.checkMalformedVersions(componentModel)) {
                        continue;
                    }
                } else if (!oldVersionBuilderArguments.isIgnoreMalformedVersions()) {
                    Markers.deleteAllMarkers((IResource)componentModelFile, new String[]{"malformed.version"});
                }
                if (this.arguments.isCheckMavenPom()) {
                    if (delta == null || delta.findMember((IPath)VersionBuilder.MAVEN_POM_PATH) != null || delta.findMember(componentModelPath) != null) {
                        this.checkMavenPom(element);
                    }
                } else if (oldVersionBuilderArguments.isCheckMavenPom()) {
                    Markers.deleteAllMarkers((IResource)project.getFile((IPath)VersionBuilder.MAVEN_POM_PATH), new String[]{"maven.pom"});
                }
                if (releaseElement == null) {
                    if (!VersionUtil.DEBUG) continue;
                    System.out.println(NLS.bind((String)Messages.VersionBuilder_UnresolveProject_message, (Object)project.getName()));
                    continue;
                }
                Markers.deleteAllMarkers((IResource)componentModelFile, new String[]{"version.nature"});
                if (!this.arguments.isIgnoreMissingVersionNature()) {
                    childProjectComponentModel = element.getChildren().iterator();
                    while (childProjectComponentModel.hasNext()) {
                        child = (IElement)childProjectComponentModel.next();
                        childComponentModel = ReleaseManager.INSTANCE.getComponentModel(child);
                        if (childComponentModel == null || (childComponentModelFile = childComponentModel.getUnderlyingResource()) == null || (childProject = childComponentModelFile.getProject()).hasNature("org.eclipse.oomph.version.VersionNature")) continue;
                        childType = child.getType();
                        name = child.getName();
                        label = childType.toString();
                        tag = childType.getTag();
                        msg = NLS.bind((String)Messages.VersionBuilder_MissingVersionBuilder_message, (Object)label, (Object)name);
                        marker = this.addFeatureChildMarker(componentModelFile, "version.nature", tag, name, msg, child.isLicenseFeature(), false, null, 2);
                        marker.setAttribute("quickFixNature", (Object)"org.eclipse.oomph.version.VersionNature");
                        marker.setAttribute("quickFixProject", (Object)childProject.getName());
                    }
                }
                elementVersion = element.getVersion();
                releaseVersion = releaseElement.getVersion();
                nextVersion = this.getNextVersion(releaseVersion);
                comparison = releaseVersion.compareTo(elementVersion);
                if (comparison != 0 && this.deviations.booleanValue() && checkComponentModel) {
                    this.addDeviationMarker(componentModelFile, element, releaseVersion);
                }
                Markers.deleteAllMarkers((IResource)componentModelFile, new String[]{"component.version", "feature.closure"});
                versionProperlyIncreased = false;
                if (comparison < 0) {
                    versionProperlyIncreased = nextVersion.equals((Object)elementVersion);
                    if (!versionProperlyIncreased) {
                        v1 = noOtherIncrements = elementVersion.getMajor() == nextVersion.getMajor() && elementVersion.getMinor() == nextVersion.getMinor();
                        if (noOtherIncrements) {
                            this.addVersionMarker(componentModelFile, NLS.bind((String)Messages.VersionBuilder_VersionShouldBe_message, (Object)nextVersion), nextVersion);
                        }
                    }
                    if (elementType == IElement.Type.PLUGIN) continue;
                }
                if (comparison > 0) {
                    this.addVersionMarker(componentModelFile, NLS.bind((String)Messages.VersionBuilder_VersionDecreased_message, (Object)releaseVersion), releaseVersion);
                    continue;
                }
                if (elementType == IElement.Type.FEATURE || elementType == IElement.Type.PRODUCT) {
                    if (!this.arguments.isIgnoreFeatureContentRedundancy()) {
                        this.checkFeatureRedundancy(componentModelFile, element);
                    }
                    if (this.arguments.isCheckFeatureClosureCompleteness()) {
                        this.checkFeatureClosureCompleteness(componentModelFile, element);
                    }
                    if (!this.arguments.isIgnoreFeatureContentChanges()) {
                        problems = new ArrayList<Problem>();
                        this.checkFeatureReferences(componentModelFile, element, problems);
                        if (!problems.isEmpty()) {
                            this.createMarkers(componentModelFile, problems, ComponentReferenceType.UNRESOLVED);
                            continue;
                        }
                        change = this.checkFeatureContentChanges(element, releaseElement, problems);
                        if (change != ComponentReferenceType.UNCHANGED) {
                            nextFeatureVersion = this.getNextFeatureVersion(releaseVersion, nextVersion, change);
                            if (elementVersion.compareTo(nextFeatureVersion) >= 0) continue;
                            marker = this.addVersionMarker(componentModelFile, NLS.bind((String)Messages.VersionBuilder_VersionMustBeIncreaseReferencesChanged_message, (Object)nextFeatureVersion, (Object)elementType.toString().toLowerCase()), nextFeatureVersion);
                            if (marker != null) {
                                marker.setAttribute("quickFixConfigureOption", (Object)"ignore.feature.content.changes");
                            }
                            this.createMarkers(componentModelFile, problems, change);
                            continue;
                        }
                        if (!elementVersion.equals((Object)releaseVersion)) continue;
                    }
                }
                if (versionProperlyIncreased || elementVersion.getMajor() > nextVersion.getMajor() || elementVersion.getMinor() > nextVersion.getMinor()) continue;
                if (contentMustChange) {
                    this.addVersionMarker(componentModelFile, NLS.bind((String)Messages.VersionBuilder_VersionMustBeIncreasedManifestMustChange_message, (Object)nextVersion), nextVersion);
                    continue;
                }
                if (validator != null) ** GOTO lbl252
                validatorClassName = this.arguments.getValidatorClassName();
                if (validatorClassName == null) {
                    validatorClassName = "org.eclipse.oomph.version.digest.DigestValidator$BuildModel";
                }
                try {
                    Markers.deleteAllMarkers((IResource)projectDescription, new String[]{"validator.class"});
                    c = Class.forName(validatorClassName, true, VersionBuilder.class.getClassLoader());
                    validator = (VersionValidator)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (VersionUtil.DEBUG) {
                        System.out.println(String.valueOf(validator.getClass().getName()) + ": " + project.getName());
                    }
                }
                catch (Exception ex) {
                    msg = String.valueOf(ex.getLocalizedMessage()) + ": " + validatorClassName;
                    marker = Markers.addMarker(projectDescription, msg, 2, ".*(" + validatorClassName + ").*");
                    if (marker != null) {
                        marker.setAttribute("problemType", (Object)"validator.class");
                    }
                    this.deviations = null;
                    this.integration = null;
                    this.service = null;
                    this.release = null;
                    monitor.done();
                    return;
                }
                try {
                    validatorVersion = validator.getVersion();
                    if (!VersionUtil.equals(validatorClassName, buildState.getValidatorClass()) || !VersionUtil.equals(validatorVersion, buildState.getValidatorVersion())) {
                        buildState.clearValidatorStates();
                        delta = null;
                    }
                    buildState.setValidatorClass(validatorClassName);
                    buildState.setValidatorVersion(validatorVersion);
lbl252:
                    // 2 sources

                    validator.updateBuildState(buildState, this.release, project, delta, componentModel, monitor);
                    if (!buildState.isChangedSinceRelease()) continue;
                    this.addVersionMarker(componentModelFile, NLS.bind((String)Messages.VersionBuilder_VersionMustBeIncreasedProjectContentsChanged_message, (Object)nextVersion), nextVersion);
                    continue;
                }
                catch (Exception ex) {
                    try {
                        if (validator != null) {
                            validator.abort(buildState, project, ex, monitor);
                        }
                        Activator.log(ex);
                    }
                    catch (Exception ignore) {
                        Activator.log(ignore);
                    }
                }
                break;
            }
        }
        finally {
            this.deviations = null;
            this.integration = null;
            this.service = null;
            this.release = null;
            monitor.done();
        }
    }

    private void addDependencies(List<IProject> buildDependencies, IProject project) {
        BundleDescription[] requiredBundles;
        BundleDescription bundleDescription;
        IModel childProjectComponentModel = VersionUtil.getComponentModel(project);
        if (childProjectComponentModel instanceof IPluginModelBase && (bundleDescription = ((IPluginModelBase)childProjectComponentModel).getBundleDescription()) != null && (requiredBundles = bundleDescription.getResolvedRequires()) != null) {
            BundleDescription[] bundleDescriptionArray = requiredBundles;
            int n = requiredBundles.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription requiredBundleDescription = bundleDescriptionArray[n2];
                Element element = new Element(IElement.Type.PLUGIN, requiredBundleDescription.getSymbolicName(), null, false);
                IProject childProject = this.getProject(element);
                if (childProject != null) {
                    buildDependencies.add(childProject);
                }
                ++n2;
            }
        }
    }

    private void createMarkers(IFile componentModelFile, List<Problem> problems, ComponentReferenceType change) {
        for (Problem problem : problems) {
            ComponentReferenceType componentReferenceType = problem.getComponentReferenceType();
            if (componentReferenceType.ordinal() < change.ordinal()) continue;
            this.addIncludeMarker(componentModelFile, problem.getElement(), problem.getSeverity(), problem.getVersion(), componentReferenceType);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasAPIToolsMarker(IPluginModelBase pluginModel) {
        try {
            IResource manifest = pluginModel.getUnderlyingResource();
            IMarker[] iMarkerArray = manifest.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IMarker marker = iMarkerArray[n2];
                if (marker.getType().startsWith("org.eclipse.pde.api.tools")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            Activator.log(ex);
        }
        return false;
    }

    private boolean initReleaseProperties(IFile propertiesFile) throws CoreException, IOException {
        if (propertiesFile.exists()) {
            boolean bl;
            InputStream contents = null;
            try {
                Boolean newServiceValue;
                boolean result = false;
                contents = propertiesFile.getContents();
                Properties properties = new Properties();
                properties.load(contents);
                this.deviations = Boolean.valueOf(properties.getProperty(DEVIATIONS_PROPERTY_KEY, "false"));
                this.rootProjects = new HashSet<String>();
                for (String rootProject : Arrays.asList(properties.getProperty(ROOT_PROJECTS_KEY, "").split(" "))) {
                    this.rootProjects.add(rootProject.replace("\\ ", " ").replace("\\\\", "\\"));
                }
                this.ignoredReferences = new HashSet<String>();
                for (String ignoredReference : Arrays.asList(properties.getProperty(IGNORED_REFERENCES_KEY, "").split(" "))) {
                    this.ignoredReferences.add(ignoredReference.replace("\\ ", " ").replace("\\\\", "\\"));
                }
                Boolean newIntegrationValue = Boolean.valueOf(properties.getProperty(INTEGRATION_PROPERTY_KEY, "true"));
                if (!newIntegrationValue.equals(this.integration)) {
                    this.integration = newIntegrationValue;
                    result = true;
                }
                if (!(newServiceValue = Boolean.valueOf(properties.getProperty(SERVICE_PROPERTY_KEY, "true"))).equals(this.service)) {
                    this.service = newServiceValue;
                    result = true;
                }
                bl = result;
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(contents);
                throw throwable;
            }
            IOUtil.closeSilent((Closeable)contents);
            return bl;
        }
        this.deviations = false;
        this.integration = true;
        this.service = true;
        this.rootProjects = new HashSet<String>();
        this.ignoredReferences = new HashSet<String>();
        String lineDelimiter = VersionUtil.getLineDelimiter(propertiesFile);
        String contents = "baseline.for.integration = " + this.integration + lineDelimiter + SERVICE_PROPERTY_KEY + " = " + this.service + lineDelimiter + DEVIATIONS_PROPERTY_KEY + " = " + this.deviations + lineDelimiter + ROOT_PROJECTS_KEY + " = ";
        String charsetName = propertiesFile.getCharset();
        byte[] bytes = contents.getBytes(charsetName);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        propertiesFile.create((InputStream)bais, true, (IProgressMonitor)new NullProgressMonitor());
        return true;
    }

    private Version getNextVersion(Version releaseVersion) {
        if (this.service.booleanValue()) {
            return new Version(releaseVersion.getMajor(), releaseVersion.getMinor(), releaseVersion.getMicro() + (this.integration != false ? 100 : 1));
        }
        return new Version(releaseVersion.getMajor(), releaseVersion.getMinor() + 1, 0);
    }

    private Version getNextFeatureVersion(Version releaseVersion, Version nextImplementationVersion, ComponentReferenceType change) {
        switch (change) {
            case MAJOR_CHANGED: 
            case REMOVED: {
                return new Version(releaseVersion.getMajor() + 1, 0, 0);
            }
            case MINOR_CHANGED: 
            case ADDED: 
            case FRAGMENT_REMOVED: {
                return new Version(releaseVersion.getMajor(), releaseVersion.getMinor() + 1, 0);
            }
            case MICRO_CHANGED: {
                return nextImplementationVersion;
            }
        }
        throw new IllegalArgumentException();
    }

    private void checkFeatureReferences(IFile file, IElement element, List<Problem> problems) {
        for (IElement child : element.getChildren()) {
            IElement resolvedChild;
            boolean hasSpecificVersion;
            boolean bl = hasSpecificVersion = !child.isVersionUnresolved();
            if (!hasSpecificVersion || (resolvedChild = this.resolveElement(child)) != null) continue;
            resolvedChild = this.resolveElement(child.trimVersion());
            Version resolvedChildVersion = resolvedChild == null ? null : resolvedChild.getVersion();
            this.addProblem(child, 2, ComponentReferenceType.UNRESOLVED, resolvedChildVersion, problems);
        }
    }

    private void checkFeatureRedundancy(IFile file, IElement element) {
        HashMap<IElement, IElement> allFeatureChildren = new HashMap<IElement, IElement>();
        List<IElement> children = element.getChildren();
        for (IElement child : children) {
            if (child.getType() != IElement.Type.FEATURE || (child = this.resolveElement(child)) == null) continue;
            Set<IElement> allChildren = child.getAllChildren(this, this.release);
            for (IElement featureChild : allChildren) {
                allFeatureChildren.put(featureChild, child);
            }
        }
        int i = 0;
        for (IElement child : children) {
            IElement featureElement = (IElement)allFeatureChildren.get(child);
            if (featureElement != null && !child.isLicenseFeature()) {
                try {
                    this.addRedundancyMarker(file, child, featureElement);
                }
                catch (Exception ex) {
                    Activator.log(ex);
                }
            }
            if (children.indexOf(child) != i) {
                this.addRedundancyMarker(file, child, null);
            }
            ++i;
        }
    }

    private void checkFeatureClosureCompleteness(IFile file, IElement element) {
        List<IElement> children = element.getChildren();
        HashSet<IElement> plugins = new HashSet<IElement>();
        HashMap<IElement, IElement> closure = new HashMap<IElement, IElement>();
        for (IElement iElement : children) {
            if (iElement.getType() == IElement.Type.FEATURE) {
                this.collectFeatureClosure(iElement, iElement, closure);
                continue;
            }
            plugins.add(iElement);
        }
        for (Map.Entry entry : closure.entrySet()) {
            IElement plugin = (IElement)entry.getKey();
            if (!plugins.add(plugin)) continue;
            try {
                IElement mainFeature = (IElement)entry.getValue();
                this.addFeatureClosureMarker(file, plugin, mainFeature);
            }
            catch (Exception ex) {
                Activator.log(ex);
            }
        }
    }

    private void collectFeatureClosure(IElement feature, IElement mainFeature, Map<IElement, IElement> closure) {
        if ((feature = this.resolveElement(feature)) != null) {
            for (IElement child : feature.getChildren()) {
                if (child.getType() == IElement.Type.PLUGIN) {
                    if (closure.containsKey(child)) continue;
                    closure.put(child, mainFeature);
                    continue;
                }
                this.collectFeatureClosure(child, mainFeature, closure);
            }
        }
    }

    private ComponentReferenceType checkFeatureContentChanges(IElement element, IElement releasedElement, List<Problem> problems) {
        ComponentReferenceType biggestChange = ComponentReferenceType.UNCHANGED;
        List<IElement> children = this.arguments.isCheckFeatureClosureContent() ? element.getAllChildren(this, this.release) : element.getChildren();
        for (IElement child : children) {
            ComponentReferenceType change = this.checkFeatureContentChanges(element, releasedElement, child, problems);
            biggestChange = ComponentReferenceType.values()[Math.max(biggestChange.ordinal(), change.ordinal())];
        }
        Set<IElement> allChildren = element.getAllChildren(this, this.release);
        List<IElement> releasedElementChildren = this.arguments.isCheckFeatureClosureContent() ? releasedElement.getAllChildren(this.release, this) : releasedElement.getChildren();
        for (IElement releasedElementsChild : releasedElementChildren) {
            ComponentReferenceType componentReferenceType;
            IElement trimmedVersion = releasedElementsChild.trimVersion();
            if (children.contains(trimmedVersion)) continue;
            ComponentReferenceType componentReferenceType2 = componentReferenceType = releasedElementsChild.isFragment() ? ComponentReferenceType.FRAGMENT_REMOVED : ComponentReferenceType.REMOVED;
            if (!this.addProblem(releasedElementsChild, 1, componentReferenceType, null, problems)) continue;
            biggestChange = ComponentReferenceType.values()[Math.max(biggestChange.ordinal(), allChildren.contains(trimmedVersion) ? ComponentReferenceType.MINOR_CHANGED.ordinal() : componentReferenceType.ordinal())];
        }
        return biggestChange;
    }

    private ComponentReferenceType checkFeatureContentChanges(IElement element, IElement releasedElement, IElement childElement, List<Problem> problems) {
        IElement releasedElementsChild = releasedElement.getChild(this.release, this, childElement);
        if (releasedElementsChild == null && (releasedElementsChild = releasedElement.getChild(this.release, this, childElement.trimVersion())) == null && this.addProblem(childElement, 1, ComponentReferenceType.ADDED, null, problems)) {
            return ComponentReferenceType.ADDED;
        }
        IElement childsReleasedElement = this.release.getElements().get(childElement);
        if (childsReleasedElement == null && (childsReleasedElement = this.release.getElements().get(childElement.trimVersion())) == null) {
            return ComponentReferenceType.UNCHANGED;
        }
        if (!childsReleasedElement.isVersionUnresolved()) {
            Version releasedVersion = childsReleasedElement.getVersion();
            Version version = childElement.trimVersion().getResolvedVersion();
            if (!version.equals((Object)Version.emptyVersion)) {
                if (version.getMajor() != releasedVersion.getMajor() && this.addProblem(childsReleasedElement, 1, ComponentReferenceType.MAJOR_CHANGED, version, problems)) {
                    return ComponentReferenceType.MAJOR_CHANGED;
                }
                if (version.getMinor() != releasedVersion.getMinor() && this.addProblem(childsReleasedElement, 1, ComponentReferenceType.MINOR_CHANGED, version, problems)) {
                    return ComponentReferenceType.MINOR_CHANGED;
                }
                if (version.getMicro() != releasedVersion.getMicro() && this.addProblem(childsReleasedElement, 1, ComponentReferenceType.MICRO_CHANGED, version, problems)) {
                    return ComponentReferenceType.MICRO_CHANGED;
                }
            }
        }
        return ComponentReferenceType.UNCHANGED;
    }

    private SAXParser getParser() throws ParserConfigurationException, SAXException {
        if (parserFactory == null) {
            parserFactory = SAXParserFactory.newInstance();
        }
        return parserFactory.newSAXParser();
    }

    private void checkMavenPom(IElement element) throws CoreException {
        final IFile file = this.getProject().getFile((IPath)MAVEN_POM_PATH);
        if (file.isAccessible()) {
            Markers.deleteAllMarkers((IResource)file, "maven.pom");
            final String componentName = element.getID() == null ? element.getName() : element.getID();
            final String componentVersion = StringUtil.removeSuffix((String)element.getVersion().toString(), (String[])new String[]{".qualifier"});
            final String componentType = element.getType().toString().toLowerCase();
            InputStream contents = null;
            try {
                try {
                    contents = file.getContents();
                    SAXParser parser = this.getParser();
                    parser.parse((InputStream)new BufferedInputStream(contents), new DefaultHandler(){
                        private Locator locator;
                        private int level;
                        private int lineNumber;
                        private int found;
                        private StringBuilder builder;

                        @Override
                        public void setDocumentLocator(Locator locator) {
                            this.locator = locator;
                        }

                        @Override
                        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                            if (++this.level == 2 && ("artifactId".equals(qName) || "version".equals(qName))) {
                                this.lineNumber = this.locator.getLineNumber();
                                this.builder = new StringBuilder();
                            }
                        }

                        @Override
                        public void characters(char[] ch, int start, int length) throws SAXException {
                            if (this.builder != null) {
                                this.builder.append(ch, start, length);
                            }
                        }

                        @Override
                        public void endElement(String uri, String localName, String qName) throws SAXException {
                            --this.level;
                            if (this.builder != null) {
                                String textContent = this.builder.toString().replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').trim();
                                if ("artifactId".equals(qName)) {
                                    if (!textContent.equals(componentName)) {
                                        this.addMarker(file, NLS.bind((String)Messages.VersionBuilder_MavenBadArtifactID_message, (Object[])new Object[]{textContent, componentType, componentName}), textContent, componentName);
                                    }
                                } else {
                                    String version = StringUtil.removeSuffix((String)textContent, (String[])new String[]{"-SNAPSHOT"});
                                    if (!version.equals(componentVersion)) {
                                        this.addMarker(file, NLS.bind((String)Messages.VersionBuilder_MavenBadVersion_message, (Object[])new Object[]{version, componentType, componentVersion}), version, componentVersion);
                                    }
                                }
                                if (++this.found == 2) {
                                    throw new SAXException("STOP-EARLY");
                                }
                            }
                            this.builder = null;
                        }

                        private void addMarker(IFile file2, String message, String pomValue, String componentValue) {
                            StringBuilder regexBuilder = new StringBuilder();
                            int i = 1;
                            while (i < this.lineNumber) {
                                regexBuilder.append('$');
                                ++i;
                            }
                            regexBuilder.append(".*(" + pomValue.replace(".", "\\.") + ")");
                            String regex = regexBuilder.toString();
                            try {
                                IMarker marker = Markers.addMarker(file2, message, 2, regex);
                                if (marker != null) {
                                    marker.setAttribute("problemType", (Object)"maven.pom");
                                    marker.setAttribute("quickFixPattern", (Object)regex);
                                    marker.setAttribute("quickFixReplacement", (Object)componentValue);
                                    marker.setAttribute("quickFixConfigureOption", (Object)"check.maven.pom");
                                    marker.setAttribute("quickFixConfigureValue", (Object)"false");
                                }
                            }
                            catch (Exception ex) {
                                Activator.log(ex);
                            }
                        }
                    });
                }
                catch (SAXException ex) {
                    if (!"STOP-EARLY".equals(ex.getMessage())) {
                        Activator.log(ex);
                    }
                    IOUtil.closeSilent((Closeable)contents);
                }
                catch (Exception ex) {
                    Activator.log(ex);
                    IOUtil.closeSilent((Closeable)contents);
                }
            }
            finally {
                IOUtil.closeSilent((Closeable)contents);
            }
        }
    }

    private boolean addProblem(IElement element, int severity, ComponentReferenceType componentReferenceType, Version version, List<Problem> problems) {
        String elementName = element.getName();
        if (!this.ignoredReferences.contains(elementName)) {
            problems.add(new Problem(element, severity, componentReferenceType, version));
            return true;
        }
        return false;
    }

    private IProject getProject(IElement element) {
        String name = element.getName();
        if (element.getType() == IElement.Type.PLUGIN) {
            return this.getPluginProject(name);
        }
        return this.getFeatureProject(name);
    }

    private IProject getPluginProject(String name) {
        IResource resource;
        IPluginModelBase pluginModel = PluginRegistry.findModel((String)name);
        if (pluginModel != null && (resource = pluginModel.getUnderlyingResource()) != null) {
            return resource.getProject();
        }
        return null;
    }

    private IProject getFeatureProject(String name) {
        IFeatureModel[] featureModels;
        IFeatureModel[] iFeatureModelArray = featureModels = PDECore.getDefault().getFeatureModelManager().getWorkspaceModels();
        int n = featureModels.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel featureModel = iFeatureModelArray[n2];
            IResource resource = featureModel.getUnderlyingResource();
            if (resource != null && name.equals(featureModel.getFeature().getId())) {
                return resource.getProject();
            }
            ++n2;
        }
        return null;
    }

    private boolean checkMalformedVersions(IModel componentModel) throws CoreException {
        IResource underlyingResource = componentModel.getUnderlyingResource();
        if (underlyingResource != null) {
            Markers.deleteAllMarkers(underlyingResource, "malformed.version");
            IProject project = underlyingResource.getProject();
            if (project.isAccessible()) {
                IFile file = null;
                String regex = null;
                IElement.Type type = VersionUtil.getType(componentModel);
                if (type == IElement.Type.PLUGIN) {
                    file = project.getFile((IPath)MANIFEST_PATH);
                    regex = "Bundle-Version: *(\\d+(\\.\\d+(\\.\\d+(\\.[-_a-zA-Z0-9]+)?)?)?)";
                } else if (type == IElement.Type.FEATURE) {
                    file = project.getFile((IPath)FEATURE_PATH);
                    regex = "feature.*?version\\s*=\\s*[\"'](\\d+(\\.\\d+(\\.\\d+(\\.[-_a-zA-Z0-9]+)?)?)?)";
                } else if (type == IElement.Type.PRODUCT) {
                    file = (IFile)underlyingResource;
                    regex = "product.*?version\\s*=\\s*[\"'](\\d+(\\.\\d+(\\.\\d+(\\.[-_a-zA-Z0-9]+)?)?)?)";
                }
                if (file.exists()) {
                    try {
                        String content = VersionUtil.getContents(file);
                        Pattern pattern = Pattern.compile(regex, 40);
                        Matcher matcher = pattern.matcher(content);
                        if (matcher.find()) {
                            String version = matcher.group(1);
                            if (matcher.groupCount() < 4 || !".qualifier".equals(matcher.group(4))) {
                                Version expectedVersion = new Version(version);
                                this.addMalformedVersionMarker(file, regex, new Version(expectedVersion.getMajor(), expectedVersion.getMinor(), expectedVersion.getMicro(), "qualifier"));
                                return true;
                            }
                        }
                    }
                    catch (Exception ex) {
                        Activator.log(ex);
                    }
                }
            }
        }
        return false;
    }

    private void checkDependencyRanges(IPluginModelBase pluginModel) throws CoreException, IOException {
        Version minVersion;
        int n;
        boolean missing;
        VersionRange expectedVersionRange;
        VersionRange range;
        BundleDescription description = pluginModel.getBundleDescription();
        if (description == null) {
            return;
        }
        IFile file = this.getProject().getFile((IPath)MANIFEST_PATH);
        Markers.deleteAllMarkers((IResource)file, "dependency.range");
        BundleSpecification[] bundleSpecificationArray = description.getRequiredBundles();
        int n2 = bundleSpecificationArray.length;
        int n3 = 0;
        while (n3 < n2) {
            BundleSpecification requiredBundle = bundleSpecificationArray[n3];
            range = requiredBundle.getVersionRange();
            if (this.isUnspecified(this.getMaximum(range))) {
                expectedVersionRange = null;
                if (VersionRange.emptyRange.equals((Object)range)) {
                    missing = true;
                    String name = requiredBundle.getName();
                    BundleDescription[] bundleDescriptionArray = description.getResolvedRequires();
                    int n4 = bundleDescriptionArray.length;
                    n = 0;
                    while (n < n4) {
                        BundleDescription bundleDescription = bundleDescriptionArray[n];
                        if (name.equals(bundleDescription.getSymbolicName())) {
                            expectedVersionRange = this.createVersionRange(bundleDescription.getVersion());
                            break;
                        }
                        ++n;
                    }
                } else {
                    missing = false;
                    minVersion = range.getMinimum();
                    Version maxVersion = new Version(minVersion.getMajor() + 1, 0, 0);
                    expectedVersionRange = new VersionRange(minVersion, range.getIncludeMinimum(), maxVersion, false);
                }
                this.addRequireMarker(file, requiredBundle.getName(), Messages.VersionBuilder_VersionRangeRequired_message, missing, expectedVersionRange);
            } else {
                if (!range.getIncludeMinimum()) {
                    expectedVersionRange = new VersionRange(range.getMinimum(), true, this.getMaximum(range), false);
                    this.addRequireMarker(file, requiredBundle.getName(), Messages.VersionBuilder_DependencyRangeMustIncludeMinimum_message, false, expectedVersionRange);
                }
                if (range.getIncludeMaximum()) {
                    expectedVersionRange = new VersionRange(range.getMinimum(), true, this.getMaximum(range), false);
                    this.addRequireMarker(file, requiredBundle.getName(), Messages.VersionBuilder_DependencyRangeMustNotIncludeMaximum_message, false, expectedVersionRange);
                }
            }
            ++n3;
        }
        bundleSpecificationArray = description.getImportPackages();
        n2 = bundleSpecificationArray.length;
        n3 = 0;
        while (n3 < n2) {
            block21: {
                BundleSpecification importPackage = bundleSpecificationArray[n3];
                range = importPackage.getVersionRange();
                if (this.isUnspecified(this.getMaximum(range))) {
                    expectedVersionRange = null;
                    if (VersionRange.emptyRange.equals((Object)range)) {
                        ExportPackageDescription[] exportPackageDescriptionArray = description.getResolvedImports();
                        n = exportPackageDescriptionArray.length;
                        int maxVersion = 0;
                        while (maxVersion < n) {
                            ExportPackageDescription exportPackageDescription = exportPackageDescriptionArray[maxVersion];
                            if (exportPackageDescription.getName().equals(importPackage.getName())) {
                                Version version = exportPackageDescription.getVersion();
                                if (!Version.emptyVersion.equals((Object)version)) {
                                    expectedVersionRange = this.createVersionRange(version);
                                    break;
                                }
                                break block21;
                            }
                            ++maxVersion;
                        }
                        missing = true;
                    } else {
                        missing = false;
                        minVersion = range.getMinimum();
                        Version maxVersion = new Version(minVersion.getMajor() + 1, 0, 0);
                        expectedVersionRange = new VersionRange(minVersion, range.getIncludeMinimum(), maxVersion, false);
                    }
                    this.addImportMarker(file, importPackage.getName(), Messages.VersionBuilder_VersionRangeRequired_message, missing, expectedVersionRange);
                } else {
                    if (!range.getIncludeMinimum()) {
                        expectedVersionRange = new VersionRange(range.getMinimum(), true, this.getMaximum(range), false);
                        this.addImportMarker(file, importPackage.getName(), Messages.VersionBuilder_DependencyRangeMustIncludeMinimum_message, false, expectedVersionRange);
                    }
                    if (range.getIncludeMaximum()) {
                        expectedVersionRange = new VersionRange(range.getMinimum(), true, this.getMaximum(range), false);
                        this.addImportMarker(file, importPackage.getName(), Messages.VersionBuilder_DependencyRangeMustNotIncludeMaximum_message, false, expectedVersionRange);
                    }
                }
            }
            ++n3;
        }
    }

    private boolean checkLowerBoundVersions(IPluginModelBase pluginModel, Activator.LaxLowerBoundCheckMode laxLowerBoundCheckMode) throws CoreException, IOException {
        boolean result = true;
        BundleDescription description = pluginModel.getBundleDescription();
        if (description != null) {
            IFile file = this.getProject().getFile((IPath)MANIFEST_PATH);
            Markers.deleteAllMarkers((IResource)file, "lower.bound.version");
            String releasePath = this.arguments.getReleasePath();
            BundleSpecification[] bundleSpecificationArray = description.getRequiredBundles();
            int n = bundleSpecificationArray.length;
            int n2 = 0;
            while (n2 < n) {
                BundleSpecification requiredBundle = bundleSpecificationArray[n2];
                if (!this.checkLowerBoundVersions(file, releasePath, (VersionConstraint)requiredBundle, "bundle-version", laxLowerBoundCheckMode)) {
                    result = false;
                }
                ++n2;
            }
            bundleSpecificationArray = description.getImportPackages();
            n = bundleSpecificationArray.length;
            n2 = 0;
            while (n2 < n) {
                BundleSpecification importPackage = bundleSpecificationArray[n2];
                if (!this.checkLowerBoundVersions(file, releasePath, (VersionConstraint)importPackage, "version", laxLowerBoundCheckMode)) {
                    result = false;
                }
                ++n2;
            }
        }
        return result;
    }

    private boolean checkLowerBoundVersions(IFile file, String releasePath, VersionConstraint versionConstraint, String versionAttribute, Activator.LaxLowerBoundCheckMode laxLowerBoundCheckMode) {
        BaseDescription supplier;
        VersionRange requiredVersionRange = versionConstraint.getVersionRange();
        if (!VersionRange.emptyRange.equals((Object)requiredVersionRange) && (supplier = versionConstraint.getSupplier()) != null) {
            BundleDescription supplierBundle;
            Version version = supplier.getVersion();
            version = new Version(version.getMajor(), version.getMinor(), 0);
            Version minimumRequiredVersion = requiredVersionRange.getMinimum();
            if (!minimumRequiredVersion.equals((Object)version) && (supplierBundle = supplier.getSupplier()) != null) {
                IElement element = this.resolveElement(new Element(IElement.Type.PLUGIN, supplierBundle.getName(), null, supplierBundle.getHost() != null));
                if (element != null) {
                    IProject project;
                    VersionBuilderArguments versionBuilderArguments;
                    String elementReleasePath;
                    IResource underlyingResource;
                    IModel componentModel = ReleaseManager.INSTANCE.getComponentModel(element.trimVersion());
                    if (componentModel != null && (underlyingResource = componentModel.getUnderlyingResource()) != null && underlyingResource.isAccessible() && (releasePath.equals(elementReleasePath = (versionBuilderArguments = new VersionBuilderArguments(project = underlyingResource.getProject())).getReleasePath()) || laxLowerBoundCheckMode == Activator.LaxLowerBoundCheckMode.ANY_RELEASE && elementReleasePath != null || laxLowerBoundCheckMode == Activator.LaxLowerBoundCheckMode.ALL)) {
                        String name = versionConstraint.getName();
                        VersionRange expectedVersionRange = new VersionRange(version, true, this.getMaximum(requiredVersionRange), requiredVersionRange.getIncludeMaximum());
                        this.addLaxLowerBoundMarker(file, name, NLS.bind((String)Messages.VersionBuilder_DependencyRangeMin_message, (Object)version), expectedVersionRange, versionAttribute);
                        return false;
                    }
                } else if (laxLowerBoundCheckMode == Activator.LaxLowerBoundCheckMode.ALL) {
                    String name = versionConstraint.getName();
                    VersionRange expectedVersionRange = new VersionRange(version, true, this.getMaximum(requiredVersionRange), requiredVersionRange.getIncludeMaximum());
                    this.addLaxLowerBoundMarker(file, name, NLS.bind((String)Messages.VersionBuilder_DependencyRangeMin_message, (Object)version), expectedVersionRange, versionAttribute);
                    return false;
                }
            }
        }
        return true;
    }

    private Version getMaximum(VersionRange range) {
        DeprecationUtil.someDeprecatedCode();
        return range.getMaximum();
    }

    private boolean isUnspecified(Version version) {
        if (version.getMajor() != Integer.MAX_VALUE) {
            return false;
        }
        if (version.getMinor() != Integer.MAX_VALUE) {
            return false;
        }
        return version.getMicro() == Integer.MAX_VALUE;
    }

    private void checkPackageExports(IPluginModelBase pluginModel) throws CoreException, IOException {
        IFile file = this.getProject().getFile((IPath)MANIFEST_PATH);
        Markers.deleteAllMarkers((IResource)file, "export.version");
        BundleDescription description = pluginModel.getBundleDescription();
        Version bundleVersion = VersionUtil.normalize(description.getVersion());
        HashSet paths = new HashSet();
        HashSet prefixes = new HashSet();
        this.getProject().accept(it -> {
            IPath javaPackageFolder;
            IPath path;
            if (it instanceof IFile && "java".equals((path = it.getProjectRelativePath()).getFileExtension()) && paths.add(javaPackageFolder = path.removeLastSegments(1))) {
                prefixes.add(javaPackageFolder.toString().replace('/', '.'));
            }
            return true;
        });
        ExportPackageDescription[] exportPackageDescriptionArray = description.getExportPackages();
        int n = exportPackageDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Version packageVersion;
            ExportPackageDescription packageExport = exportPackageDescriptionArray[n2];
            String packageName = packageExport.getName();
            String suffix = String.valueOf('.') + packageName;
            boolean isBundlePackage = prefixes.stream().anyMatch(it -> it.endsWith(suffix));
            if (isBundlePackage && !(packageVersion = packageExport.getVersion()).equals((Object)bundleVersion)) {
                this.addExportMarker(file, packageName, packageVersion, bundleVersion);
            }
            ++n2;
        }
    }

    private void checkFeatureNature(IFile file) throws CoreException, IOException {
        IProject project = file.getProject();
        Markers.deleteAllMarkers((IResource)project, "feature.nature");
        IProjectDescription description = project.getDescription();
        ICommand[] iCommandArray = description.getBuildSpec();
        int n = iCommandArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if ("org.eclipse.pde.FeatureBuilder".equals(command.getBuilderName()) && project.hasNature("org.eclipse.pde.FeatureNature")) {
                return;
            }
            ++n2;
        }
        String regex = "<buildSpec\\s*>()";
        String msg = Messages.VersionBuilder_FeatureBuilderMissing_message;
        IMarker marker = Markers.addMarker(file, msg, 1, regex);
        marker.setAttribute("problemType", (Object)"feature.nature");
        marker.setAttribute("quickFixNature", (Object)"org.eclipse.pde.FeatureNature");
        marker.setAttribute("quickFixConfigureOption", (Object)"ignore.feature.nature");
    }

    private void checkSchemaBuilder(IPluginModelBase pluginModel, IFile file) throws CoreException, IOException {
        IPluginExtensionPoint[] extensionPoints;
        Markers.deleteAllMarkers((IResource)file, "schema.builder");
        IProjectDescription description = this.getProject().getDescription();
        IPluginBase pluginBase = pluginModel.getPluginBase();
        if (pluginBase != null && (extensionPoints = pluginBase.getExtensionPoints()) != null & extensionPoints.length != 0) {
            ICommand[] iCommandArray = description.getBuildSpec();
            int n = iCommandArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICommand command = iCommandArray[n2];
                if ("org.eclipse.pde.SchemaBuilder".equals(command.getBuilderName())) {
                    return;
                }
                ++n2;
            }
            String regex = "<buildCommand\\s*>\\s*<name>\\s*org.eclipse.pde.ManifestBuilder\\s*</name>.*?</buildCommand>(\\s*)";
            String msg = Messages.VersionBuilder_SchemaBuilderMissing_message;
            IMarker marker = Markers.addMarker(file, msg, 1, regex);
            marker.setAttribute("problemType", (Object)"schema.builder");
            marker.setAttribute("quickFixPattern", (Object)regex);
            String lineDelimiter = VersionUtil.getLineDelimiter(file);
            marker.setAttribute("quickFixReplacement", (Object)(String.valueOf(lineDelimiter) + "\t\t<buildCommand>" + lineDelimiter + "\t\t\t<name>org.eclipse.pde.SchemaBuilder</name>" + lineDelimiter + "\t\t\t<arguments>" + lineDelimiter + "\t\t\t</arguments>" + lineDelimiter + "\t\t</buildCommand>" + lineDelimiter + "\t\t"));
            marker.setAttribute("quickFixConfigureOption", (Object)"ignore.schema.builder");
            return;
        }
        ICommand[] iCommandArray = description.getBuildSpec();
        int n = iCommandArray.length;
        int n3 = 0;
        while (n3 < n) {
            ICommand command = iCommandArray[n3];
            if ("org.eclipse.pde.SchemaBuilder".equals(command.getBuilderName())) {
                String regex = "(<buildCommand\\s*>\\s*<name>\\s*org.eclipse.pde.SchemaBuilder\\s*</name>.*?</buildCommand>)\\s*";
                String msg = Messages.VersionBuilder_NoSchemaBuilderNeed_message;
                IMarker marker = Markers.addMarker(file, msg, 1, regex);
                marker.setAttribute("problemType", (Object)"schema.builder");
                marker.setAttribute("quickFixPattern", (Object)regex);
                marker.setAttribute("quickFixConfigureOption", (Object)"ignore.schema.builder");
                break;
            }
            ++n3;
        }
    }

    private void checkDebugOptions(IPluginModelBase pluginModel) throws CoreException, IOException {
        IFile file = this.getProject().getFile((IPath)OPTIONS_PATH);
        if (file.isAccessible()) {
            Markers.deleteAllMarkers((IResource)file, "debug.option");
            String symbolicName = pluginModel.getBundleDescription().getSymbolicName();
            String content = VersionUtil.getContents(file);
            Matcher matcher = DEBUG_OPTION_PATTERN.matcher(content);
            while (matcher.find()) {
                String pluginID = matcher.group(2);
                if (symbolicName.equals(pluginID)) continue;
                String prefix = matcher.group(1);
                String suffix = "/" + (String.valueOf(matcher.group(3)) + matcher.group(4)).replace(".", "\\.");
                pluginID = pluginID.replace(".", "\\.");
                String regex = String.valueOf(prefix) + "(" + pluginID + ")" + suffix;
                String msg = NLS.bind((String)Messages.VersionBuilder_DebugOption_message, (Object)symbolicName, (Object)matcher.group(3));
                IMarker marker = Markers.addMarker(file, msg, 2, regex);
                marker.setAttribute("problemType", (Object)"debug.option");
                marker.setAttribute("quickFixPattern", (Object)regex);
                marker.setAttribute("quickFixReplacement", (Object)symbolicName);
                marker.setAttribute("quickFixConfigureOption", (Object)"ignore.debug.options");
            }
        }
    }

    private void checkAutomaticModuleName(IPluginModelBase pluginModel) throws CoreException, IOException {
        IFile file = this.getProject().getFile((IPath)MANIFEST_PATH);
        if (file.isAccessible()) {
            String symbolicName;
            String header;
            IBundle bundle;
            IBundleModel bundleModel;
            Markers.deleteAllMarkers((IResource)file, "automatic.module.name");
            if (pluginModel instanceof IBundlePluginModelBase && (bundleModel = ((IBundlePluginModelBase)pluginModel).getBundleModel()) != null && (bundle = bundleModel.getBundle()) != null && (header = bundle.getHeader(AUTOMATIC_MODULE_NAME_HEADER)) != null && !header.equals(symbolicName = pluginModel.getBundleDescription().getSymbolicName())) {
                String content = VersionUtil.getContents(file);
                Matcher matcher = AUTOMATIC_MODULE_NAME_PATTERN.matcher(content);
                while (matcher.find()) {
                    String moduleName = matcher.group(2);
                    if (symbolicName.equals(moduleName)) continue;
                    String whitespace = matcher.group(1);
                    moduleName = moduleName.replace(".", "\\.");
                    String regex = "Automatic-Module-Name:" + whitespace + "(" + moduleName + ")";
                    String msg = NLS.bind((String)Messages.VersionBuilder_AutomaticModule_message, (Object)symbolicName);
                    IMarker marker = Markers.addMarker(file, msg, 2, regex);
                    marker.setAttribute("problemType", (Object)"automatic.module.name");
                    marker.setAttribute("quickFixPattern", (Object)regex);
                    marker.setAttribute("quickFixReplacement", (Object)symbolicName);
                    marker.setAttribute("quickFixConfigureOption", (Object)"ignore.automatic.module.name");
                }
            }
        }
    }

    private void addRequireMarker(IFile file, String name, String message, boolean missing, VersionRange versionRange) {
        try {
            String regex = missing ? "^Require-Bundle: (?:\r?\n |[^\r\n])*" + name.replace(".", "\\.") + "()(;[^,]*?)?(,|$)" : String.valueOf(name.replace(".", "\\.")) + ";bundle-version=\"([^\\\"]*)\"";
            IMarker marker = Markers.addMarker(file, "'" + name + "' " + message, 2, regex);
            if (marker != null) {
                marker.setAttribute("problemType", (Object)"dependency.range");
                marker.setAttribute("quickFixConfigureOption", (Object)"ignore.missing.dependency.ranges");
                if (versionRange != null) {
                    marker.setAttribute("quickFixPattern", (Object)regex);
                    marker.setAttribute("quickFixReplacement", (Object)(missing ? ";bundle-version=\"" + versionRange.toString() + '\"' : versionRange.toString()));
                }
            }
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private VersionRange createVersionRange(Version version) {
        Version minVersion = new Version(version.getMajor(), version.getMinor(), 0);
        Version maxVersion = new Version(version.getMajor() + 1, 0, 0);
        VersionRange versionRange = new VersionRange(minVersion, true, maxVersion, false);
        return versionRange;
    }

    private void addLaxLowerBoundMarker(IFile file, String name, String message, VersionRange versionRange, String versionAttribute) {
        try {
            String regex = String.valueOf(name.replace(".", "\\.")) + ";" + versionAttribute + "=\"([^\\\"]*)\"";
            IMarker marker = Markers.addMarker(file, "'" + name + "' " + message, 2, regex);
            if (marker != null) {
                marker.setAttribute("problemType", (Object)"lower.bound.version");
                marker.setAttribute("quickFixPattern", (Object)regex);
                marker.setAttribute("quickFixReplacement", (Object)versionRange.toString());
                marker.setAttribute("quickFixConfigureOption", (Object)"ignore.lower.bound.dependency.ranges");
            }
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private void addImportMarker(IFile file, String name, String message, boolean missing, VersionRange versionRange) {
        try {
            String regex = missing ? "^Import-Package: (?:\r?\n |[^\r\n])*" + name.replace(".", "\\.") + "()(;[^,]*?)?(,|$)" : String.valueOf(name.replace(".", "\\.")) + ";version=\"([^\\\"]*)\"";
            IMarker marker = Markers.addMarker(file, "'" + name + "' " + message, 2, regex);
            if (marker != null) {
                marker.setAttribute("problemType", (Object)"dependency.range");
                marker.setAttribute("quickFixConfigureOption", (Object)"ignore.missing.dependency.ranges");
                if (versionRange != null) {
                    marker.setAttribute("quickFixPattern", (Object)regex);
                    marker.setAttribute("quickFixReplacement", (Object)(missing ? ";version=\"" + versionRange.toString() + '\"' : versionRange.toString()));
                }
            }
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private void addExportMarker(IFile file, String name, Version packageVersion, Version bundleVersion) {
        String versionString = bundleVersion.toString();
        try {
            String message = NLS.bind((String)Messages.VersionBuilder_PackageRequiresVersion_message, (Object)name, (Object)versionString);
            boolean exists = !packageVersion.equals((Object)Version.emptyVersion);
            String regex = !exists ? "(?:\nExport-Package: |\n )" + name.replace(".", "\\.") + "()[;,\r\n]" : String.valueOf(name.replace(".", "\\.")) + ";version=\"([0123456789\\.]*)\"";
            IMarker marker = Markers.addMarker(file, message, 2, regex);
            marker.setAttribute("problemType", (Object)"export.version");
            marker.setAttribute("quickFixPattern", (Object)regex);
            marker.setAttribute("quickFixReplacement", (Object)(exists ? versionString : ";version=\"" + bundleVersion + "\""));
            marker.setAttribute("quickFixConfigureOption", (Object)"ignore.missing.export.versions");
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private void addMalformedVersionMarker(IFile file, String regex, Version version) {
        try {
            String versionString = version.toString();
            IMarker marker = Markers.addMarker(file, NLS.bind((String)Messages.VersionBuilder_BadVersion_message, (Object)versionString), 2, regex);
            marker.setAttribute("problemType", (Object)"malformed.version");
            marker.setAttribute("quickFixPattern", (Object)regex);
            marker.setAttribute("quickFixReplacement", (Object)versionString);
            marker.setAttribute("quickFixConfigureOption", (Object)"ignore.malformed.versions");
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private IMarker addUnreferencedElementMarker(IFile file, IElement element) {
        try {
            String type = element.getType().toString();
            String message = NLS.bind((String)Messages.VersionBuilder_NotReferenceByFeature_message, (Object)type, (Object)element.getName());
            String regex = file.getFullPath().lastSegment().equals("MANIFEST.MF") ? "Bundle-SymbolicName: *([^;\n\r]*)" : "feature.*?id\\s*=\\s*[\"']([^\"']*)";
            IMarker marker = Markers.addMarker(file, message, 2, regex);
            if (marker != null) {
                marker.setAttribute("problemType", (Object)"unreferenced.element");
            }
            return marker;
        }
        catch (Exception ex) {
            Activator.log(ex);
            return null;
        }
    }

    private IMarker addDeviationMarker(IFile file, IElement element, Version releasedVersion) {
        try {
            String type = element.getType().toString();
            Version version = element.getVersion();
            String message = NLS.bind((String)Messages.VersionBuilder_HasBeenChanged_message, (Object[])new Object[]{type, element.getName(), releasedVersion, version});
            IMarker marker = this.addVersionMarker(file, message, version, 0);
            if (marker != null) {
                marker.setAttribute("problemType", (Object)"deviation");
            }
            return marker;
        }
        catch (Exception ex) {
            Activator.log(ex);
            return null;
        }
    }

    private IMarker addVersionMarker(IFile file, String message, Version version) {
        try {
            IMarker marker = this.addVersionMarker(file, message, version, 2);
            if (marker != null) {
                marker.setAttribute("problemType", (Object)"component.version");
            }
            return marker;
        }
        catch (Exception ex) {
            Activator.log(ex);
            return null;
        }
    }

    private IMarker addVersionMarker(IFile file, String message, Version version, int severity) {
        try {
            String regex = file.getFullPath().lastSegment().equals("MANIFEST.MF") ? "Bundle-Version: *(\\d+(\\.\\d+(\\.\\d+)?)?)" : (!file.getName().endsWith(".product") ? "feature.*?version\\s*=\\s*[\"'](\\d+(\\.\\d+(\\.\\d+)?)?)" : "product.*?version\\s*=\\s*[\"'](\\d+(\\.\\d+(\\.\\d+)?)?)");
            IMarker marker = Markers.addMarker(file, message, severity, regex);
            if (severity != 0) {
                marker.setAttribute("quickFixPattern", (Object)regex);
                marker.setAttribute("quickFixReplacement", (Object)version.toString());
            }
            return marker;
        }
        catch (Exception ex) {
            Activator.log(ex);
            return null;
        }
    }

    private void addRedundancyMarker(IFile file, IElement child, IElement feature) {
        try {
            String name = child.getName();
            IElement.Type type = child.getType();
            String cause = feature != null ? NLS.bind((String)Messages.VersionBuilder_AlredyIncluded_message, (Object)feature.getName()) : Messages.VersionBuilder_RedundantInclude_message;
            String msg = NLS.bind((String)Messages.VersionBuilder_RedundantReference_message, (Object[])new Object[]{type, name, cause});
            IMarker marker = this.addFeatureChildMarker(file, "component.version", type.getTag(), name, msg, false, true, null, 1);
            marker.setAttribute("quickFixConfigureOption", (Object)"ignore.feature.content.redundancy");
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private void addFeatureClosureMarker(IFile file, IElement pluginChild, IElement featureChild) {
        try {
            String pluginName = pluginChild.getName();
            String featureName = featureChild.getName();
            String msg = NLS.bind((String)Messages.VersionBuilder_MissingPlugin_message, (Object)pluginName, (Object)featureName);
            String lineDelimiter = VersionUtil.getLineDelimiter(file);
            IMarker marker = this.addFeatureChildMarker(file, "feature.closure", "includes", featureName, msg, false, true, null, 1);
            marker.setAttribute("quickFixPattern", (Object)("(([ \t]*)<includes(\\s*)id\\s*=\\s*\"" + featureName + "\")"));
            marker.setAttribute("quickFixReplacement", (Object)("\\2<plugin\\3id=\"" + pluginName + "\"\\3download-size=\"0\"\\3install-size=\"0\"\\3version=\"0.0.0\"\\3unpack=\"false\"/>" + lineDelimiter + lineDelimiter + "\\1"));
            marker.setAttribute("quickFixConfigureOption", (Object)"check.feature.closure.completeness");
            marker.setAttribute("quickFixConfigureValue", (Object)"false");
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private void addIncludeMarker(IFile file, IElement element, int severity, Version version, ComponentReferenceType componentReferenceType) {
        try {
            String tag;
            String label;
            if (element.getType() == IElement.Type.PLUGIN) {
                label = Messages.VersionBuilder_Plugin_label;
                tag = "plugin";
            } else if (file.getName().endsWith(".product")) {
                label = Messages.VersionBuilder_Feature_label;
                tag = "feature";
            } else {
                label = Messages.VersionBuilder_FeatureLabel;
                tag = "includes";
            }
            String name = element.getName();
            if (componentReferenceType == ComponentReferenceType.REMOVED || componentReferenceType == ComponentReferenceType.FRAGMENT_REMOVED) {
                String msg = NLS.bind((String)Messages.VersionBuilder_Remove_message, (Object)label, (Object)name);
                IMarker marker = Markers.addMarker((IResource)file, msg, severity);
                marker.setAttribute("problemType", (Object)"component.version");
                marker.setAttribute("quickFixReference", (Object)name);
            } else {
                String msg;
                Version replacementVersion = null;
                switch (componentReferenceType) {
                    case UNRESOLVED: {
                        if (version == null) {
                            msg = NLS.bind((String)Messages.VersionBuilder_Unresolved_message, (Object)label, (Object)name);
                            break;
                        }
                        msg = NLS.bind((String)Messages.VersionBuilder_ResolvesDifferently_message, (Object[])new Object[]{label, name, version});
                        replacementVersion = version;
                        break;
                    }
                    case ADDED: {
                        msg = NLS.bind((String)Messages.VersionBuilder_Added_message, (Object[])new Object[]{label, name, element.getResolvedVersion()});
                        break;
                    }
                    case MICRO_CHANGED: 
                    case MINOR_CHANGED: 
                    case MAJOR_CHANGED: {
                        msg = NLS.bind((String)Messages.VersionBuilder_Changed_message, (Object[])new Object[]{label, name, element.getVersion(), version});
                        break;
                    }
                    default: {
                        throw new IllegalStateException(Messages.VersionBuilder_Unreachable_message);
                    }
                }
                IMarker marker = this.addFeatureChildMarker(file, "component.version", tag, name, msg, element.isLicenseFeature(), componentReferenceType == ComponentReferenceType.ADDED, replacementVersion, severity);
                if (severity == 2) {
                    marker.setAttribute("quickFixConfigureOption", (Object)"ignore.feature.content.changes");
                } else {
                    marker.setAttribute("quickFixReference", (Object)name);
                }
            }
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private IMarker addFeatureChildMarker(IFile file, String problemType, String tag, String name, String msg, boolean isLicense, boolean hasQuickFix, Version version, int severity) throws CoreException, IOException {
        String regex = isLicense ? "\\s+.*?license-feature-version\\s*=\\s*[\"']([^\"']*)[\"']" : (version != null ? "[ \\t\\x0B\\f]*<" + tag + "\\s+[^<]*id\\s*=\\s*[\"']" + name.replace(".", "\\.") + "[\"'].*?version\\s*=\\s*[\"']([^\"']*)[\"'].*?/>([ \\t\\x0B\\f]*[\\n\\r])*" : "[ \\t\\x0B\\f]*<" + tag + "\\s+[^<]*id\\s*=\\s*[\"'](" + name.replace(".", "\\.") + ")[\"'].*?/>([ \\t\\x0B\\f]*[\\n\\r])*");
        IMarker marker = Markers.addMarker(file, msg, severity, regex);
        marker.setAttribute("problemType", (Object)problemType);
        if (version != null) {
            marker.setAttribute("quickFixPattern", (Object)regex);
            marker.setAttribute("quickFixReplacement", (Object)version.toString());
            marker.setAttribute("quickFixAlternativeReplacement", (Object)"0.0.0");
        } else if (hasQuickFix) {
            marker.setAttribute("quickFixPattern", (Object)regex);
        }
        return marker;
    }

    private static enum ComponentReferenceType {
        UNRESOLVED,
        UNCHANGED,
        MICRO_CHANGED,
        MINOR_CHANGED,
        ADDED,
        FRAGMENT_REMOVED,
        MAJOR_CHANGED,
        REMOVED;

    }

    private static class Problem {
        private IElement element;
        private int severity;
        private ComponentReferenceType componentReferenceType;
        private Version version;

        public Problem(IElement element, int severity, ComponentReferenceType componentReferenceType, Version version) {
            this.element = element;
            this.severity = severity;
            this.componentReferenceType = componentReferenceType;
            this.version = version;
        }

        public IElement getElement() {
            return this.element;
        }

        public int getSeverity() {
            return this.severity;
        }

        public ComponentReferenceType getComponentReferenceType() {
            return this.componentReferenceType;
        }

        public Version getVersion() {
            return this.version;
        }
    }
}

