/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.internal.core.P2CorePlugin;

public final class RootAnalyzer {
    private RootAnalyzer() {
    }

    public static Set<IInstallableUnit> getRootUnits(IQueryable<IInstallableUnit> queryable, IProgressMonitor monitor) {
        HashSet<IInstallableUnit> rootIUs = new HashSet<IInstallableUnit>();
        for (IInstallableUnit iu : P2Util.asIterable(queryable.query(QueryUtil.createIUAnyQuery(), null))) {
            P2CorePlugin.checkCancelation((IProgressMonitor)monitor);
            String id = iu.getId();
            if (id.endsWith(".source") || id.endsWith(".source.feature.group") || "true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.category")) || "true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.product"))) continue;
            rootIUs.add(iu);
        }
        RootAnalyzer.removeImplicitUnits(rootIUs, queryable, monitor, false);
        return rootIUs;
    }

    public static void removeImplicitUnits(Map<IMetadataRepository, Set<IInstallableUnit>> result, IProgressMonitor monitor, boolean onlyIfRedundant) {
        RootAnalyzer.removeImplicitUnits(result, monitor, onlyIfRedundant, true);
    }

    public static void removeImplicitUnits(Map<IMetadataRepository, Set<IInstallableUnit>> result, IProgressMonitor monitor, boolean onlyIfRedundant, boolean ignoreJavaRequirements) {
        for (Map.Entry<IMetadataRepository, Set<IInstallableUnit>> entry : result.entrySet()) {
            IMetadataRepository metadataRepository = entry.getKey();
            Set<IInstallableUnit> ius = entry.getValue();
            RootAnalyzer.removeImplicitUnits(ius, (IQueryable<IInstallableUnit>)metadataRepository, monitor, onlyIfRedundant, ignoreJavaRequirements);
        }
    }

    public static void removeImplicitUnits(Set<IInstallableUnit> ius, IQueryable<IInstallableUnit> queryable, IProgressMonitor monitor, boolean onlyIfRedundant) {
        RootAnalyzer.removeImplicitUnits(ius, queryable, monitor, onlyIfRedundant, true);
    }

    public static void removeImplicitUnits(Set<IInstallableUnit> ius, IQueryable<IInstallableUnit> queryable, IProgressMonitor monitor, boolean onlyIfRedundant, boolean ignoreJavaRequirements) {
        HashSet<IInstallableUnit> rootIUs = new HashSet<IInstallableUnit>(ius);
        HashSet<IInstallableUnit> currentlyVisitingIUs = new HashSet<IInstallableUnit>();
        HashSet<IInstallableUnit> visitedIUs = new HashSet<IInstallableUnit>();
        for (IInstallableUnit iu : ius) {
            RootAnalyzer.removeImplicitUnits(iu, rootIUs, currentlyVisitingIUs, visitedIUs, queryable, monitor, onlyIfRedundant, ignoreJavaRequirements);
        }
        if (rootIUs.size() < ius.size()) {
            ius.retainAll(rootIUs);
        }
    }

    private static void removeImplicitUnits(IInstallableUnit iu, Set<IInstallableUnit> rootIUs, Set<IInstallableUnit> currentlyVisitingIUs, Set<IInstallableUnit> visitedIUs, IQueryable<IInstallableUnit> queryable, IProgressMonitor monitor, boolean onlyIfRedundant, boolean ignoreJavaRequirements) {
        if (visitedIUs.add(iu)) {
            currentlyVisitingIUs.add(iu);
            for (IRequirement requirement : iu.getRequirements()) {
                if ((RootAnalyzer.isTypeRequirement(requirement) || ignoreJavaRequirements) && RootAnalyzer.isJavaPackageRequirment(requirement)) continue;
                for (IInstallableUnit requiredIU : P2Util.asIterable(queryable.query(QueryUtil.createMatchQuery((IExpression)requirement.getMatches(), (Object[])new Object[0]), null))) {
                    P2CorePlugin.checkCancelation((IProgressMonitor)monitor);
                    if (currentlyVisitingIUs.contains(requiredIU)) continue;
                    if (!onlyIfRedundant || RootAnalyzer.isExactRequirement(requirement)) {
                        rootIUs.remove(requiredIU);
                    }
                    RootAnalyzer.removeImplicitUnits(requiredIU, rootIUs, currentlyVisitingIUs, visitedIUs, queryable, monitor, onlyIfRedundant, ignoreJavaRequirements);
                }
            }
            currentlyVisitingIUs.remove(iu);
        }
    }

    private static boolean isExactRequirement(IRequirement requirement) {
        if (P2Util.isSimpleRequiredCapability(requirement)) {
            IRequiredCapability requiredCapability = (IRequiredCapability)requirement;
            VersionRange range = requiredCapability.getRange();
            return range.getMinimum().equals(range.getMaximum());
        }
        return false;
    }

    private static boolean isTypeRequirement(IRequirement requirement) {
        if (P2Util.isSimpleRequiredCapability(requirement)) {
            IRequiredCapability requiredCapability = (IRequiredCapability)requirement;
            String namespace = requiredCapability.getNamespace();
            return "org.eclipse.equinox.p2.eclipse.type".equals(namespace);
        }
        return false;
    }

    private static boolean isJavaPackageRequirment(IRequirement requirement) {
        if (P2Util.isSimpleRequiredCapability(requirement)) {
            IRequiredCapability requiredCapability = (IRequiredCapability)requirement;
            String namespace = requiredCapability.getNamespace();
            return "java.package".equals(namespace);
        }
        return false;
    }
}

