/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

public class ChooseWorkspaceData {
    private static final int RECENT_MAX_LENGTH = 10;
    private static final String PERS_FOLDER = "org.eclipse.ui.ide";
    private static final String PERS_FILENAME = "recentWorkspaces.xml";
    private static final int PERS_ENCODING_VERSION = 1;
    private static final int PERS_ENCODING_VERSION_CONFIG_PREFS = 2;
    private static final int PERS_ENCODING_VERSION_CONFIG_PREFS_NO_COMMAS = 3;
    private boolean showDialog = true;
    private boolean showRecentWorkspaces;
    private String initialDefault;
    private String selection;
    private String[] recentWorkspaces;

    public ChooseWorkspaceData(String initialDefault) {
        this.readPersistedData();
        this.setInitialDefault(initialDefault);
    }

    public ChooseWorkspaceData(URL instanceUrl) {
        this.readPersistedData();
        if (instanceUrl != null) {
            this.setInitialDefault(new File(instanceUrl.getFile()).toString());
        }
    }

    public String getInitialDefault() {
        if (this.initialDefault == null) {
            this.setInitialDefault(System.getProperty("user.dir") + File.separator + "workspace");
        }
        return this.initialDefault;
    }

    private void setInitialDefault(String dir) {
        if (dir == null || dir.length() <= 0) {
            this.initialDefault = null;
            return;
        }
        dir = IPath.fromOSString((String)dir).toOSString();
        while (dir.charAt(dir.length() - 1) == File.separatorChar) {
            dir = dir.substring(0, dir.length() - 1);
        }
        this.initialDefault = dir;
    }

    public String getSelection() {
        return this.selection;
    }

    public boolean getShowDialog() {
        return this.showDialog;
    }

    public boolean isShowRecentWorkspaces() {
        return this.showRecentWorkspaces;
    }

    public String[] getRecentWorkspaces() {
        return this.recentWorkspaces;
    }

    public void workspaceSelected(String dir) {
        this.selection = dir;
    }

    public void toggleShowDialog() {
        this.showDialog = !this.showDialog;
    }

    public void setShowRecentWorkspaces(boolean showRecentWorkspaces) {
        this.showRecentWorkspaces = showRecentWorkspaces;
    }

    public void setRecentWorkspaces(String[] workspaces) {
        this.recentWorkspaces = workspaces == null ? new String[0] : workspaces;
    }

    public void writePersistedData() {
        IEclipsePreferences node = ConfigurationScope.INSTANCE.getNode(PERS_FOLDER);
        node.putBoolean("SHOW_WORKSPACE_SELECTION_DIALOG", this.showDialog);
        node.putInt("MAX_RECENT_WORKSPACES", this.recentWorkspaces.length);
        if (this.selection != null) {
            File newFolder = new File(this.selection);
            String oldEntry = this.recentWorkspaces[0];
            this.recentWorkspaces[0] = this.selection;
            int i = 1;
            while (i < this.recentWorkspaces.length && oldEntry != null) {
                File oldFolder = new File(oldEntry);
                if (newFolder.compareTo(oldFolder) == 0) break;
                String tmp = this.recentWorkspaces[i];
                this.recentWorkspaces[i] = oldEntry;
                oldEntry = tmp;
                ++i;
            }
        }
        String encodedRecentWorkspaces = ChooseWorkspaceData.encodeStoredWorkspacePaths(this.recentWorkspaces);
        node.put("RECENT_WORKSPACES", encodedRecentWorkspaces);
        node.putInt("RECENT_WORKSPACES_PROTOCOL", 3);
        node.putBoolean("SHOW_RECENT_WORKSPACES", this.showRecentWorkspaces);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private boolean readPersistedData_file() {
        URL persUrl = null;
        Location configLoc = Platform.getConfigurationLocation();
        if (configLoc != null) {
            persUrl = ChooseWorkspaceData.getPersistenceUrl(configLoc.getURL(), false);
        }
        try {
            IMemento[] indices;
            XMLMemento memento;
            if (persUrl == null) {
                return false;
            }
            Throwable throwable = null;
            Object var5_5 = null;
            try (FileReader reader = new FileReader(persUrl.getFile());){
                memento = XMLMemento.createReadRoot((Reader)reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (memento == null || !ChooseWorkspaceData.compatibleFileProtocol((IMemento)memento)) {
                return false;
            }
            IMemento alwaysAskTag = memento.getChild("alwaysAsk");
            this.showDialog = alwaysAskTag == null ? true : alwaysAskTag.getInteger("showDialog") == 1;
            IMemento recent = memento.getChild("recentWorkspaces");
            if (recent == null) {
                return false;
            }
            Integer maxLength = recent.getInteger("maxLength");
            int max = 10;
            if (maxLength != null) {
                max = maxLength;
            }
            if ((indices = recent.getChildren("workspace")) == null || indices.length <= 0) {
                return false;
            }
            try {
                max = Math.max(max, indices.length);
                this.recentWorkspaces = new String[max];
                int i = 0;
                while (i < indices.length) {
                    String path = indices[i].getString("path");
                    if (path == null) {
                        break;
                    }
                    this.recentWorkspaces[i] = path;
                    ++i;
                }
            }
            catch (IOException | WorkbenchException throwable3) {
                return false;
            }
        }
        finally {
            if (this.recentWorkspaces == null) {
                this.recentWorkspaces = new String[10];
            }
        }
        return true;
    }

    public static boolean getShowDialogValue() {
        ChooseWorkspaceData data = new ChooseWorkspaceData("");
        return data.readPersistedData() ? data.showDialog : true;
    }

    public static void setShowDialogValue(boolean showDialog) {
        ChooseWorkspaceData data = new ChooseWorkspaceData("");
        data.showDialog = showDialog;
        data.writePersistedData();
    }

    public boolean readPersistedData() {
        ScopedPreferenceStore store = new ScopedPreferenceStore(ConfigurationScope.INSTANCE, PERS_FOLDER);
        int protocol = store.getInt("RECENT_WORKSPACES_PROTOCOL");
        if (protocol == 0 && this.readPersistedData_file()) {
            return true;
        }
        this.showDialog = store.getBoolean("SHOW_WORKSPACE_SELECTION_DIALOG");
        int max = store.getInt("MAX_RECENT_WORKSPACES");
        max = Math.max(max, 10);
        String workspacePathPref = store.getString("RECENT_WORKSPACES");
        this.recentWorkspaces = ChooseWorkspaceData.decodeStoredWorkspacePaths(protocol, max, workspacePathPref);
        this.showRecentWorkspaces = store.getBoolean("SHOW_RECENT_WORKSPACES");
        return true;
    }

    private static String encodeStoredWorkspacePaths(String[] recent) {
        StringBuilder buff = new StringBuilder();
        String path = null;
        String[] stringArray = recent;
        int n = recent.length;
        int n2 = 0;
        while (n2 < n) {
            String recentPath = stringArray[n2];
            if (recentPath == null) break;
            if (path != null) {
                buff.append("\n");
            }
            path = recentPath;
            buff.append(path);
            ++n2;
        }
        return buff.toString();
    }

    private static String[] decodeStoredWorkspacePaths(int protocol, int max, String prefValue) {
        String[] paths = new String[max];
        if (prefValue == null || prefValue.length() <= 0) {
            return paths;
        }
        String tokens = null;
        switch (protocol) {
            case 3: {
                tokens = "\n";
                break;
            }
            case 2: {
                tokens = ",";
            }
        }
        if (tokens == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(prefValue, tokens);
        int i = 0;
        while (i < paths.length && tokenizer.hasMoreTokens()) {
            paths[i] = tokenizer.nextToken();
            ++i;
        }
        return paths;
    }

    private static boolean compatibleFileProtocol(IMemento memento) {
        IMemento protocolMemento = memento.getChild("protocol");
        if (protocolMemento == null) {
            return false;
        }
        Integer version = protocolMemento.getInteger("version");
        return version != null && version == 1;
    }

    private static URL getPersistenceUrl(URL baseUrl, boolean create) {
        File persFile;
        block6: {
            File dir;
            URL url;
            block5: {
                if (baseUrl == null) {
                    return null;
                }
                try {
                    url = new URL(baseUrl, PERS_FOLDER);
                    dir = new File(url.getFile());
                    if (dir.exists() || create && dir.mkdir()) break block5;
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            url = new URL(dir.toURL(), PERS_FILENAME);
            persFile = new File(url.getFile());
            if (persFile.exists() || create && persFile.createNewFile()) break block6;
            return null;
        }
        return persFile.toURL();
    }

    private static interface XML {
        public static final String PROTOCOL = "protocol";
        public static final String VERSION = "version";
        public static final String ALWAYS_ASK = "alwaysAsk";
        public static final String SHOW_DIALOG = "showDialog";
        public static final String WORKSPACE = "workspace";
        public static final String RECENT_WORKSPACES = "recentWorkspaces";
        public static final String MAX_LENGTH = "maxLength";
        public static final String PATH = "path";
    }
}

