/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.DPIZoomChangeRegistry;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MENUBARINFO;
import org.eclipse.swt.internal.win32.MENUINFO;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    public long handle;
    int x;
    int y;
    long hBrush;
    int foreground = -1;
    int background = -1;
    Image backgroundImage;
    boolean hasLocation;
    MenuItem cascade;
    Decorations parent;
    MenuItem selectedMenuItem;
    static final int ID_TOOLTIP_TIMER = 110;

    static {
        DPIZoomChangeRegistry.registerHandler(Menu::handleDPIChange, Menu.class);
    }

    public Menu(Control parent) {
        this(Menu.checkNull(parent).menuShell(), 8);
    }

    public Menu(Decorations parent, int style) {
        this(parent, Menu.checkStyle(style), 0L);
    }

    public Menu(Menu parentMenu) {
        this(Menu.checkNull((Menu)parentMenu).parent, 4);
    }

    public Menu(MenuItem parentItem) {
        this(Menu.checkNull((MenuItem)parentItem).parent);
    }

    Menu(Decorations parent, int style, long handle) {
        super(parent, Menu.checkStyle(style));
        this.parent = parent;
        this.handle = handle;
        this.createWidget();
    }

    void _setVisible(boolean visible) {
        long hFocus;
        if ((this.style & 6) != 0) {
            return;
        }
        long hwndParent = this.parent.handle;
        if (visible) {
            int flags = 0;
            if (OS.GetKeyState(1) >= 0) {
                flags |= 2;
            }
            if ((this.style & 0x4000000) != 0) {
                flags |= 8;
            }
            if ((this.parent.style & 0x8000000) != 0) {
                flags &= 0xFFFFFFF7;
                if ((this.style & 0x2000000) != 0) {
                    flags |= 8;
                }
            }
            int nX = this.x;
            int nY = this.y;
            if (!this.hasLocation) {
                int pos = OS.GetMessagePos();
                nX = OS.GET_X_LPARAM(pos);
                nY = OS.GET_Y_LPARAM(pos);
            }
            this.hasLocation = false;
            Display display = this.display;
            display.sendPreExternalEventDispatchEvent();
            boolean success = OS.TrackPopupMenu(this.handle, flags, nX, nY, 0, hwndParent, null);
            display.sendPostExternalEventDispatchEvent();
            if (!success && OS.GetMenuItemCount(this.handle) == 0) {
                OS.SendMessage(hwndParent, 287, OS.MAKEWPARAM(0, 65535), 0L);
            }
        } else {
            OS.SendMessage(hwndParent, 31, 0L, 0L);
        }
        if ((hFocus = OS.GetFocus()) != 0L) {
            OS.NotifyWinEvent(32773, hFocus, -4, 0);
        }
    }

    public void addHelpListener(HelpListener listener) {
        this.addTypedListener(listener, 28);
    }

    public void addMenuListener(MenuListener listener) {
        this.addTypedListener(listener, 23, 22);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    static int checkStyle(int style) {
        return Menu.checkBits(style, 8, 2, 4, 0, 0, 0);
    }

    void createHandle() {
        if (this.handle != 0L) {
            return;
        }
        this.handle = (this.style & 2) != 0 ? OS.CreateMenu() : OS.CreatePopupMenu();
        if (this.handle == 0L) {
            this.error(2);
        }
        this.updateBackground();
    }

    void createItem(MenuItem item, int index) {
        int count = OS.GetMenuItemCount(this.handle);
        if (index < 0 || index > count) {
            this.error(6);
        }
        this.display.addMenuItem(item);
        long hHeap = OS.GetProcessHeap();
        long pszText = OS.HeapAlloc(hHeap, 8, 4);
        char[] cArray = new char[2];
        cArray[0] = 32;
        OS.MoveMemory(pszText, cArray, 4);
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 50;
        info.wID = item.id;
        info.dwItemData = item.id;
        info.fType = item.widgetStyle();
        info.dwTypeData = pszText;
        boolean success = OS.InsertMenuItem(this.handle, index, true, info);
        if (pszText != 0L) {
            OS.HeapFree(hHeap, 0, pszText);
        }
        if (!success) {
            this.display.removeMenuItem(item);
            this.error(14);
        }
        if (this.needsMenuCallback()) {
            info.fMask = 128;
            info.hbmpItem = -1L;
            OS.SetMenuItemInfo(this.handle, index, true, info);
        }
        this.redraw();
    }

    void createWidget() {
        this.checkOrientation(this.parent);
        this.initThemeColors();
        this.createHandle();
        this.parent.addMenu(this);
    }

    int defaultBackground() {
        return OS.GetSysColor(4);
    }

    int defaultForeground() {
        return OS.GetSysColor(7);
    }

    void destroyAccelerators() {
        this.parent.destroyAccelerators();
    }

    void destroyItem(MenuItem item) {
        if (!OS.DeleteMenu(this.handle, item.id, 0)) {
            this.error(15);
        }
        this.redraw();
    }

    @Override
    void destroyWidget() {
        MenuItem cascade = this.cascade;
        long hMenu = this.handle;
        this.releaseHandle();
        if (cascade != null) {
            cascade.setMenu(null, true);
        } else if (hMenu != 0L) {
            OS.DestroyMenu(hMenu);
        }
    }

    void fixMenus(Decorations newParent) {
        if (this.isDisposed()) {
            return;
        }
        MenuItem[] menuItemArray = this.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            item.fixMenus(newParent);
            ++n2;
        }
        this.parent.removeMenu(this);
        newParent.addMenu(this);
        this.parent = newParent;
        this.nativeZoom = newParent.nativeZoom;
    }

    Color getBackground() {
        this.checkWidget();
        return Color.win32_new(this.display, this.background != -1 ? this.background : this.defaultBackground());
    }

    Image getBackgroundImage() {
        this.checkWidget();
        return this.backgroundImage;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            if (this.parent.menuBar != this) {
                return new Rectangle(0, 0, 0, 0);
            }
            long hwndShell = this.parent.handle;
            MENUBARINFO info = new MENUBARINFO();
            info.cbSize = MENUBARINFO.sizeof;
            if (OS.GetMenuBarInfo(hwndShell, -3, 0, info)) {
                int width = info.right - info.left;
                int height = info.bottom - info.top;
                return new Rectangle(info.left, info.top, width, height);
            }
        } else {
            RECT rect2;
            RECT rect1;
            int count = OS.GetMenuItemCount(this.handle);
            if (count != 0 && OS.GetMenuItemRect(0L, this.handle, 0, rect1 = new RECT()) && OS.GetMenuItemRect(0L, this.handle, count - 1, rect2 = new RECT())) {
                int x = rect1.left - 2;
                int y = rect1.top - 2;
                int width = rect2.right - rect2.left + 4;
                int height = rect2.bottom - rect1.top + 4;
                return new Rectangle(x, y, width, height);
            }
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        int id = OS.GetMenuDefaultItem(this.handle, 0, 1);
        if (id == -1) {
            return null;
        }
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 2;
        if (OS.GetMenuItemInfo(this.handle, id, false, info)) {
            return this.display.getMenuItem(info.wID);
        }
        return null;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    Color getForeground() {
        this.checkWidget();
        return Color.win32_new(this.display, this.foreground != -1 ? this.foreground : this.defaultForeground());
    }

    public MenuItem getItem(int index) {
        this.checkWidget();
        int id = 0;
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 32;
        if (!OS.GetMenuItemInfo(this.handle, index, true, info)) {
            this.error(6);
        }
        id = (int)info.dwItemData;
        return this.display.getMenuItem(id);
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.GetMenuItemCount(this.handle);
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        int index = 0;
        int count = 0;
        int length = OS.GetMenuItemCount(this.handle);
        if (length < 0) {
            int error = OS.GetLastError();
            SWT.error(36, null, " [GetLastError=0x" + Integer.toHexString(error) + "]");
        }
        MenuItem[] items = new MenuItem[length];
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 32;
        while (OS.GetMenuItemInfo(this.handle, index, true, info)) {
            MenuItem item;
            if (count == items.length) {
                MenuItem[] newItems = new MenuItem[count + 4];
                System.arraycopy(items, 0, newItems, 0, count);
                items = newItems;
            }
            if ((item = this.display.getMenuItem((int)info.dwItemData)) != null) {
                items[count++] = item;
            }
            ++index;
        }
        if (count == items.length) {
            return items;
        }
        MenuItem[] result = new MenuItem[count];
        System.arraycopy(items, 0, result, 0, count);
        return result;
    }

    @Override
    String getNameText() {
        Object result = "";
        MenuItem[] items = this.getItems();
        int length = items.length;
        if (length > 0) {
            int i = 0;
            while (i <= length - 1) {
                result = (String)result + (items[i] == null ? "null" : items[i].getNameText()) + (i < length - 1 ? ", " : "");
                ++i;
            }
        }
        return result;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.parent;
        }
        return null;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return this == this.parent.menuShell().menuBar;
        }
        if ((this.style & 8) != 0) {
            Menu[] popups = this.display.popups;
            if (popups == null) {
                return false;
            }
            Menu[] menuArray = popups;
            int n = popups.length;
            int n2 = 0;
            while (n2 < n) {
                Menu popup = menuArray[n2];
                if (popup == this) {
                    return true;
                }
                ++n2;
            }
        }
        Shell shell = this.getShell();
        Menu menu = shell.activeMenu;
        while (menu != null && menu != this) {
            menu = menu.getParentMenu();
        }
        return this == menu;
    }

    void hideCurrentToolTip() {
        if (this.selectedMenuItem != null) {
            this.selectedMenuItem.hideToolTip();
        }
    }

    public int indexOf(MenuItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return -1;
        }
        int index = 0;
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 32;
        while (OS.GetMenuItemInfo(this.handle, index, true, info)) {
            if (info.dwItemData == (long)item.id) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    void initThemeColors() {
        if ((this.style & 2) != 0) {
            this.foreground = this.display.menuBarForegroundPixel;
            this.background = this.display.menuBarBackgroundPixel;
        }
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu parentMenu = this.getParentMenu();
        if (parentMenu == null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && parentMenu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    boolean needsMenuCallback() {
        if (this.background != -1 || this.backgroundImage != null) {
            return true;
        }
        return this.foreground != -1;
    }

    void redraw() {
        if (!this.isVisible()) {
            return;
        }
        if ((this.style & 2) != 0) {
            this.display.addBar(this);
        } else {
            this.update();
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0L;
        this.cascade = null;
    }

    @Override
    void releaseChildren(boolean destroy) {
        MenuItem[] menuItemArray = this.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++n2;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if ((this.style & 2) != 0) {
            this.display.removeBar(this);
            if (this == this.parent.menuBar) {
                this.parent.setMenuBar(null);
            }
        } else if ((this.style & 8) != 0) {
            this.display.removePopup(this);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.backgroundImage = null;
        if (this.hBrush != 0L) {
            OS.DeleteObject(this.hBrush);
        }
        this.hBrush = 0L;
        if (this.parent != null) {
            this.parent.removeMenu(this);
        }
        this.parent = null;
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, listener);
        this.eventTable.unhook(22, listener);
    }

    @Override
    void reskinChildren(int flags) {
        MenuItem[] menuItemArray = this.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            item.reskin(flags);
            ++n2;
        }
        super.reskinChildren(flags);
    }

    void setBackground(Color color) {
        this.checkWidget();
        int pixel = -1;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            pixel = color.handle;
        }
        if (pixel == this.background) {
            return;
        }
        this.background = pixel;
        this.updateBackground();
    }

    void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            if (image.type != 0) {
                this.error(5);
            }
        }
        if (this.backgroundImage == image) {
            return;
        }
        this.backgroundImage = image;
        this.updateBackground();
    }

    void setForeground(Color color) {
        this.checkWidget();
        int pixel = -1;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            pixel = color.handle;
        }
        if (pixel == this.foreground) {
            return;
        }
        this.foreground = pixel;
        this.updateForeground();
    }

    public void setDefaultItem(MenuItem item) {
        int oldID;
        this.checkWidget();
        int newID = -1;
        if (item != null) {
            if (item.isDisposed()) {
                this.error(5);
            }
            if (item.parent != this) {
                return;
            }
            newID = item.id;
        }
        if (newID == (oldID = OS.GetMenuDefaultItem(this.handle, 0, 1))) {
            return;
        }
        OS.SetMenuDefaultItem(this.handle, newID, 0);
        this.redraw();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.state &= 0xFFFFFFF7;
        if (!enabled) {
            this.state |= 8;
        }
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        int zoom = this.getZoom();
        this.setLocationInPixels(DPIUtil.scaleUp(x, zoom), DPIUtil.scaleUp(y, zoom));
    }

    void setLocationInPixels(int x, int y) {
        if ((this.style & 6) != 0) {
            return;
        }
        this.x = x;
        this.y = y;
        this.hasLocation = true;
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        location = DPIUtil.scaleUp(location, this.getZoom());
        this.setLocationInPixels(location.x, location.y);
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this._setOrientation(orientation);
    }

    void _setOrientation(int orientation) {
        int flags = 0x6000000;
        if ((orientation & flags) == 0 || (orientation & flags) == flags) {
            return;
        }
        this.style &= ~flags;
        this.style |= orientation & flags;
        this.style &= Integer.MAX_VALUE;
        MenuItem[] menuItemArray = this.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem itm = menuItemArray[n2];
            itm.setOrientation(orientation);
            ++n2;
        }
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (visible) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
            this._setVisible(false);
        }
    }

    void update() {
        if ((this.style & 2) != 0) {
            if (this == this.parent.menuBar) {
                OS.DrawMenuBar(this.parent.handle);
            }
            return;
        }
        boolean hasCheck = false;
        boolean hasImage = false;
        MenuItem[] menuItemArray = this.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (item.image != null) {
                hasImage = true;
                if (true && hasCheck) break;
            }
            if ((item.style & 0x30) != 0) {
                hasCheck = true;
                if (true && hasImage) break;
            }
            ++n2;
        }
        MENUINFO lpcmi = new MENUINFO();
        lpcmi.cbSize = MENUINFO.sizeof;
        lpcmi.fMask = 16;
        OS.GetMenuInfo(this.handle, lpcmi);
        lpcmi.dwStyle = hasImage && !hasCheck ? (lpcmi.dwStyle |= 0x4000000) : (lpcmi.dwStyle &= 0xFBFFFFFF);
        OS.SetMenuInfo(this.handle, lpcmi);
    }

    void updateBackground() {
        if (this.hBrush != 0L) {
            OS.DeleteObject(this.hBrush);
        }
        this.hBrush = 0L;
        if (this.backgroundImage != null) {
            this.hBrush = OS.CreatePatternBrush(Image.win32_getHandle(this.backgroundImage, this.getZoom()));
        } else if (this.background != -1) {
            this.hBrush = OS.CreateSolidBrush(this.background);
        }
        MENUINFO lpcmi = new MENUINFO();
        lpcmi.cbSize = MENUINFO.sizeof;
        lpcmi.fMask = 2;
        lpcmi.hbrBack = this.hBrush;
        OS.SetMenuInfo(this.handle, lpcmi);
    }

    void updateForeground() {
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        int index = 0;
        while (OS.GetMenuItemInfo(this.handle, index, true, info)) {
            info.fMask = 128;
            info.hbmpItem = -1L;
            OS.SetMenuItemInfo(this.handle, index, true, info);
            ++index;
        }
        this.redraw();
    }

    LRESULT wmTimer(long wParam, long lParam) {
        if (wParam == 110L) {
            POINT pt = new POINT();
            OS.GetCursorPos(pt);
            if (this.selectedMenuItem != null && this.selectedMenuItem.parent != null) {
                RECT rect = new RECT();
                boolean success = OS.GetMenuItemRect(0L, this.selectedMenuItem.parent.handle, this.selectedMenuItem.index, rect);
                if (!success) {
                    return null;
                }
                if (OS.PtInRect(rect, pt)) {
                    this.selectedMenuItem.showTooltip(pt.x, pt.y + this.getSystemMetrics(14) / 2 + 5);
                } else {
                    this.selectedMenuItem.showTooltip((rect.right + rect.left) / 2, rect.bottom + 5);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static void handleDPIChange(Widget widget, int newZoom, float scalingFactor) {
        void menu;
        if (!(widget instanceof Menu)) {
            return;
        }
        Menu menu2 = (Menu)widget;
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            DPIZoomChangeRegistry.applyChange(item, newZoom, scalingFactor);
            ++n2;
        }
    }
}

