/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TreeMap;
import org.eclipse.core.internal.resources.FilterDescriptor;
import org.eclipse.core.resources.IFilterMatcherDescriptor;
import org.eclipse.core.resources.filtermatchers.AbstractFileInfoMatcher;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.FilterCopy;
import org.eclipse.ui.internal.ide.dialogs.FilterEditDialog;
import org.eclipse.ui.internal.ide.dialogs.FilterTypeUtil;
import org.eclipse.ui.internal.ide.dialogs.ICustomFilterArgumentUI;
import org.eclipse.ui.internal.ide.dialogs.MultiMatcherLocalization;
import org.eclipse.ui.internal.ide.misc.FileInfoAttributesMatcher;

class MultiMatcherCustomFilterArgumentUI
implements ICustomFilterArgumentUI {
    private static final int DateTime_MIN_YEAR = 1752;
    Shell shell;
    FilterCopy filter;
    protected Button argumentsCaseSensitive;
    protected Button argumentsRegularExpresion;
    protected Text arguments;
    protected DateTime argumentsDate;
    protected Combo argumentsBoolean;
    protected Label argumentsLabel;
    protected Label description;
    protected ContentAssistCommandAdapter fContentAssistField;
    protected Combo multiKey;
    protected Combo multiOperator;
    protected Composite multiArgumentComposite;
    protected Composite conditionComposite;
    protected Composite descriptionComposite;
    protected Composite stringArgumentComposite;
    protected Composite stringTextArgumentComposite;
    protected Composite attributeStringArgumentComposite;
    protected Class<?> intiantiatedKeyOperatorType = null;
    protected TreeMap<String, String> valueCache = new TreeMap();
    protected boolean initializationComplete = false;
    protected FilterEditDialog dialog;
    protected Label dummyLabel1;
    protected Label dummyLabel2;
    protected static GregorianCalendar gregorianCalendar = new GregorianCalendar();
    private String[] timeIntervalPrefixes = new String[]{"s", "m", "h", "d"};
    private double[] timeIntervalScale = new double[]{60.0, 60.0, 24.0};
    private String[] lengthPrefixes = new String[]{"", "k", "m", "g"};

    public MultiMatcherCustomFilterArgumentUI(FilterEditDialog dialog, Shell parentShell, FilterCopy filter) {
        this.shell = parentShell;
        this.dialog = dialog;
        this.filter = filter;
    }

    @Override
    public Object getID() {
        return FileInfoAttributesMatcher.ID;
    }

    @Override
    public void dispose() {
        Widget[] list;
        Widget[] widgetArray = list = new Widget[]{this.multiKey, this.multiOperator, this.multiArgumentComposite, this.stringArgumentComposite, this.stringTextArgumentComposite, this.arguments, this.argumentsLabel, this.argumentsCaseSensitive, this.argumentsRegularExpresion, this.attributeStringArgumentComposite, this.description, this.conditionComposite, this.descriptionComposite, this.dummyLabel1, this.dummyLabel2};
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            if (widget != null) {
                widget.dispose();
            }
            ++n2;
        }
        this.multiKey = null;
        this.multiOperator = null;
        this.multiArgumentComposite = null;
        this.arguments = null;
        this.argumentsLabel = null;
        this.fContentAssistField = null;
        this.intiantiatedKeyOperatorType = null;
        this.stringArgumentComposite = null;
        this.stringTextArgumentComposite = null;
        this.argumentsCaseSensitive = null;
        this.argumentsRegularExpresion = null;
        this.attributeStringArgumentComposite = null;
        this.description = null;
        this.conditionComposite = null;
        this.descriptionComposite = null;
        this.dummyLabel1 = null;
        this.dummyLabel2 = null;
        this.initializationComplete = false;
    }

    @Override
    public void create(Composite argumentComposite, Font font) {
        this.shell = argumentComposite.getShell();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        argumentComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        argumentComposite.setLayoutData((Object)data);
        argumentComposite.setFont(font);
        this.conditionComposite = new Composite(argumentComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        this.conditionComposite.setLayout((Layout)layout);
        this.conditionComposite.setFont(font);
        data = new GridData(4, 4, true, true);
        this.conditionComposite.setLayoutData((Object)data);
        this.createCustomArgumentsArea(font, this.conditionComposite);
        this.descriptionComposite = new Composite(argumentComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = this.dialog.getHorizontalDLUsToPixel(7);
        layout.marginHeight = this.dialog.getVerticalDLUsToPixel(4);
        layout.horizontalSpacing = 0;
        this.descriptionComposite.setLayout((Layout)layout);
        this.descriptionComposite.setFont(font);
        data = new GridData(4, 4, true, true);
        this.descriptionComposite.setLayoutData((Object)data);
        this.createDescriptionArea(font, this.descriptionComposite);
        this.initializationComplete = true;
    }

    private void createDescriptionArea(Font font, Composite composite) {
        this.description = new Label(composite, 16448);
        GridData data = new GridData(4, 1, true, true);
        data.horizontalSpan = 3;
        this.description.setLayoutData((Object)data);
        this.description.setFont(font);
        this.setupDescriptionText(null);
    }

    private void setupDescriptionText(String errorString) {
        if (this.description != null) {
            if (errorString != null) {
                BufferedReader reader = new BufferedReader(new StringReader(errorString));
                try {
                    String tmp = reader.readLine();
                    if (tmp != null) {
                        errorString = tmp;
                    }
                }
                catch (IOException tmp) {
                    // empty catch block
                }
                this.description.setForeground(this.shell.getDisplay().getSystemColor(3));
                this.description.setText(errorString);
            } else {
                this.description.setForeground(this.shell.getDisplay().getSystemColor(2));
                String selectedKey = MultiMatcherLocalization.getMultiMatcherKey(this.multiKey.getText());
                String selectedOperator = MultiMatcherLocalization.getMultiMatcherKey(this.multiOperator.getText());
                Class<?> selectedKeyOperatorType = FileInfoAttributesMatcher.getTypeForKey(selectedKey, selectedOperator);
                this.description.setText("");
                if (selectedKeyOperatorType.equals(String.class) && !this.argumentsRegularExpresion.getSelection()) {
                    this.description.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_multiMatcher_Matcher, null));
                }
                if (selectedKeyOperatorType.equals(Integer.class)) {
                    if (selectedKey.equals(FileInfoAttributesMatcher.KEY_LAST_MODIFIED) || selectedKey.equals(FileInfoAttributesMatcher.KEY_CREATED)) {
                        this.description.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_multiMatcher_TimeInterval, null));
                    } else {
                        this.description.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_multiMatcher_FileLength, null));
                    }
                }
            }
            this.shell.layout(true, true);
        }
    }

    private void createCustomArgumentsArea(Font font, Composite composite) {
        String[] keys;
        this.multiArgumentComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = this.dialog.getHorizontalDLUsToPixel(7);
        layout.horizontalSpacing = this.dialog.getHorizontalDLUsToPixel(4);
        layout.marginTop = this.dialog.getVerticalDLUsToPixel(4);
        layout.marginHeight = 0;
        this.multiArgumentComposite.setLayout((Layout)layout);
        this.multiArgumentComposite.setFont(font);
        GridData data = new GridData(4, 4, true, true);
        this.multiArgumentComposite.setLayoutData((Object)data);
        this.multiKey = new Combo(this.multiArgumentComposite, 8);
        this.multiKey.setItems(this.getMultiMatcherKeys());
        data = new GridData(16384, 128, false, false);
        this.multiKey.setLayoutData((Object)data);
        this.multiKey.setFont(font);
        this.multiKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiMatcherCustomFilterArgumentUI.this.setupMultiOperatorAndField(true);
                MultiMatcherCustomFilterArgumentUI.this.storeMultiSelection();
            }
        });
        ArrayList<String> allOperators = new ArrayList<String>();
        String[] stringArray = keys = this.getMultiMatcherKeys();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            allOperators.addAll(Arrays.asList(this.getLocalOperatorsForKey(MultiMatcherLocalization.getMultiMatcherKey(key))));
            ++n2;
        }
        Combo tmp = new Combo(this.multiArgumentComposite, 8);
        tmp.setItems(allOperators.toArray(new String[0]));
        int maxWidth = tmp.computeSize((int)-1, (int)-1).x;
        tmp.dispose();
        this.multiOperator = new Combo(this.multiArgumentComposite, 8);
        data = new GridData(16384, 128, false, false);
        data.widthHint = maxWidth;
        this.multiOperator.setLayoutData((Object)data);
        this.multiOperator.setFont(font);
        this.multiOperator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiMatcherCustomFilterArgumentUI.this.setupMultiOperatorAndField(false);
                MultiMatcherCustomFilterArgumentUI.this.storeMultiSelection();
            }
        });
        FileInfoAttributesMatcher.Argument argument = FileInfoAttributesMatcher.decodeArguments((String)this.filter.getArguments());
        String local = MultiMatcherLocalization.getLocalMultiMatcherKey(argument.key);
        int index = this.multiKey.indexOf(local);
        if (index != -1) {
            this.multiKey.select(index);
        } else {
            this.multiKey.select(0);
        }
        this.setupMultiOperatorAndField(true);
    }

    private void setupMultiOperatorAndField(boolean updateOperator) {
        GridData data;
        boolean isUsingRegularExpression = false;
        String selectedKey = MultiMatcherLocalization.getMultiMatcherKey(this.multiKey.getText());
        if (updateOperator) {
            String[] operators = this.getLocalOperatorsForKey(selectedKey);
            this.multiOperator.setItems(operators);
            FileInfoAttributesMatcher.Argument argument = FileInfoAttributesMatcher.decodeArguments((String)this.filter.getArguments());
            String local = MultiMatcherLocalization.getLocalMultiMatcherKey(argument.operator);
            int index = this.multiOperator.indexOf(local);
            if (index != -1) {
                this.multiOperator.select(index);
            } else {
                this.multiOperator.select(0);
            }
        }
        String selectedOperator = MultiMatcherLocalization.getMultiMatcherKey(this.multiOperator.getText());
        Class<?> selectedKeyOperatorType = FileInfoAttributesMatcher.getTypeForKey(selectedKey, selectedOperator);
        if (this.intiantiatedKeyOperatorType != null) {
            if (this.arguments != null) {
                this.arguments.dispose();
                this.arguments = null;
            }
            if (this.attributeStringArgumentComposite != null) {
                this.attributeStringArgumentComposite.dispose();
                this.attributeStringArgumentComposite = null;
            }
            if (this.stringArgumentComposite != null) {
                this.stringArgumentComposite.dispose();
                this.stringArgumentComposite = null;
            }
            if (this.argumentsBoolean != null) {
                this.argumentsBoolean.dispose();
                this.argumentsBoolean = null;
            }
            if (this.argumentsDate != null) {
                this.argumentsDate.dispose();
                this.argumentsDate = null;
            }
            if (this.argumentsRegularExpresion != null) {
                this.argumentsRegularExpresion.dispose();
                this.argumentsRegularExpresion = null;
            }
            if (this.argumentsCaseSensitive != null) {
                this.argumentsCaseSensitive.dispose();
                this.argumentsCaseSensitive = null;
            }
            if (this.dummyLabel1 != null) {
                this.dummyLabel1.dispose();
                this.dummyLabel1 = null;
            }
            if (this.dummyLabel2 != null) {
                this.dummyLabel2.dispose();
                this.dummyLabel2 = null;
            }
            this.fContentAssistField = null;
            FileInfoAttributesMatcher.Argument argument = FileInfoAttributesMatcher.decodeArguments((String)this.filter.getArguments());
            this.valueCache.put(this.intiantiatedKeyOperatorType.getName(), argument.pattern);
            argument.pattern = this.valueCache.get(selectedKeyOperatorType.getName());
            if (argument.pattern == null) {
                argument.pattern = "";
            }
            this.filter.setArguments(FileInfoAttributesMatcher.encodeArguments(argument));
        }
        if (selectedKeyOperatorType.equals(String.class)) {
            this.arguments = new Text(this.multiArgumentComposite, 2052);
            data = new GridData(4, 4, true, false);
            data.widthHint = 150;
            this.arguments.setLayoutData((Object)data);
            this.arguments.setFont(this.multiArgumentComposite.getFont());
            this.arguments.addModifyListener(e -> this.validateInputText());
            this.dummyLabel1 = new Label(this.multiArgumentComposite, 0);
            data = new GridData(16384, 0x1000000, false, true);
            this.dummyLabel1.setText("");
            data.horizontalSpan = 1;
            this.dummyLabel1.setLayoutData((Object)data);
            this.dummyLabel2 = new Label(this.multiArgumentComposite, 0);
            data = new GridData(16384, 0x1000000, false, true);
            this.dummyLabel2.setText("");
            data.horizontalSpan = 1;
            this.dummyLabel2.setLayoutData((Object)data);
            this.stringArgumentComposite = new Composite(this.multiArgumentComposite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginTop = this.dialog.getVerticalDLUsToPixel(4) / 2;
            layout.marginHeight = 0;
            layout.marginBottom = 0;
            this.stringArgumentComposite.setLayout((Layout)layout);
            data = new GridData(4, 0x1000000, true, true);
            data.horizontalSpan = 1;
            this.stringArgumentComposite.setLayoutData((Object)data);
            this.stringArgumentComposite.setFont(this.multiArgumentComposite.getFont());
            this.argumentsCaseSensitive = new Button(this.stringArgumentComposite, 32);
            this.argumentsCaseSensitive.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_caseSensitive, null));
            data = new GridData(16384, 0x1000000, false, false);
            this.argumentsCaseSensitive.setLayoutData((Object)data);
            this.argumentsCaseSensitive.setFont(this.multiArgumentComposite.getFont());
            this.argumentsRegularExpresion = new Button(this.stringArgumentComposite, 32);
            this.argumentsRegularExpresion.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_regularExpression, null));
            data = new GridData(16384, 0x1000000, false, false);
            data.minimumWidth = 100;
            this.argumentsRegularExpresion.setLayoutData((Object)data);
            this.argumentsRegularExpresion.setFont(this.multiArgumentComposite.getFont());
            if (this.filter.hasStringArguments()) {
                FileInfoAttributesMatcher.Argument argument = FileInfoAttributesMatcher.decodeArguments((String)this.filter.getArguments());
                this.arguments.setText(argument.pattern);
                isUsingRegularExpression = argument.regularExpression;
                this.argumentsCaseSensitive.setSelection(argument.caseSensitive);
                this.argumentsRegularExpresion.setSelection(argument.regularExpression);
            }
            this.arguments.addModifyListener(e -> this.storeMultiSelection());
            this.argumentsRegularExpresion.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MultiMatcherCustomFilterArgumentUI.this.setupDescriptionText(null);
                    MultiMatcherCustomFilterArgumentUI.this.storeMultiSelection();
                    if (MultiMatcherCustomFilterArgumentUI.this.fContentAssistField != null) {
                        MultiMatcherCustomFilterArgumentUI.this.fContentAssistField.setEnabled(MultiMatcherCustomFilterArgumentUI.this.argumentsRegularExpresion.getSelection());
                    }
                }
            });
            this.argumentsCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MultiMatcherCustomFilterArgumentUI.this.storeMultiSelection();
                }
            });
            TextContentAdapter contentAdapter = new TextContentAdapter();
            FindReplaceDocumentAdapterContentProposalProvider findProposer = new FindReplaceDocumentAdapterContentProposalProvider(true);
            this.fContentAssistField = new ContentAssistCommandAdapter((Control)this.arguments, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, null, new char[]{'\\', '[', '('}, true);
        }
        if (selectedKeyOperatorType.equals(Integer.class)) {
            this.arguments = new Text(this.multiArgumentComposite, 2052);
            data = new GridData(4, 4, true, false);
            data.widthHint = 150;
            this.arguments.setLayoutData((Object)data);
            this.arguments.setFont(this.multiArgumentComposite.getFont());
            this.arguments.addModifyListener(e -> this.validateInputText());
            if (this.filter.hasStringArguments()) {
                FileInfoAttributesMatcher.Argument argument = FileInfoAttributesMatcher.decodeArguments((String)this.filter.getArguments());
                if (selectedKey.equals(FileInfoAttributesMatcher.KEY_LAST_MODIFIED) || selectedKey.equals(FileInfoAttributesMatcher.KEY_CREATED)) {
                    this.arguments.setText(this.convertToEditableTimeInterval(argument.pattern));
                } else {
                    this.arguments.setText(this.convertToEditableLength(argument.pattern));
                }
            }
            this.arguments.addModifyListener(e -> this.storeMultiSelection());
        }
        if (selectedKeyOperatorType.equals(Date.class)) {
            this.argumentsDate = new DateTime(this.multiArgumentComposite, 67616);
            data = new GridData(4, 4, true, false);
            this.argumentsDate.setLayoutData((Object)data);
            this.argumentsDate.setFont(this.multiArgumentComposite.getFont());
            this.argumentsDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MultiMatcherCustomFilterArgumentUI.this.storeMultiSelection();
                }
            });
            if (this.filter.hasStringArguments()) {
                Date date;
                FileInfoAttributesMatcher.Argument argument = FileInfoAttributesMatcher.decodeArguments((String)this.filter.getArguments());
                Calendar calendar = Calendar.getInstance();
                try {
                    date = new Date(Long.parseLong(argument.pattern));
                    calendar.setTime(date);
                }
                catch (NumberFormatException e1) {
                    date = new Date();
                    calendar.setTime(date);
                    argument.pattern = Long.toString(calendar.getTimeInMillis());
                }
                this.argumentsDate.setDay(calendar.get(5));
                this.argumentsDate.setMonth(calendar.get(2));
                this.argumentsDate.setYear(this.getDateYear(calendar));
            }
        }
        if (selectedKeyOperatorType.equals(Boolean.class)) {
            this.argumentsBoolean = new Combo(this.multiArgumentComposite, 8);
            data = new GridData(4, 128, true, false);
            this.argumentsBoolean.setLayoutData((Object)data);
            this.argumentsBoolean.setFont(this.multiArgumentComposite.getFont());
            this.argumentsBoolean.setItems(new String[]{MultiMatcherLocalization.getLocalMultiMatcherKey(Boolean.TRUE.toString()), MultiMatcherLocalization.getLocalMultiMatcherKey(Boolean.FALSE.toString())});
            this.argumentsBoolean.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MultiMatcherCustomFilterArgumentUI.this.storeMultiSelection();
                }
            });
            if (this.filter.hasStringArguments()) {
                FileInfoAttributesMatcher.Argument argument = FileInfoAttributesMatcher.decodeArguments((String)this.filter.getArguments());
                if (argument.pattern.isEmpty()) {
                    this.argumentsBoolean.select(0);
                } else {
                    this.argumentsBoolean.select(Boolean.parseBoolean(argument.pattern) ? 0 : 1);
                }
            }
        }
        this.intiantiatedKeyOperatorType = selectedKeyOperatorType;
        if (this.fContentAssistField != null) {
            this.fContentAssistField.setEnabled(isUsingRegularExpression);
        }
        this.shell.layout(true, true);
        if (this.initializationComplete) {
            Point size = this.shell.computeSize(-1, -1);
            Point shellSize = this.shell.getSize();
            size.x = Math.max(size.x, shellSize.x);
            size.y = Math.max(size.y, shellSize.y);
            if (size.x > shellSize.x || size.y > shellSize.y) {
                this.shell.setSize(size);
            }
        }
        this.shell.redraw();
        this.setupDescriptionText(null);
    }

    private String convertToEditableTimeInterval(String string) {
        long value;
        if (string.isEmpty()) {
            return string;
        }
        try {
            value = Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            value = 0L;
        }
        if (value == 0L) {
            return Long.toString(0L);
        }
        int i = 0;
        while (i < this.timeIntervalPrefixes.length - 1) {
            if ((double)value % this.timeIntervalScale[i] != 0.0) {
                return Long.toString(value) + this.timeIntervalPrefixes[i];
            }
            value = (long)((double)value / this.timeIntervalScale[i]);
            ++i;
        }
        return Long.toString(value) + this.timeIntervalPrefixes[this.timeIntervalPrefixes.length - 1];
    }

    private String convertFromEditableTimeInterval(String string) {
        if (string.isEmpty()) {
            return string;
        }
        int i = 1;
        while (i < this.timeIntervalPrefixes.length) {
            if (string.endsWith(this.timeIntervalPrefixes[i])) {
                long value = Long.parseLong(string.substring(0, string.length() - 1));
                int j = 0;
                while (j < i) {
                    value = (long)((double)value * this.timeIntervalScale[j]);
                    ++j;
                }
                return Long.toString(value);
            }
            ++i;
        }
        return Long.toString(Long.parseLong(string));
    }

    private String convertToEditableLength(String string) {
        long value;
        if (string.isEmpty()) {
            return string;
        }
        try {
            value = Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            value = 0L;
        }
        if (value == 0L) {
            return Long.toString(0L);
        }
        int i = 0;
        while (i < this.lengthPrefixes.length) {
            if (value % 1024L != 0L) {
                return Long.toString(value) + this.lengthPrefixes[i];
            }
            if (i + 1 < this.lengthPrefixes.length) {
                value /= 1024L;
            }
            ++i;
        }
        return Long.toString(value) + this.lengthPrefixes[this.lengthPrefixes.length - 1];
    }

    private String convertFromEditableLength(String string) throws NumberFormatException {
        if (string.isEmpty()) {
            return string;
        }
        int i = 1;
        while (i < this.lengthPrefixes.length) {
            if (string.endsWith(this.lengthPrefixes[i])) {
                long value = Long.parseLong(string.substring(0, string.length() - 1));
                value = (long)((double)value * Math.pow(1024.0, i));
                return Long.toString(value);
            }
            ++i;
        }
        return Long.toString(Long.parseLong(string));
    }

    private int getDateYear(Calendar calendar) {
        Date calendarDate = calendar.getTime();
        int calendarYear = calendar.get(1);
        if (calendarYear >= 1752) {
            return calendarYear;
        }
        gregorianCalendar.setTime(calendarDate);
        return gregorianCalendar.get(1);
    }

    private int getCalendarYear() {
        Calendar calendar = Calendar.getInstance();
        int calendarYear = calendar.get(1);
        int dateYear = this.argumentsDate.getYear();
        if (calendarYear >= 1752) {
            return dateYear;
        }
        gregorianCalendar.setTime(new Date());
        int currentYear = gregorianCalendar.get(1);
        dateYear = calendarYear + (dateYear - currentYear);
        return dateYear;
    }

    private void storeMultiSelection() {
        if (this.intiantiatedKeyOperatorType != null) {
            String selectedKey = MultiMatcherLocalization.getMultiMatcherKey(this.multiKey.getText());
            String selectedOperator = MultiMatcherLocalization.getMultiMatcherKey(this.multiOperator.getText());
            FileInfoAttributesMatcher.Argument argument = new FileInfoAttributesMatcher.Argument();
            argument.key = selectedKey;
            argument.operator = selectedOperator;
            if (this.intiantiatedKeyOperatorType.equals(Date.class) && this.argumentsDate != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(this.getCalendarYear(), this.argumentsDate.getMonth(), this.argumentsDate.getDay());
                argument.pattern = Long.toString(calendar.getTimeInMillis());
            }
            if (this.intiantiatedKeyOperatorType.equals(String.class) && this.arguments != null) {
                argument.pattern = this.arguments.getText();
                if (this.argumentsRegularExpresion != null) {
                    argument.regularExpression = this.argumentsRegularExpresion.getSelection();
                }
                if (this.argumentsCaseSensitive != null) {
                    argument.caseSensitive = this.argumentsCaseSensitive.getSelection();
                }
            }
            if (this.intiantiatedKeyOperatorType.equals(Integer.class) && this.arguments != null) {
                try {
                    argument.pattern = selectedKey.equals(FileInfoAttributesMatcher.KEY_LAST_MODIFIED) || selectedKey.equals(FileInfoAttributesMatcher.KEY_CREATED) ? this.convertFromEditableTimeInterval(this.arguments.getText()) : this.convertFromEditableLength(this.arguments.getText());
                }
                catch (NumberFormatException e) {
                    argument.pattern = this.arguments.getText();
                }
            }
            if (this.intiantiatedKeyOperatorType.equals(Boolean.class) && this.argumentsBoolean != null) {
                argument.pattern = MultiMatcherLocalization.getMultiMatcherKey(this.argumentsBoolean.getText());
            }
            String encodedArgument = FileInfoAttributesMatcher.encodeArguments(argument);
            FilterTypeUtil.setValue(this.filter, FilterTypeUtil.ARGUMENTS, encodedArgument);
        }
    }

    private String[] getLocalOperatorsForKey(String key) {
        String[] operators = FileInfoAttributesMatcher.getOperatorsForKey(key);
        String[] result = new String[operators.length];
        int i = 0;
        while (i < operators.length) {
            result[i] = MultiMatcherLocalization.getLocalMultiMatcherKey(operators[i]);
            ++i;
        }
        return result;
    }

    private String[] getMultiMatcherKeys() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(MultiMatcherLocalization.getLocalMultiMatcherKey(FileInfoAttributesMatcher.KEY_NAME));
        list.add(MultiMatcherLocalization.getLocalMultiMatcherKey(FileInfoAttributesMatcher.KEY_PROPJECT_RELATIVE_PATH));
        list.add(MultiMatcherLocalization.getLocalMultiMatcherKey(FileInfoAttributesMatcher.KEY_LOCATION));
        list.add(MultiMatcherLocalization.getLocalMultiMatcherKey(FileInfoAttributesMatcher.KEY_LAST_MODIFIED));
        if (FileInfoAttributesMatcher.supportCreatedKey()) {
            list.add(MultiMatcherLocalization.getLocalMultiMatcherKey(FileInfoAttributesMatcher.KEY_CREATED));
        }
        list.add(MultiMatcherLocalization.getLocalMultiMatcherKey(FileInfoAttributesMatcher.KEY_LENGTH));
        list.add(MultiMatcherLocalization.getLocalMultiMatcherKey(FileInfoAttributesMatcher.KEY_IS_READONLY));
        if (!Platform.getOS().equals("win32")) {
            list.add(MultiMatcherLocalization.getLocalMultiMatcherKey(FileInfoAttributesMatcher.KEY_IS_SYMLINK));
        }
        return list.toArray(new String[0]);
    }

    @Override
    public void selectionChanged() {
    }

    void validateInputText() {
        this.setupDescriptionText(this.validate());
        this.dialog.updateFinishControls();
    }

    @Override
    public String validate() {
        String message = null;
        if (this.intiantiatedKeyOperatorType != null) {
            String selectedKey = MultiMatcherLocalization.getMultiMatcherKey(this.multiKey.getText());
            String selectedOperator = MultiMatcherLocalization.getMultiMatcherKey(this.multiOperator.getText());
            FileInfoAttributesMatcher.Argument argument = new FileInfoAttributesMatcher.Argument();
            argument.key = selectedKey;
            argument.operator = selectedOperator;
            if (this.intiantiatedKeyOperatorType.equals(String.class) && this.arguments != null) {
                argument.pattern = this.arguments.getText();
                if (this.argumentsRegularExpresion != null) {
                    argument.regularExpression = this.argumentsRegularExpresion.getSelection();
                }
                if (this.argumentsCaseSensitive != null) {
                    argument.caseSensitive = this.argumentsCaseSensitive.getSelection();
                }
                String encodedArgument = FileInfoAttributesMatcher.encodeArguments(argument);
                FilterCopy copy = new FilterCopy(this.filter);
                FilterTypeUtil.setValue(copy, FilterTypeUtil.ARGUMENTS, encodedArgument);
                IFilterMatcherDescriptor desc = this.dialog.getResource().getWorkspace().getFilterMatcherDescriptor(copy.getId());
                if (desc != null) {
                    try {
                        AbstractFileInfoMatcher matcher = ((FilterDescriptor)desc).createFilter();
                        matcher.initialize(this.dialog.getResource().getProject(), copy.getArguments());
                    }
                    catch (CoreException e) {
                        message = e.getMessage();
                    }
                }
            }
            if (this.intiantiatedKeyOperatorType.equals(Integer.class) && this.arguments != null) {
                if (selectedKey.equals(FileInfoAttributesMatcher.KEY_LAST_MODIFIED) || selectedKey.equals(FileInfoAttributesMatcher.KEY_CREATED)) {
                    try {
                        this.convertFromEditableTimeInterval(this.arguments.getText());
                    }
                    catch (NumberFormatException e) {
                        message = NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_multiMatcher_InvalidTimeInterval, (Object)this.arguments.getText());
                    }
                } else {
                    try {
                        this.convertFromEditableLength(this.arguments.getText());
                    }
                    catch (NumberFormatException e) {
                        message = NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_multiMatcher_InvalidFileLength, (Object)this.arguments.getText());
                    }
                }
            }
            if (this.intiantiatedKeyOperatorType.equals(Boolean.class)) {
                // empty if block
            }
        }
        return message;
    }

    @Override
    public StyledString formatStyledText(FilterCopy filterCopy, StyledString.Styler fPlainStyler, StyledString.Styler fBoldStyler) {
        return new StyledString(this.formatMultiMatcherArgument(filterCopy), fPlainStyler);
    }

    private String formatMultiMatcherArgument(FilterCopy filterCopy) {
        String argumentString = (String)filterCopy.getArguments();
        FileInfoAttributesMatcher.Argument argument = FileInfoAttributesMatcher.decodeArguments(argumentString);
        StringBuilder builder = new StringBuilder();
        builder.append(MultiMatcherLocalization.getLocalMultiMatcherKey(argument.key));
        builder.append(' ');
        builder.append(MultiMatcherLocalization.getLocalMultiMatcherKey(argument.operator));
        builder.append(' ');
        Class<?> type = FileInfoAttributesMatcher.getTypeForKey(argument.key, argument.operator);
        if (type.equals(String.class)) {
            builder.append(argument.pattern);
        }
        if (type.equals(Boolean.class)) {
            builder.append(MultiMatcherLocalization.getLocalMultiMatcherKey(argument.pattern));
        }
        if (type.equals(Integer.class)) {
            if (argument.key.equals(FileInfoAttributesMatcher.KEY_LAST_MODIFIED) || argument.key.equals(FileInfoAttributesMatcher.KEY_CREATED)) {
                builder.append(this.convertToEditableTimeInterval(argument.pattern));
            } else {
                builder.append(this.convertToEditableLength(argument.pattern));
            }
        }
        if (type.equals(Date.class)) {
            builder.append(DateFormat.getDateInstance().format(new Date(Long.parseLong(argument.pattern))));
        }
        return builder.toString();
    }
}

