/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.ICopyright;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.metadata.expression.IMemberProvider;

public class ResolvedInstallableUnit
implements IInstallableUnit,
IMemberProvider {
    private final List<IInstallableUnitFragment> fragments;
    protected final IInstallableUnit original;
    public static final String MEMBER_ORIGINAL = "original";
    public static final String MEMBER_FRAGMENTS = "fragments";

    public ResolvedInstallableUnit(IInstallableUnit resolved) {
        this(resolved, List.of());
    }

    public ResolvedInstallableUnit(IInstallableUnit resolved, List<IInstallableUnitFragment> fragments) {
        this.original = resolved;
        this.fragments = fragments;
    }

    @Override
    public Collection<IInstallableUnitFragment> getFragments() {
        return this.withFragmentElements(this.fragments, f -> f.isResolved() ? f.getFragments() : List.of());
    }

    @Override
    public Collection<IArtifactKey> getArtifacts() {
        return this.original.getArtifacts();
    }

    @Override
    public IMatchExpression<IInstallableUnit> getFilter() {
        return this.original.getFilter();
    }

    @Override
    public String getId() {
        return this.original.getId();
    }

    @Override
    public String getProperty(String key) {
        return this.original.getProperty(key);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.original.getProperties();
    }

    @Override
    public String getProperty(String key, String locale) {
        return this.original.getProperty(key, locale);
    }

    @Override
    public Collection<IProvidedCapability> getProvidedCapabilities() {
        return this.withFragmentElements(this.original.getProvidedCapabilities(), IInstallableUnit::getProvidedCapabilities);
    }

    @Override
    public Collection<IRequirement> getRequirements() {
        return this.withFragmentElements(this.original.getRequirements(), IInstallableUnit::getRequirements);
    }

    @Override
    public Collection<IRequirement> getMetaRequirements() {
        return this.withFragmentElements(this.original.getMetaRequirements(), IInstallableUnit::getMetaRequirements);
    }

    @Override
    public Collection<ITouchpointData> getTouchpointData() {
        return this.withFragmentElements(this.original.getTouchpointData(), IInstallableUnit::getTouchpointData);
    }

    private <T> Collection<T> withFragmentElements(Collection<T> elements, Function<IInstallableUnit, Collection<T>> getter) {
        if (this.fragments.isEmpty()) {
            return elements;
        }
        return Stream.concat(elements.stream(), this.fragments.stream().map(getter).flatMap(Collection::stream)).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public ITouchpointType getTouchpointType() {
        return this.original.getTouchpointType();
    }

    @Override
    public Version getVersion() {
        return this.original.getVersion();
    }

    @Override
    public boolean isSingleton() {
        return this.original.isSingleton();
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = this.original.equals(obj);
        if (result) {
            return true;
        }
        if (obj instanceof ResolvedInstallableUnit) {
            ResolvedInstallableUnit unit = (ResolvedInstallableUnit)obj;
            if (this.original.equals(unit.original)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.original.hashCode();
    }

    public String toString() {
        return "[R]" + String.valueOf(this.original);
    }

    public IInstallableUnit getOriginal() {
        return this.original;
    }

    @Override
    public int compareTo(IInstallableUnit other) {
        return InstallableUnit.ID_FIRST_THEN_VERSION.compare(this, other);
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    public IInstallableUnit unresolved() {
        return this.original.unresolved();
    }

    @Override
    public IUpdateDescriptor getUpdateDescriptor() {
        return this.original.getUpdateDescriptor();
    }

    @Override
    public Collection<ILicense> getLicenses() {
        return this.original.getLicenses();
    }

    @Override
    public Collection<ILicense> getLicenses(String locale) {
        return this.original.getLicenses(locale);
    }

    @Override
    public ICopyright getCopyright() {
        return this.original.getCopyright();
    }

    @Override
    public ICopyright getCopyright(String locale) {
        return this.original.getCopyright(locale);
    }

    @Override
    public boolean satisfies(IRequirement candidate) {
        return candidate.isMatch(this);
    }

    @Override
    public Object getMember(String memberName) {
        return switch (memberName) {
            case MEMBER_FRAGMENTS -> this.fragments.toArray(IInstallableUnitFragment[]::new);
            case MEMBER_ORIGINAL -> this.original;
            case "providedCapabilities" -> this.getProvidedCapabilities();
            case "id" -> this.getId();
            case "version" -> this.getVersion();
            case "properties" -> this.getProperties();
            case "filter" -> this.getFilter();
            case "artifacts" -> this.getArtifacts();
            case "requirements" -> this.getRequirements();
            case "licenses" -> this.getLicenses();
            case "copyright" -> this.getCopyright();
            case "touchpointData" -> this.getTouchpointData();
            case "touchpointType" -> this.getTouchpointType();
            case "updateDescriptor" -> this.getUpdateDescriptor();
            case "singleton" -> this.isSingleton();
            default -> throw new IllegalArgumentException("No such member: " + memberName);
        };
    }
}

