/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite.metadata;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.metadata.repository.LocalMetadataRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.SimpleMetadataRepositoryFactory;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.p2.updatesite.Messages;
import org.eclipse.equinox.internal.p2.updatesite.RemoteUpdateSiteAction;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.internal.p2.updatesite.metadata.UpdateSiteMetadataRepository;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.spi.MetadataRepositoryFactory;
import org.eclipse.osgi.util.NLS;

public class UpdateSiteMetadataRepositoryFactory
extends MetadataRepositoryFactory {
    private static final String PROP_SITE_CHECKSUM = "site.checksum";

    public static URI getLocalRepositoryLocation(URI location) {
        String stateDirName = Integer.toString(location.hashCode());
        File bundleData = Activator.getBundleContext().getDataFile(null);
        File stateDir = new File(bundleData, stateDirName);
        return stateDir.toURI();
    }

    public IMetadataRepository create(URI location, String name, String type, Map<String, String> properties) {
        return null;
    }

    public IMetadataRepository load(URI location, int flags, IProgressMonitor monitor) throws ProvisionException {
        if ((flags & 1) > 0) {
            return null;
        }
        if (!UpdateSiteMetadataRepositoryFactory.isURL(location)) {
            return null;
        }
        IMetadataRepository repository = this.loadRepository(location, monitor);
        try {
            this.initializeRepository(repository, location, monitor);
        }
        catch (Exception e) {
            try {
                this.resetCache(repository);
            }
            catch (RuntimeException rte) {
                e.addSuppressed(rte);
            }
            if (e instanceof ProvisionException) {
                throw (ProvisionException)((Object)e);
            }
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)e;
            }
            throw new ProvisionException((IStatus)new Status(4, Activator.ID, NLS.bind((String)Messages.Unexpected_exception, (Object)location.toString()), (Throwable)e));
        }
        return new UpdateSiteMetadataRepository(location, repository);
    }

    private static boolean isURL(URI location) {
        try {
            new URL(location.toASCIIString());
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    private void resetCache(IMetadataRepository repository) {
        repository.setProperty(PROP_SITE_CHECKSUM, "0");
        repository.removeAll();
    }

    public IMetadataRepository loadRepository(URI location, IProgressMonitor monitor) {
        URI localRepositoryURL = UpdateSiteMetadataRepositoryFactory.getLocalRepositoryLocation(location);
        SimpleMetadataRepositoryFactory factory = new SimpleMetadataRepositoryFactory();
        factory.setAgent(this.getAgent());
        try {
            return factory.load(localRepositoryURL, 0, monitor);
        }
        catch (ProvisionException provisionException) {
            String repositoryName = "update site: " + String.valueOf(location);
            return factory.create(localRepositoryURL, repositoryName, null, null);
        }
    }

    public void initializeRepository(IMetadataRepository repository, URI location, IProgressMonitor monitor) throws ProvisionException {
        UpdateSite updateSite = UpdateSite.load(location, (Transport)this.getAgent().getService(Transport.class), monitor);
        String savedChecksum = (String)repository.getProperties().get(PROP_SITE_CHECKSUM);
        if (savedChecksum != null && savedChecksum.equals(updateSite.getChecksum())) {
            return;
        }
        repository.setProperty(PROP_SITE_CHECKSUM, updateSite.getChecksum());
        repository.removeAll();
        IStatus status = this.generateMetadata(updateSite, repository, monitor);
        if (repository instanceof LocalMetadataRepository) {
            ((LocalMetadataRepository)repository).publishRepositoryReferences();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!status.isOK()) {
            throw new ProvisionException(status);
        }
    }

    private IStatus generateMetadata(UpdateSite updateSite, IMetadataRepository repository, IProgressMonitor monitor) {
        PublisherInfo info = new PublisherInfo();
        info.setMetadataRepository(repository);
        IPublisherAction[] actions = new IPublisherAction[]{new RemoteUpdateSiteAction(updateSite, null)};
        Publisher publisher = new Publisher((IPublisherInfo)info);
        return publisher.publish(actions, monitor);
    }
}

