/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OomphPropertySheetPage
extends ExtendedPropertySheetPage {
    private Tree tree;
    private ControlAdapter columnResizer;
    private CopyValuePropertyAction copyPropertyValueAction;
    private Clipboard clipboard;
    private IWorkbenchPart part;

    public OomphPropertySheetPage(AdapterFactoryEditingDomain editingDomain, ExtendedPropertySheetPage.Decoration decoration, IDialogSettings dialogSettings) {
        super(editingDomain, decoration, dialogSettings);
        this.setSorter(new PropertySheetSorter(){

            public void sort(IPropertySheetEntry[] entries) {
            }
        });
    }

    public void setRootEntry(IPropertySheetEntry entry) {
        this.getCopyPropertyValueAction();
        super.setRootEntry(entry);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.addColumnResizer();
        Menu menu = this.getControl().getMenu();
        IMenuManager menuManager = (IMenuManager)menu.getData("org.eclipse.jface.action.MenuManager.managerKey");
        menuManager.insertAfter("copy", (IAction)this.getCopyPropertyValueAction());
    }

    private Action getCopyPropertyValueAction() {
        if (this.copyPropertyValueAction == null) {
            Shell shell = this.getControl().getShell();
            this.clipboard = new Clipboard(shell.getDisplay());
            this.copyPropertyValueAction = new CopyValuePropertyAction(this.clipboard);
        }
        return this.copyPropertyValueAction;
    }

    private void addColumnResizer() {
        this.tree = (Tree)this.getControl();
        this.tree.addTreeListener(new TreeListener(){
            Runnable runnable = new Runnable(){

                public void run() {
                    OomphPropertySheetPage.this.resizeColumns();
                }
            };

            public void treeExpanded(TreeEvent e) {
                UIUtil.asyncExec((Control)OomphPropertySheetPage.this.tree, this.runnable);
            }

            public void treeCollapsed(TreeEvent e) {
                UIUtil.asyncExec((Control)OomphPropertySheetPage.this.tree, this.runnable);
            }
        });
        final TreeColumn propertyColumn = this.tree.getColumn(0);
        propertyColumn.setResizable(false);
        final TreeColumn valueColumn = this.tree.getColumn(1);
        valueColumn.setResizable(false);
        this.columnResizer = new ControlAdapter(){
            private int clientWidth = -1;
            private int propertyWidth = -1;
            private int valueWidth = -1;
            private boolean resizing;

            public void controlResized(ControlEvent e) {
                boolean inputChanged;
                if (this.resizing) {
                    return;
                }
                Rectangle clientArea = OomphPropertySheetPage.this.tree.getClientArea();
                int clientWidth = clientArea.width - clientArea.x;
                ScrollBar bar = OomphPropertySheetPage.this.tree.getVerticalBar();
                if (bar != null && bar.isVisible()) {
                    clientWidth -= bar.getSize().x;
                }
                int propertyWidth = propertyColumn.getWidth();
                int valueWidth = valueColumn.getWidth();
                boolean bl = inputChanged = e == null;
                if (inputChanged || clientWidth != this.clientWidth || propertyWidth != this.propertyWidth || valueWidth != this.valueWidth) {
                    try {
                        this.resizing = true;
                        OomphPropertySheetPage.this.tree.setRedraw(false);
                        TreeItem[] items = OomphPropertySheetPage.this.tree.getItems();
                        if (items.length == 0) {
                            propertyWidth = clientWidth / 2;
                            propertyColumn.setWidth(propertyWidth);
                            valueColumn.setWidth(clientWidth - propertyWidth);
                        } else {
                            propertyColumn.pack();
                            propertyWidth = propertyColumn.getWidth() + 20;
                            propertyColumn.setWidth(propertyWidth);
                            valueColumn.pack();
                            valueWidth = valueColumn.getWidth();
                            if (propertyWidth + valueWidth < clientWidth) {
                                valueWidth = clientWidth - propertyWidth;
                                valueColumn.setWidth(valueWidth);
                            }
                        }
                    }
                    finally {
                        this.clientWidth = clientWidth;
                        this.propertyWidth = propertyWidth;
                        this.valueWidth = valueWidth;
                        OomphPropertySheetPage.this.tree.setRedraw(true);
                        this.resizing = false;
                    }
                }
            }
        };
        this.tree.addControlListener((ControlListener)this.columnResizer);
        propertyColumn.addControlListener((ControlListener)this.columnResizer);
        valueColumn.addControlListener((ControlListener)this.columnResizer);
        this.resizeColumns();
    }

    private void resizeColumns() {
        this.columnResizer.controlResized(null);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.part = part;
        super.selectionChanged(part, selection);
        this.resizeColumns();
    }

    public void handleEntrySelection(ISelection selection) {
        super.handleEntrySelection(selection);
        this.copyPropertyValueAction.selectionChanged((IStructuredSelection)selection);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IFindReplaceTarget.class) {
            return (T)this.part.getAdapter(adapter);
        }
        return (T)super.getAdapter(adapter);
    }

    public void setPropertySourceProvider(IPropertySourceProvider newProvider) {
        if (newProvider instanceof AdapterFactoryContentProvider) {
            final AdapterFactoryContentProvider adapterFactoryContentProvider = (AdapterFactoryContentProvider)newProvider;
            super.setPropertySourceProvider(new IPropertySourceProvider(){

                public IPropertySource getPropertySource(Object object) {
                    IPropertySource propertySource = adapterFactoryContentProvider.getPropertySource(object);
                    if (propertySource instanceof PropertySource && propertySource.getClass() == PropertySource.class) {
                        return new PropertySource(object, (IItemPropertySource)ReflectUtil.getValue((String)"itemPropertySource", (Object)propertySource)){

                            protected IPropertyDescriptor createPropertyDescriptor(IItemPropertyDescriptor itemPropertyDescriptor) {
                                return new OomphPropertyDescriptor(this.object, itemPropertyDescriptor);
                            }
                        };
                    }
                    return propertySource;
                }
            });
        } else {
            super.setPropertySourceProvider(newProvider);
        }
    }

    public void dispose() {
        super.dispose();
        this.clipboard.dispose();
    }

    private static class CopyValuePropertyAction
    extends Action {
        private Clipboard clipboard;
        private IStructuredSelection selection;

        public CopyValuePropertyAction(Clipboard clipboard) {
            super("Copy &Value");
            this.clipboard = clipboard;
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        }

        public void run() {
            IPropertySheetEntry entry;
            String value;
            if (this.selection != null && !this.selection.isEmpty() && (value = (entry = (IPropertySheetEntry)this.selection.getFirstElement()).getValueAsString()) != null) {
                this.setClipboard(value);
            }
        }

        public void selectionChanged(IStructuredSelection selection) {
            this.selection = selection;
            this.setEnabled(!selection.isEmpty());
        }

        private void setClipboard(String text) {
            try {
                Object[] data = new Object[]{text};
                Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
                this.clipboard.setContents(data, transferTypes);
            }
            catch (SWTError ex) {
                UIPlugin.INSTANCE.log(ex);
            }
        }
    }

    public static class OomphPropertyDescriptor
    extends PropertyDescriptor {
        private static final PropertyDescriptor.EDataTypeValueHandler NO_OP_VALUE_HANDLER = new PropertyDescriptor.EDataTypeValueHandler(EcorePackage.Literals.ESTRING);

        public OomphPropertyDescriptor(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
            super(object, itemPropertyDescriptor);
        }

        protected CellEditor createEDataTypeCellEditor(EDataType eDataType, Composite composite) {
            if (this.itemPropertyDescriptor.isMultiLine(this.object)) {
                return new PropertyDescriptor.EDataTypeCellEditor(eDataType, composite){
                    private Text text;
                    private Button button;
                    private boolean doEscape;
                    private String value;
                    private MouseListener mouseListener;
                    private VerifyListener verifyListener;
                    {
                        this.mouseListener = new MouseAdapter(){

                            public void mouseUp(MouseEvent e) {
                                this.showDialog();
                            }

                            public void mouseDoubleClick(MouseEvent e) {
                                this.showDialog();
                            }
                        };
                        this.verifyListener = new VerifyListener(){

                            public void verifyText(VerifyEvent e) {
                                e.doit = false;
                                this.showDialog();
                            }
                        };
                    }

                    private void showDialog() {
                        this.button.setFocus();
                        UIUtil.asyncExec(new Runnable(){

                            public void run() {
                                button.notifyListeners(13, null);
                            }
                        });
                    }

                    public Object doGetValue() {
                        String str;
                        String string = str = this.value != null ? this.value : (String)super.doGetValue();
                        if (this.doEscape) {
                            str = StringUtil.unescape((String)str);
                        }
                        return str;
                    }

                    public void doSetValue(Object value) {
                        this.text.removeMouseListener(this.mouseListener);
                        this.text.removeVerifyListener(this.verifyListener);
                        String str = this.valueHandler.toString(value);
                        if (str != null) {
                            char[] cArray = str.toCharArray();
                            int n = cArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                char c = cArray[n2];
                                if (Character.isISOControl(c)) {
                                    this.doEscape = true;
                                    str = StringUtil.escape((String)str);
                                    break;
                                }
                                ++n2;
                            }
                        }
                        PropertyDescriptor.EDataTypeValueHandler oldValueHandler = this.valueHandler;
                        try {
                            boolean isVeryLong;
                            boolean bl = isVeryLong = str.length() > 2000;
                            if (isVeryLong) {
                                this.value = str;
                                str = str.substring(0, 2000);
                            } else {
                                this.value = null;
                            }
                            this.valueHandler = NO_OP_VALUE_HANDLER;
                            super.doSetValue((Object)str);
                            if (isVeryLong) {
                                this.text.addMouseListener(this.mouseListener);
                                this.text.addVerifyListener(this.verifyListener);
                            }
                        }
                        finally {
                            this.valueHandler = oldValueHandler;
                        }
                    }

                    protected Control createControl(Composite parent) {
                        GridLayout layout = new GridLayout(2, false);
                        layout.marginWidth = 0;
                        layout.marginHeight = 0;
                        layout.horizontalSpacing = 0;
                        final Composite composite = new Composite(parent, 0);
                        composite.setLayout((Layout)layout);
                        composite.setFont(parent.getFont());
                        composite.setBackground(parent.getBackground());
                        this.text = (Text)super.createControl(composite);
                        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
                        this.button = new Button(composite, 8);
                        this.button.setLayoutData((Object)new GridData(4, 4, false, true));
                        this.button.setText("...");
                        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                Dialog dialog;
                                boolean containsNull;
                                String stringValue = valueHandler.toString(this.getValue());
                                boolean bl = containsNull = stringValue.indexOf(0) != -1;
                                if (containsNull) {
                                    stringValue = stringValue.replace('\u0000', '\n');
                                }
                                try {
                                    Class c = CommonPlugin.loadClass((String)"org.eclipse.emf.edit.ui", (String)"org.eclipse.emf.edit.ui.provider.PropertyDescriptor$MultiLineInputDialog");
                                    if (c == null) {
                                        throw new Exception("Could not find class org.eclipse.emf.edit.ui.provider.PropertyDescriptor$MultiLineInputDialog");
                                    }
                                    Constructor constructor = c.getConstructor(Shell.class, String.class, String.class, String.class, IInputValidator.class);
                                    if (constructor == null) {
                                        throw new Exception("Could not find constructor of org.eclipse.emf.edit.ui.provider.PropertyDescriptor$MultiLineInputDialog");
                                    }
                                    constructor.setAccessible(true);
                                    dialog = (Dialog)constructor.newInstance(composite.getShell(), EMFEditUIPlugin.INSTANCE.getString("_UI_FeatureEditorDialog_title", new Object[]{OomphPropertyDescriptor.this.getDisplayName(), OomphPropertyDescriptor.this.getEditLabelProvider().getText(OomphPropertyDescriptor.this.object)}), EMFEditUIPlugin.INSTANCE.getString("_UI_MultiLineInputDialog_message"), stringValue, valueHandler);
                                    if (dialog == null) {
                                        throw new Exception("Could not open dialog org.eclipse.emf.edit.ui.provider.PropertyDescriptor$MultiLineInputDialog");
                                    }
                                }
                                catch (Throwable ex) {
                                    UIPlugin.INSTANCE.log(ex);
                                    return;
                                }
                                int shellStyle = (Integer)ReflectUtil.invokeMethod((String)"getShellStyle", (Object)dialog);
                                ReflectUtil.invokeMethod((Method)ReflectUtil.getMethod((Object)dialog, (String)"setShellStyle", (Class[])new Class[]{Integer.TYPE}), (Object)dialog, (Object[])new Object[]{new Integer(shellStyle | 0x400)});
                                if (dialog.open() == 0) {
                                    Object newValue;
                                    String value = (String)ReflectUtil.invokeMethod((String)"getValue", (Object)dialog);
                                    value = value.replaceAll("\r\n", "\n");
                                    if (containsNull) {
                                        value = value.replace('\n', '\u0000');
                                    }
                                    if ((newValue = valueHandler.toValue(value)) != null) {
                                        boolean newValidState = this.isCorrect(newValue);
                                        if (newValidState) {
                                            this.markDirty();
                                            this.doSetValue(newValue);
                                            this.fireApplyEditorValue();
                                        } else {
                                            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), newValue.toString()));
                                        }
                                    }
                                } else {
                                    this.fireCancelEditor();
                                }
                            }
                        });
                        this.button.addKeyListener((KeyListener)new KeyAdapter(){

                            public void keyReleased(KeyEvent e) {
                                if (e.character == '\u001b') {
                                    this.fireCancelEditor();
                                }
                            }
                        });
                        return composite;
                    }

                    protected void focusLost() {
                        if (this.isActivated()) {
                            UIUtil.asyncExec(new Runnable(){

                                public void run() {
                                    try {
                                        if (button.isFocusControl()) {
                                            return;
                                        }
                                    }
                                    catch (Exception exception) {}
                                    try {
                                        this.fireApplyEditorValue();
                                        this.deactivate();
                                    }
                                    catch (Exception exception) {}
                                }
                            });
                        }
                    }
                };
            }
            return super.createEDataTypeCellEditor(eDataType, composite);
        }
    }
}

