/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IDialogSettingsProvider;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.Preferences;

public final class DialogSettingsProvider
implements IDialogSettingsProvider {
    private static final String INSTANCE_SCOPE = "instance";
    private static final String DEFAULT_SCOPE = "default";
    private static final String ORG_ECLIPSE_UI = "org.eclipse.ui";
    private static final String WORKBENCH = "Workbench";
    private static final String FN_DIALOG_SETTINGS = "dialog_settings.xml";
    private static final String KEY_DEFAULT_DIALOG_SETTINGS_ROOTURL = "default_dialog_settings_rootUrl";
    private Bundle fBundle;
    private IDialogSettings fDialogSettings;

    DialogSettingsProvider(Bundle bundle) {
        this.fBundle = bundle;
    }

    private static IDialogSettings loadDialogSettings(Bundle bundle) {
        IDialogSettings dialogSettings = DialogSettingsProvider.loadDialogSettingsFromWorkspace(bundle).orElseGet(() -> DialogSettingsProvider.loadDefaultDialogSettingsFromProduct(bundle).orElseGet(() -> DialogSettingsProvider.loadDefaultDialogSettingsFromBundle(bundle).orElseGet(() -> DialogSettingsProvider.createEmptySettings())));
        return dialogSettings;
    }

    private static Optional<IDialogSettings> loadDefaultDialogSettingsFromProduct(Bundle bundle) {
        URL url;
        IPreferencesService preferencesService = Platform.getPreferencesService();
        Preferences node = preferencesService.getRootNode().node(INSTANCE_SCOPE).node(ORG_ECLIPSE_UI);
        String rootUrl = node.get(KEY_DEFAULT_DIALOG_SETTINGS_ROOTURL, "");
        if ((rootUrl == null || rootUrl.isEmpty()) && ((rootUrl = (node = preferencesService.getRootNode().node(DEFAULT_SCOPE).node(ORG_ECLIPSE_UI)).get(KEY_DEFAULT_DIALOG_SETTINGS_ROOTURL, "")) == null || rootUrl.isEmpty())) {
            return Optional.empty();
        }
        String bundlePart = bundle.getSymbolicName() + "/dialog_settings.xml";
        String fullUrl = rootUrl.endsWith("/") ? rootUrl + bundlePart : rootUrl + "/" + bundlePart;
        try {
            url = new URL(fullUrl);
        }
        catch (MalformedURLException e) {
            ILog.of((Bundle)bundle).log((IStatus)new Status(4, bundle.getSymbolicName(), "Failed to load dialog settings from: " + fullUrl, (Throwable)e));
            return Optional.empty();
        }
        try {
            url = FileLocator.resolve((URL)url);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return Optional.empty();
        }
        catch (IOException e) {
            ILog.of((Bundle)bundle).log((IStatus)new Status(4, bundle.getSymbolicName(), "Failed to load dialog settings from: " + fullUrl, (Throwable)e));
            return Optional.empty();
        }
        try {
            Throwable e = null;
            Object var8_12 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
                IDialogSettings dialogSettings = DialogSettingsProvider.createEmptySettings();
                dialogSettings.load((Reader)reader);
                return Optional.of(dialogSettings);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            ILog.of((Bundle)bundle).log((IStatus)new Status(4, bundle.getSymbolicName(), "Failed to load dialog settings from: " + String.valueOf(url), (Throwable)e));
            return Optional.empty();
        }
    }

    private static Optional<IDialogSettings> loadDialogSettingsFromWorkspace(Bundle bundle) {
        IPath dataLocation = DialogSettingsProvider.getStateLocationOrNull(bundle);
        if (dataLocation == null) {
            return Optional.empty();
        }
        String readWritePath = dataLocation.append(FN_DIALOG_SETTINGS).toOSString();
        File settingsFile = new File(readWritePath);
        if (settingsFile.exists()) {
            try {
                IDialogSettings dialogSettings = DialogSettingsProvider.createEmptySettings();
                dialogSettings.load(readWritePath);
                return Optional.of(dialogSettings);
            }
            catch (IOException e) {
                ILog.of((Bundle)bundle).log((IStatus)new Status(4, bundle.getSymbolicName(), "Failed to load dialog settings from: " + String.valueOf(settingsFile), (Throwable)e));
            }
        }
        return Optional.empty();
    }

    private static Optional<IDialogSettings> loadDefaultDialogSettingsFromBundle(Bundle bundle) {
        URL dsURL = FileLocator.find((Bundle)bundle, (IPath)IPath.fromOSString((String)FN_DIALOG_SETTINGS));
        IDialogSettings dialogSettings = null;
        if (dsURL == null) {
            return Optional.empty();
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(dsURL.openStream(), StandardCharsets.UTF_8));){
                dialogSettings = DialogSettingsProvider.createEmptySettings();
                dialogSettings.load((Reader)reader);
                return Optional.of(dialogSettings);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            ILog.of((Bundle)bundle).log((IStatus)new Status(4, bundle.getSymbolicName(), "Failed to load dialog settings from: " + String.valueOf(dsURL), (Throwable)e));
            return Optional.empty();
        }
    }

    private static IDialogSettings createEmptySettings() {
        return new DialogSettings(WORKBENCH);
    }

    private static IPath getStateLocationOrNull(Bundle bundle) {
        try {
            return Platform.getStateLocation((Bundle)bundle);
        }
        catch (IllegalStateException e) {
            ILog.of((Bundle)bundle).log((IStatus)new Status(4, bundle.getSymbolicName(), "Failed to get state location for bundle: " + String.valueOf(bundle), (Throwable)e));
            return null;
        }
    }

    public synchronized IDialogSettings loadDialogSettings() {
        this.fDialogSettings = DialogSettingsProvider.loadDialogSettings(this.fBundle);
        return this.fDialogSettings;
    }

    public synchronized void saveDialogSettings() {
        DialogSettingsProvider.saveDialogSettings(this.fDialogSettings, this.fBundle);
    }

    public IDialogSettings getDialogSettings() {
        if (this.fDialogSettings == null) {
            this.loadDialogSettings();
        }
        return this.fDialogSettings;
    }

    private static void saveDialogSettings(IDialogSettings dialogSettings, Bundle bundle) {
        if (dialogSettings == null) {
            return;
        }
        try {
            IPath path = DialogSettingsProvider.getStateLocationOrNull(bundle);
            if (path == null) {
                return;
            }
            String readWritePath = path.append(FN_DIALOG_SETTINGS).toOSString();
            dialogSettings.save(readWritePath);
        }
        catch (IOException | IllegalStateException e) {
            ILog.of((Bundle)bundle).log((IStatus)new Status(4, bundle.getSymbolicName(), "No state location. Failed to save dialog settings for bundle: " + bundle.getBundleId(), (Throwable)e));
        }
    }
}

