/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.compress;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum ContentCoding {
    GZIP("gzip"),
    DEFLATE("deflate"),
    X_GZIP("x-gzip"),
    BROTLI("br"),
    ZSTD("zstd"),
    XZ("xz"),
    LZMA("lzma"),
    LZ4_FRAMED("lz4-framed"),
    LZ4_BLOCK("lz4-block"),
    BZIP2("bzip2"),
    PACK200("pack200"),
    DEFLATE64("deflate64");

    private static final Map<String, ContentCoding> TOKEN_LOOKUP;
    private final String token;

    private ContentCoding(String token) {
        this.token = token;
    }

    public String token() {
        return this.token;
    }

    public static ContentCoding fromToken(String token) {
        return token != null ? TOKEN_LOOKUP.get(token.toLowerCase(Locale.ROOT)) : null;
    }

    static {
        HashMap<String, ContentCoding> map = new HashMap<String, ContentCoding>(ContentCoding.values().length, 1.0f);
        for (ContentCoding contentCoding : ContentCoding.values()) {
            map.put(contentCoding.token, contentCoding);
        }
        TOKEN_LOOKUP = Collections.unmodifiableMap(map);
    }
}

