/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.api.workspace;

import java.util.Optional;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.loc.internal.api.workspace.ResourceHandle;

public interface Keys {
    public Optional<String> existing(String var1, String var2);

    public ResourceHandle located(String var1, String var2);

    public ResourceHandle locatedPub(String var1, String var2);

    public static final class Smart
    implements Keys {
        private final Keys delegate;

        public Smart(Keys delegate) {
            this.delegate = delegate;
        }

        @Override
        public Optional<String> existing(String product, String version) {
            return this.delegate.existing(product, version);
        }

        public Optional<String> existing(LicensedProduct product) {
            return this.existing(product.identifier(), product.version());
        }

        public boolean exists(LicensedProduct product) {
            return this.existing(product).isPresent();
        }

        @Override
        public ResourceHandle located(String product, String version) {
            return this.delegate.located(product, version);
        }

        public ResourceHandle located(LicensedProduct product) {
            return this.delegate.located(product.identifier(), product.version());
        }

        @Override
        public ResourceHandle locatedPub(String product, String version) {
            return this.delegate.locatedPub(product, version);
        }

        public ResourceHandle locatedPub(LicensedProduct product) {
            return this.delegate.locatedPub(product.identifier(), product.version());
        }
    }
}

