/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIComment;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContent;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.AnomalyUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Display;

public class PasteElementHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Pasting Element(s)...";

    public Object execute(ExecutionEvent event) {
        final ISelection selection = R4EUIModelController.getNavigatorView().getTreeViewer().getSelection();
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = R4EUIConstants.R4E_UI_JOB_FAMILY;
            }

            public boolean belongsTo(Object family) {
                return this.familyName.equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                Object target;
                R4EUIModelController.setJobInProgress(true);
                if (selection instanceof IStructuredSelection && (target = ((IStructuredSelection)selection).getFirstElement()) instanceof IR4EUIModelElement && target != null) {
                    final Object[] sourceSelection = new Object[1];
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            sourceSelection[0] = R4EUIModelController.getNavigatorView().getClipboardContents();
                        }
                    });
                    Object sourceElement2 = null;
                    if (sourceSelection[0] != null) {
                        for (Object sourceElement2 : (IStructuredSelection)sourceSelection[0]) {
                            if (target instanceof R4EUIContent && sourceElement2 instanceof R4EUIAnomalyBasic && AnomalyUtils.isAnomalyExist((R4EUIFileContext)((IR4EUIModelElement)target).getParent().getParent(), ((R4EUIContent)target).getPosition(), ((R4EUIAnomalyBasic)sourceElement2).getAnomaly().getDescription()) == null) {
                                try {
                                    AnomalyUtils.cloneLinkedAnomaly((R4EUIContent)target, sourceElement2);
                                }
                                catch (ResourceHandlingException e) {
                                    UIUtils.displayResourceErrorDialog(e);
                                }
                                catch (OutOfSyncException e) {
                                    UIUtils.displaySyncErrorDialog(e);
                                }
                                continue;
                            }
                            if (!(target instanceof R4EUIAnomalyBasic) || !(sourceElement2 instanceof R4EUIComment) || AnomalyUtils.isCommentExist((R4EUIAnomalyBasic)target, ((R4EUIComment)sourceElement2).getComment().getDescription()) != null) continue;
                            try {
                                IR4EUIModelElement newUIComment = ((R4EUIAnomalyBasic)target).createChildren((ReviewComponent)((R4EUIComment)sourceElement2).getComment());
                                UIUtils.setNavigatorViewFocus(newUIComment, -1);
                            }
                            catch (ResourceHandlingException e) {
                                UIUtils.displayResourceErrorDialog(e);
                            }
                            catch (OutOfSyncException e) {
                                UIUtils.displaySyncErrorDialog(e);
                            }
                            catch (CompatibilityException e) {
                                UIUtils.displayCompatibilityErrorDialog(e);
                            }
                        }
                    }
                }
                R4EUIModelController.setJobInProgress(false);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
        return null;
    }
}

