/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.internal.launching.Executable;
import org.eclipse.rcptt.launching.AutLaunch;

public class TestSuiteExecutable
extends Executable {
    private final AutLaunch launch;
    private final ITestSuite testSuite;
    private final Executable[] kids;

    public TestSuiteExecutable(AutLaunch launch, ITestSuite testSuite, Executable[] children, boolean debug) {
        super(debug);
        this.launch = launch;
        this.testSuite = testSuite;
        this.kids = new Executable[children.length];
        if (children.length > 0) {
            System.arraycopy(children, 0, this.kids, 0, children.length);
        }
    }

    @Override
    public String getName() {
        String nameByDocument = Q7SearchCore.findNameByDocument((IQ7Element)this.testSuite);
        if (nameByDocument != null) {
            return nameByDocument;
        }
        try {
            return this.testSuite.getElementName();
        }
        catch (ModelException modelException) {
            return "Unresolved element";
        }
    }

    @Override
    public AutLaunch getAut() {
        return this.launch;
    }

    @Override
    public IQ7NamedElement getActualElement() {
        return this.testSuite;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public Executable[] getChildren() {
        return this.kids;
    }

    @Override
    public void startLaunching() {
        if (this.kids.length > 0) {
            this.kids[0].startLaunching();
        }
    }

    @Override
    public IStatus execute() throws InterruptedException {
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus handleChildResult(IStatus resultStatus) {
        if (resultStatus.matches(8)) {
            return resultStatus;
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus postExecute(IStatus result) {
        Executable[] executableArray = this.getChildren();
        int n = executableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Executable child = executableArray[n2];
            IStatus status = child.getResultStatus();
            if (status != null && !status.isOK()) {
                result = status;
                break;
            }
            ++n2;
        }
        return result;
    }
}

