/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.internal.resources;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.index.IIndexDocument;
import org.eclipse.rcptt.core.model.index.IIndexer;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.ctx.resources.WSUtils;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.workspace.WSLink;
import org.eclipse.rcptt.workspace.WSRoot;
import org.eclipse.rcptt.workspace.WorkspaceContext;

public class WorkspaceContextIndexer
implements IIndexer {
    public void index(IIndexDocument document) {
        IQ7NamedElement element = null;
        try {
            element = document.getElement();
            if (!(element instanceof IContext)) {
                return;
            }
            NamedElement namedElement = element.getNamedElement();
            if (namedElement instanceof WorkspaceContext) {
                WorkspaceContext ctx = (WorkspaceContext)namedElement;
                WSRoot content = ctx.getContent();
                List<WSLink> listLinks = WSUtils.listLinks(content);
                for (WSLink wsLink : listLinks) {
                    IFile linkPath = WSUtils.getLinkResource(wsLink);
                    if (linkPath == null) {
                        linkPath = WSUtils.getLinkContainer(wsLink);
                    }
                    if (linkPath != null) {
                        document.addKey("ws_link", linkPath.getFullPath().toString());
                        continue;
                    }
                    document.addKey("ws_link", "***");
                }
            }
        }
        catch (ModelException e) {
            RcpttPlugin.log((Throwable)e);
        }
    }
}

