/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.rcptt.core.DefaultVerificationMaker;
import org.eclipse.rcptt.core.IVerificationMaker;
import org.eclipse.rcptt.core.IVerificationProcessor;
import org.eclipse.rcptt.core.ResolvedVerificationType;
import org.eclipse.rcptt.core.UnresolvedType;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.core.scenario.UnresolvedVerification;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.internal.core.RcpttPlugin;

public class VerificationTypeManager {
    private static VerificationTypeManager instance;
    private static final String EXPT_ID = "org.eclipse.rcptt.core.verificationTypes";
    private static final String PROCESSOR_EXPT_ID = "org.eclipse.rcptt.core.verificationProcessors";
    private static final String MAKER_EXPT_ID = "org.eclipse.rcptt.core.verificationMaker";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_CLASS = "class";
    private static Map<String, String> legacyTypes;
    private VerificationType[] types;
    private Map<EClass, VerificationType> classToType;
    private Map<String, VerificationType> idToType;
    private Map<String, IVerificationProcessor> idToProcessor;
    private Map<String, IVerificationMaker> idToMaker;

    static {
        legacyTypes = new HashMap<String, String>();
        legacyTypes.put("com.xored.q7.log.verification", "org.eclipse.rcptt.verifications.log");
        legacyTypes.put("com.xored.q7.text.verification", "org.eclipse.rcptt.verifications.text");
        legacyTypes.put("com.xored.q7.time.verification", "org.eclipse.rcptt.verifications.time");
        legacyTypes.put("com.xored.q7.tree.verification", "org.eclipse.rcptt.verifications.tree");
    }

    public static VerificationTypeManager getInstance() {
        if (instance == null) {
            instance = new VerificationTypeManager();
        }
        return instance;
    }

    public VerificationType getTypeByVerification(Verification verification) {
        this.init();
        if (verification instanceof UnresolvedVerification) {
            return UnresolvedType.INSTANCE;
        }
        VerificationType rv = this.classToType.get(verification.eClass());
        if (rv == null) {
            throw new IllegalArgumentException("Unknown verification type " + verification.eClass().getName());
        }
        return rv;
    }

    public VerificationType getTypeById(String id) {
        this.init();
        if (legacyTypes.containsKey(id)) {
            id = legacyTypes.get(id);
        }
        return this.idToType.get(id);
    }

    public VerificationType[] getTypes() {
        this.init();
        return this.types;
    }

    public synchronized IVerificationMaker getMaker(String verificationTypeId) {
        IVerificationMaker maker;
        if (this.idToMaker == null) {
            IConfigurationElement[] elements;
            this.idToMaker = new HashMap<String, IVerificationMaker>();
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(MAKER_EXPT_ID);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    String id = element.getAttribute(ATTR_TYPE);
                    IVerificationMaker processor = (IVerificationMaker)element.createExecutableExtension(ATTR_CLASS);
                    this.idToMaker.put(id, processor);
                }
                catch (CoreException e) {
                    RcpttPlugin.log(e);
                }
                ++n2;
            }
        }
        if ((maker = this.idToMaker.get(verificationTypeId)) == null) {
            return new DefaultVerificationMaker();
        }
        return maker;
    }

    public synchronized IVerificationProcessor getProcessor(String verificationTypeId) {
        if (this.idToProcessor == null) {
            IConfigurationElement[] elements;
            this.idToProcessor = new HashMap<String, IVerificationProcessor>();
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(PROCESSOR_EXPT_ID);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    String id = element.getAttribute(ATTR_TYPE);
                    IVerificationProcessor processor = (IVerificationProcessor)element.createExecutableExtension(ATTR_CLASS);
                    this.idToProcessor.put(id, processor);
                }
                catch (CoreException e) {
                    RcpttPlugin.log(e);
                }
                ++n2;
            }
        }
        return this.idToProcessor.get(verificationTypeId);
    }

    private synchronized void init() {
        IConfigurationElement[] elements;
        if (this.classToType != null) {
            return;
        }
        ArrayList<ResolvedVerificationType> list = new ArrayList<ResolvedVerificationType>();
        this.classToType = new HashMap<EClass, VerificationType>();
        this.idToType = new HashMap<String, VerificationType>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXPT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                ResolvedVerificationType type = new ResolvedVerificationType(element);
                list.add(type);
                this.classToType.put(type.getEClass(), type);
                this.idToType.put(type.getId(), type);
            }
            catch (CoreException e) {
                RcpttPlugin.log(e);
            }
            ++n2;
        }
        this.types = list.toArray(new VerificationType[list.size()]);
        Arrays.sort(this.types, new Comparator<VerificationType>(){

            @Override
            public int compare(VerificationType t1, VerificationType t2) {
                return -Integer.valueOf(t1.getPriority()).compareTo(t2.getPriority());
            }
        });
    }

    public Set<VerificationType> getTypesForWidgetClass(String class_) {
        HashSet<VerificationType> result = new HashSet<VerificationType>();
        VerificationType[] verificationTypeArray = this.getTypes();
        int n = verificationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            VerificationType t = verificationTypeArray[n2];
            if (t.supportsWidget(class_)) {
                result.add(t);
            }
            ++n2;
        }
        return result;
    }
}

